/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.account;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.framework.utils.FxButtons;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.richtextfx.RichStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;

public class LeaveIdentityProviderView
extends VBox {
    public VBox root = new VBox(12.0);
    private VBox contentBox = new VBox(16.0);
    private Button cardBtn;
    private StackPane btnWrapper;
    private Tooltip disabledTip;
    private final Runnable callback;
    private final BooleanProperty managedRestricted;

    public LeaveIdentityProviderView(Runnable callback, BooleanProperty managedRestricted) {
        this.callback = callback;
        this.managedRestricted = managedRestricted;
        this.configureContent();
        this.getChildren().addAll((Object[])new Node[]{this.contentBox});
    }

    public void setupView() {
        this.cardBtn.disableProperty().bind((ObservableValue)this.managedRestricted);
        this.managedRestricted.addListener(this::handleView);
        this.handleView((ObservableValue<? extends Boolean>)this.managedRestricted, null, this.managedRestricted.get());
    }

    public void cleanView() {
        this.cardBtn.disableProperty().unbind();
        this.managedRestricted.removeListener(this::handleView);
        Tooltip.uninstall((Node)this.btnWrapper, (Tooltip)this.disabledTip);
    }

    private void handleView(ObservableValue<? extends Boolean> obs, Boolean oldVal, Boolean newVal) {
        if (newVal.booleanValue()) {
            Tooltip.install((Node)this.btnWrapper, (Tooltip)this.disabledTip);
        } else {
            Tooltip.uninstall((Node)this.btnWrapper, (Tooltip)this.disabledTip);
        }
    }

    private void configureContent() {
        String btnLabel = ViewControllerHelper.getString("leave_identity_provider_confirm_button");
        this.cardBtn = FxButtons.create(this.callback).label(btnLabel).fullWidth().addStyleClasses("warning-button").addLabelStyleClasses("white-text").build();
        this.btnWrapper = new StackPane(new Node[]{this.cardBtn});
        this.disabledTip = new Tooltip(ViewControllerHelper.getString("leave_identity_provider_disabled_reason"));
        this.contentBox = this.createCard("icon-danger", ViewControllerHelper.getString("leave_identity_provider_title"), ViewControllerHelper.getString("leave_identity_provider_description"), null);
        this.contentBox.getChildren().add((Object)this.btnWrapper);
        VBox.setMargin((Node)this.btnWrapper, (Insets)new Insets(0.0, 32.0, 32.0, 32.0));
    }

    private VBox createCard(String iconKey, String title, String description, Button actionBtn) {
        VBox cardContainer = new VBox();
        SvgSizeable icon = new SvgSizeable();
        Label titleLabel = new Label();
        RichStyledArea descriptionArea = new RichStyledArea(RichStyledConfiguration.style());
        icon.getStyleClass().addAll((Object[])new String[]{iconKey, "icon-xxxxlarge"});
        titleLabel.setText(title);
        titleLabel.getStyleClass().addAll((Object[])new String[]{"h1-bold"});
        descriptionArea.setMaxWidth(553.0);
        descriptionArea.replaceText(description);
        descriptionArea.setTextAlignment(TextAlignment.CENTER);
        descriptionArea.setEditable(false);
        cardContainer.getChildren().addAll((Object[])new Node[]{icon, titleLabel, descriptionArea});
        if (actionBtn != null) {
            cardContainer.getChildren().add((Object)actionBtn);
            VBox.setMargin((Node)actionBtn, (Insets)new Insets(0.0, 32.0, 32.0, 32.0));
        }
        cardContainer.setMaxWidth(Double.MAX_VALUE);
        cardContainer.setMinHeight(266.0);
        cardContainer.setAlignment(Pos.CENTER);
        cardContainer.setSpacing(16.0);
        cardContainer.getStyleClass().addAll((Object[])new String[]{"setting-left-background", "rounded-background-pane"});
        VBox.setMargin((Node)icon, (Insets)new Insets(28.0, 0.0, 0.0, 0.0));
        VBox.setMargin((Node)titleLabel, (Insets)new Insets(0.0, 32.0, 0.0, 32.0));
        VBox.setMargin((Node)descriptionArea, (Insets)new Insets(0.0, 32.0, 0.0, 32.0));
        return cardContainer;
    }
}

