/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.account;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.engine.helpers.owned_identity.OwnedIdentityApi;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.misc.BytesKey;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;

public class AccountSettingViewModel {
    public final BooleanProperty isIdentityManaged = new SimpleBooleanProperty(false);
    public final BooleanProperty managedRestricted = new SimpleBooleanProperty(false);
    public final ObjectProperty<OwnedIdentityInfo> ownedIdentityInfoProperty = new SimpleObjectProperty();
    private final LiveDataListener<OwnedIdentityInfo> ownedIdentityListener = this::onOwnedIdentityChanged;
    LiveData<OwnedIdentityInfo> ownedIdentityLiveData;

    public AccountSettingViewModel(LiveData<OwnedIdentityInfo> ownedIdentityLiveData) {
        this.ownedIdentityLiveData = ownedIdentityLiveData;
    }

    public void onAttach() {
        this.ownedIdentityLiveData.addListener(this.ownedIdentityListener);
    }

    public void onDetach() {
        this.ownedIdentityLiveData.removeListener(this.ownedIdentityListener);
    }

    public void leaveIdentityProvider() {
        OwnedIdentityInfo info = (OwnedIdentityInfo)this.ownedIdentityInfoProperty.get();
        KeycloakManager.getInstance().unregisterKeycloakManagedIdentity(info.bytesOwnedIdentity());
        KeycloakManager.getInstance().unbindOwnedIdentityFromKeycloak(info.bytesOwnedIdentity());
    }

    public Optional<OwnedIdentity> deleteOwnedIdentity(boolean deleteEverywhere) {
        OwnedIdentityInfo info = (OwnedIdentityInfo)this.ownedIdentityInfoProperty.get();
        Optional<OwnedIdentityInfo> curInfo = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
        OwnedIdentity cur = null;
        if (curInfo.isPresent()) {
            cur = DbManager.getInstance().getOwnedIdentityDao().get(curInfo.get().genId());
        }
        List<OwnedIdentity> remaining = DbManager.getInstance().getOwnedIdentityDao().getAllSortedByIndexWithoutThisIdentity(info.genId());
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(info.genId());
        OwnedIdentityApi.deleteOwnedIdentityAndNotifyContacts(ownedIdentity, deleteEverywhere);
        if (remaining.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(cur != null && ((Id)curInfo.get().getItemId()).equals(info.genId()) ? remaining.getFirst() : Objects.requireNonNull(cur));
    }

    private void onOwnedIdentityChanged(OwnedIdentityInfo newValue, OwnedIdentityInfo oldValue) {
        this.ownedIdentityInfoProperty.set((Object)newValue);
        this.isIdentityManaged.set(newValue.isKeycloakManaged());
        this.managedRestricted.set(KeycloakManager.getInstance().isOwnedIdentityTransferRestricted(BytesKey.of(newValue.bytesOwnedIdentity())));
    }
}

