/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.engine.helpers.standalone_interfaces.AppSettingsHelper;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListPanelSelectModel;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.settings.IdentityItem;
import io.olvid.windows.messenger.fx.settings.backups.BackupSettingsViewModel;
import io.olvid.windows.messenger.fx.settings.category.AccountSettingCategory;
import io.olvid.windows.messenger.fx.settings.category.BackupSettingCategory;
import io.olvid.windows.messenger.fx.settings.category.DeviceSettingsCategory;
import io.olvid.windows.messenger.fx.settings.category.EditIdentityCategory;
import io.olvid.windows.messenger.fx.settings.category.GeneralSettingCategory;
import io.olvid.windows.messenger.fx.settings.category.ISettingsCategory;
import io.olvid.windows.messenger.fx.settings.category.NotificationSettingsCategory;
import io.olvid.windows.messenger.fx.settings.category.ProfileSelectorCategory;
import io.olvid.windows.messenger.fx.settings.category.UpdateSettingsCategory;
import io.olvid.windows.messenger.fx.settings.edit_identity.EditIdentitySettingViewModel;
import io.olvid.windows.messenger.fx.settings.misc.AutomaticAttachmentSizeDlThreshold;
import io.olvid.windows.messenger.fx.settings.misc.MuteDuration;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.cache.ApplicationSettingsDatabaseCache;
import io.olvid.windows.messenger.misc.state_pattern.SimpleContext;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;

public class SettingsModalModel {
    private final AppLogger logger;
    private final SimpleContext<ISettingsCategory> selectedCategoryContext;
    public ObservableList<ISettingsCategory> categoryObservableList;
    public final BooleanProperty updateNeededProperty;
    public final StringProperty currentAppVersionProperty;
    public BooleanProperty outdatedVersionProperty;
    public final ListPanelSelectModel<ISettingsCategory> listModel;
    public final BooleanProperty notificationCenterAvailableProp;
    public final BooleanProperty launchOnStartProp;
    public final BooleanProperty launchInBackgroundProp;
    public final BooleanProperty sendReadReceiptProp;
    public final ObjectProperty<AutomaticAttachmentSizeDlThreshold> automaticAttachmentSizeDlThreshold;
    public final BooleanProperty notificationDisabledProp;
    public final ObjectProperty<MuteDuration> muteDurationProp;
    public final BooleanProperty hideNotificationContent;
    final BackupSettingsViewModel backupSettingsViewModel;
    private final LiveDataListener<List<ApplicationSetting>> appSettingListener;
    private final ObservableList<IdentityItem> identityItems;
    private final Map<String, IdentityItem> itemById;
    private final ObjectProperty<IdentityItem> currentIdentity;
    public MutableLiveData<OwnedIdentityInfo> currentIdentityInfo;
    private final ObjectProperty<ISettingsCategory> currentCategory;
    List<OwnedIdentityInfo> ownedIdentityInfos;
    public final EditIdentitySettingViewModel editIdentitySettingViewModel;

    public ObservableList<IdentityItem> getIdentityItems() {
        return this.identityItems;
    }

    public ReadOnlyObjectProperty<IdentityItem> currentIdentityProperty() {
        return this.currentIdentity;
    }

    public IdentityItem getCurrentIdentity() {
        return (IdentityItem)this.currentIdentity.get();
    }

    /*
     * Exception decompiling
     */
    public SettingsModalModel() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void appSettingsListener(List<ApplicationSetting> newValue, List<ApplicationSetting> oldValue) {
        for (ApplicationSetting applicationSetting : newValue) {
            switch (applicationSetting.getPrefKey()) {
                case CLOUD_PROVIDER_BACKUP_CONF_SETTING_KEY: 
                case AUTOMATIC_BACKUP_SETTING_KEY: 
                case LAST_OWNED_IDENTITY: 
                case PREVIOUS_DOWNLOAD_DIRECTORY: 
                case RICH_TEXT_MODE: {
                    break;
                }
                case SEND_READ_RECEIPT_SETTING_KEY: {
                    ViewControllerHelper.smartUIUpdate(() -> this.sendReadReceiptProp.set(Boolean.parseBoolean(applicationSetting.getPrefValue())));
                    break;
                }
                case AUTOMATIC_ATTACHMENT_DOWNLOAD_SIZE_SETTING_KEY: {
                    ViewControllerHelper.smartUIUpdate(() -> this.automaticAttachmentSizeDlThreshold.set((Object)AutomaticAttachmentSizeDlThreshold.of(Integer.parseInt(applicationSetting.getPrefValue()))));
                    break;
                }
                case HIDE_NOTIFICATION_CONTENT: {
                    ViewControllerHelper.smartUIUpdate(() -> this.hideNotificationContent.set(Boolean.parseBoolean(applicationSetting.getPrefValue())));
                    break;
                }
                case MUTE_NOTIFICATION_TIMESTAMP: {
                    String timestampS = applicationSetting.getPrefValue();
                    ViewControllerHelper.smartUIUpdate(() -> {
                        if (timestampS == null) {
                            this.muteDurationProp.setValue((Object)MuteDuration.NONE);
                            this.notificationDisabledProp.set(true);
                        } else {
                            long timestamp = Long.parseLong(timestampS);
                            if (timestamp == -1L) {
                                this.muteDurationProp.setValue((Object)MuteDuration.INDEFINITELY);
                            } else {
                                this.muteDurationProp.setValue((Object)MuteDuration.ONE_HOUR);
                            }
                            this.notificationDisabledProp.set(false);
                        }
                    });
                }
            }
        }
    }

    public void updateState(ISettingsCategory settings) {
        this.currentCategory.set((Object)settings);
        ISettingsCategory iSettingsCategory = settings;
        Objects.requireNonNull(iSettingsCategory);
        ISettingsCategory iSettingsCategory2 = iSettingsCategory;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GeneralSettingCategory.class, BackupSettingCategory.class, NotificationSettingsCategory.class, UpdateSettingsCategory.class, EditIdentityCategory.class, DeviceSettingsCategory.class, AccountSettingCategory.class, ProfileSelectorCategory.class}, (Object)iSettingsCategory2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                GeneralSettingCategory ignored = (GeneralSettingCategory)iSettingsCategory2;
                this.selectedCategoryContext.pushState(settings);
                break;
            }
            case 1: {
                BackupSettingCategory ignored1 = (BackupSettingCategory)iSettingsCategory2;
                this.selectedCategoryContext.pushState(settings);
                break;
            }
            case 2: {
                NotificationSettingsCategory ignored2 = (NotificationSettingsCategory)iSettingsCategory2;
                this.selectedCategoryContext.pushState(settings);
                break;
            }
            case 3: {
                UpdateSettingsCategory ignored = (UpdateSettingsCategory)iSettingsCategory2;
                this.selectedCategoryContext.pushState(settings);
                break;
            }
            case 4: {
                EditIdentityCategory ignored = (EditIdentityCategory)iSettingsCategory2;
                this.selectedCategoryContext.pushState(settings);
                break;
            }
            case 5: {
                DeviceSettingsCategory ignored = (DeviceSettingsCategory)iSettingsCategory2;
                this.selectedCategoryContext.pushState(settings);
                break;
            }
            case 6: {
                AccountSettingCategory ignored = (AccountSettingCategory)iSettingsCategory2;
                this.selectedCategoryContext.pushState(settings);
                break;
            }
            case 7: {
                ProfileSelectorCategory ignored = (ProfileSelectorCategory)iSettingsCategory2;
                this.selectedCategoryContext.pushState(settings);
            }
        }
    }

    public void addContextListener(LiveDataListener<ISettingsCategory> settingCategoryConsumer) {
        this.selectedCategoryContext.getCurrentStateLiveData().addListener(settingCategoryConsumer);
        DbCache.getInstance().ownedIdentitiesInfo.addListener(this::buildIdentityItems);
    }

    public void removeContextListener(LiveDataListener<ISettingsCategory> settingCategoryConsumer) {
        this.selectedCategoryContext.getCurrentStateLiveData().removeListener(settingCategoryConsumer);
        DbCache.getInstance().ownedIdentitiesInfo.removeListener(this::buildIdentityItems);
    }

    public void buildIdentityItems(List<OwnedIdentityInfo> newValue, List<OwnedIdentityInfo> oldValue) {
        OwnedIdentityInfo currentIdentitySelected;
        Optional<OwnedIdentityInfo> currentIdentity = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
        if (currentIdentity.isEmpty()) {
            return;
        }
        OwnedIdentityInfo previousIdentity = (OwnedIdentityInfo)this.currentIdentityInfo.getValue();
        if (this.haveDetailsChanged(previousIdentity, currentIdentitySelected = newValue.stream().filter(i -> ((Id)i.getItemId()).getId() == ((Id)((OwnedIdentityInfo)this.currentIdentityInfo.getValue()).getItemId()).getId()).findFirst().orElse(currentIdentity.get()))) {
            this.currentIdentityInfo.postValue(currentIdentitySelected);
        }
        this.ownedIdentityInfos.clear();
        this.ownedIdentityInfos.addAll(newValue);
        this.identityItems.clear();
        List<OwnedIdentityInfo> filteredIdentities = newValue.stream().filter(i -> ((Id)i.getItemId()).getId() != ((Id)currentIdentitySelected.getItemId()).getId()).toList();
        for (OwnedIdentityInfo info : filteredIdentities) {
            this.identityItems.add((Object)this.getOrCreateItem(info));
        }
    }

    private boolean haveDetailsChanged(OwnedIdentityInfo previous, OwnedIdentityInfo current) {
        return !Objects.equals(previous.detailsInfo().firstName().orElse(null), current.detailsInfo().firstName().orElse(null)) || !Objects.equals(previous.detailsInfo().lastName().orElse(null), current.detailsInfo().lastName().orElse(null)) || !Objects.equals(previous.detailsInfo().company().orElse(null), current.detailsInfo().company().orElse(null)) || !Objects.equals(previous.detailsInfo().position().orElse(null), current.detailsInfo().position().orElse(null)) || !Objects.equals(previous.detailsInfo().photoUrl().orElse(null), current.detailsInfo().photoUrl().orElse(null)) || !Objects.equals(previous.nickname().orElse(null), current.nickname().orElse(null));
    }

    public BackupSettingsViewModel getBackViewModel() {
        return this.backupSettingsViewModel;
    }

    public void toggleNotification() {
        switch ((MuteDuration)this.muteDurationProp.get()) {
            case NONE: {
                this.muteDurationProp.set((Object)MuteDuration.ONE_HOUR);
                break;
            }
        }
    }

    public void setLaunchOnStart() {
        switch (AppRuntimeHelper.getStartupMode()) {
            case NONE: {
                AppRuntimeHelper.setStartupLaunchMode(AppRuntimeHelper.StartupMode.FOREGROUND);
                this.launchOnStartProp.setValue(Boolean.valueOf(true));
                break;
            }
            case FOREGROUND: 
            case BACKGROUND: {
                AppRuntimeHelper.setStartupLaunchMode(AppRuntimeHelper.StartupMode.NONE);
                this.launchOnStartProp.setValue(Boolean.valueOf(false));
            }
        }
    }

    public void setLaunchInBackground() {
        switch (AppRuntimeHelper.getStartupMode()) {
            case NONE: {
                this.logger.error("SettingsModalModel::Unexpected state");
                break;
            }
            case FOREGROUND: {
                AppRuntimeHelper.setStartupLaunchMode(AppRuntimeHelper.StartupMode.BACKGROUND);
                this.launchInBackgroundProp.setValue(Boolean.valueOf(true));
                break;
            }
            case BACKGROUND: {
                AppRuntimeHelper.setStartupLaunchMode(AppRuntimeHelper.StartupMode.FOREGROUND);
                this.launchInBackgroundProp.setValue(Boolean.valueOf(false));
            }
        }
    }

    public void setSendReadReceipt() {
        boolean value = ApplicationSettingsDatabaseCache.getInstance().getAsBoolean(ApplicationSetting.GlobalAppSettings.SEND_READ_RECEIPT_SETTING_KEY);
        ApplicationSettingsDatabaseCache.getInstance().set(ApplicationSetting.GlobalAppSettings.SEND_READ_RECEIPT_SETTING_KEY, String.valueOf(!value));
        this.sendReadReceiptProp.set(!value);
    }

    public void setHideNotificationContentPref() {
        boolean value = ApplicationSettingsDatabaseCache.getInstance().getAsBoolean(ApplicationSetting.GlobalAppSettings.HIDE_NOTIFICATION_CONTENT);
        ApplicationSettingsDatabaseCache.getInstance().set(ApplicationSetting.GlobalAppSettings.HIDE_NOTIFICATION_CONTENT, String.valueOf(!value));
        this.hideNotificationContent.set(!value);
    }

    public Optional<MuteDuration> getMuteDurationCombo() {
        switch (AppSettingsHelper.getMuteNotificationsTimestamp().kind()) {
            case NONE: {
                return Optional.of(MuteDuration.NONE);
            }
            case LIMITED: {
                return Optional.of(MuteDuration.ONE_HOUR);
            }
            case UNLIMITED: {
                return Optional.of(MuteDuration.INDEFINITELY);
            }
        }
        return Optional.empty();
    }

    public void selectIdentity(IdentityItem item) {
        if (item == null || item.equals(this.currentIdentity.get())) {
            return;
        }
        this.ownedIdentityInfos.stream().filter(oII -> item.id().equals(oII.genId().toString())).findFirst().ifPresent(oII -> {
            AppLogger.d("SettingsModalModel::selectIdentity identity selected: " + oII.getCustomDisplayNameOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY));
            this.currentIdentity.set((Object)this.getOrCreateItem((OwnedIdentityInfo)oII));
            this.identityItems.clear();
            List<OwnedIdentityInfo> filtered = this.ownedIdentityInfos.stream().filter(o -> !o.genId().equals(oII.genId())).toList();
            for (OwnedIdentityInfo contactInfo : filtered) {
                this.identityItems.add((Object)this.getOrCreateItem(contactInfo));
            }
            this.currentIdentityInfo.postValue((OwnedIdentityInfo)oII);
            ISettingsCategory editCat = this.categoryObservableList.stream().filter(c -> c instanceof EditIdentityCategory).findFirst().orElse(EditIdentityCategory.of());
            this.selectedCategoryContext.pushState(editCat);
        });
    }

    public OwnedIdentityInfo getOwnedIdentityInfo(IdentityItem item) {
        if (item == null) {
            return null;
        }
        return this.ownedIdentityInfos.stream().filter(oII -> item.id().equals(oII.genId().toString())).findFirst().orElse(null);
    }

    public IdentityItem getOrCreateItem(OwnedIdentityInfo info) {
        String id = info.genId().toString();
        IdentityItem item = this.itemById.computeIfAbsent(id, k -> new IdentityItem((String)k, "", null));
        item.setDisplayName(info.getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST));
        item.setPhoto(null);
        return item;
    }

    private /* synthetic */ void lambda$new$4(OwnedIdentityInfo ownedIdentityInfo) {
        this.currentIdentityInfo.postValue(ownedIdentityInfo);
    }

    private static /* synthetic */ List lambda$new$3() throws Exception {
        return DbManager.getInstance().getApplicationSettingsDao().getAll();
    }

    private /* synthetic */ void lambda$new$2(MessageFormat messageFormat, AppRuntimeHelper.AppVersionInfo newValue, AppRuntimeHelper.AppVersionInfo oldValue) {
        if (newValue == null) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> {
            this.updateNeededProperty.set(newValue.updateNeeded());
            this.currentAppVersionProperty.set((Object)messageFormat.format(new String[]{newValue.currentAppVersion()}));
            this.outdatedVersionProperty.set(newValue.outdated());
        });
    }
}

