/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.scenes_management;

import io.olvid.engine.secure_io.KeyManagerSingleton;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.fx.custom_components.loader.LoadingScreenController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.MainStackManager;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.TcpMessageNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.TcpServerNC;
import io.olvid.windows.messenger.misc.state_pattern.SimpleContext;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.util.List;
import java.util.Objects;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;

public class AppScenesManager {
    List<String> rawArgs;
    public static SimpleContext<GlobalAppState> globalAppStateContext = new SimpleContext();
    private final LiveDataListener<GlobalAppState> globalAppStateContextListener = this::globalAppStateContextListener;
    private static final double APP_RATIO = 1.6;
    private static final double HEIGHT_RATIO = 0.7;
    private static final double WINDOW_MIN_PREF_HEIGHT = 780.0;
    private static final double WINDOW_MAX_PREF_HEIGHT = 1000.0;
    private Double previousX = null;
    private Double previousY = null;
    private MainStackManager mainStackManager;
    static TcpServerNC.TcpMessageNotificationEnumType[] notificationsToListen = new TcpServerNC.TcpMessageNotificationEnumType[]{TcpServerNC.TcpMessageNotificationEnumType.NONE, TcpServerNC.TcpMessageNotificationEnumType.KEYCLOAK_CONFIGURATION_URI, TcpServerNC.TcpMessageNotificationEnumType.KEYCLOAK_AUTHENTICATION_REDIRECT_URI};

    public void init(List<String> rawArgs) {
        for (String arg : rawArgs) {
            AppLogger.d(arg);
        }
        this.rawArgs = rawArgs;
        globalAppStateContext.getCurrentStateLiveData().addListener(this.globalAppStateContextListener);
        NCRegistry.getTCPServerNC().subscribe(notificationsToListen, notificationType -> {
            if (AppScenesManager.globalAppStateContext.getCurrentState().appStateType != AppStateType.RUNNING_BACKGROUND) {
                return;
            }
            globalAppStateContext.pushState(new GlobalAppState(AppStateType.RUNNING_FOREGROUND));
        });
    }

    private void globalAppStateContextListener(GlobalAppState newValue, GlobalAppState oldValue) {
        AppLogger.d("AppScenesManager::globalAppStateContextListener()");
        if (newValue == null || newValue == oldValue) {
            return;
        }
        boolean runInBackground = !this.rawArgs.isEmpty() && "--background".equals(this.rawArgs.get(0));
        ViewControllerHelper.smartUIUpdate(() -> {
            StackPane root = null;
            Stage mainStage = ViewControllerHelper.MAIN_STAGE;
            switch (newValue.appStateType.ordinal()) {
                case 0: {
                    globalAppStateContext.pushState(new GlobalAppState(AppStateType.INITIALIZING));
                    break;
                }
                case 1: {
                    if (!runInBackground) {
                        LoadingScreenController loadingScreenController = new LoadingScreenController();
                        root = loadingScreenController.getLayout();
                    }
                    AsyncTaskExecutor.submitTask(() -> {
                        if (KeyManagerSingleton.getInstance().tryToInitKeyManagement(AppRuntimeHelper.OLVID_DATA_DIR_ABSOLUTE_PATH, "")) {
                            AppRuntimeHelper.initializeBackgroundComponents(false, runInBackground);
                        } else {
                            AppLogger.e("Couldn't initialize key manager, critical error ...");
                        }
                    });
                    break;
                }
                case 2: {
                    if (!mainStage.isShowing()) {
                        mainStage.show();
                    }
                    if (this.mainStackManager == null) {
                        this.mainStackManager = new MainStackManager();
                    }
                    root = this.mainStackManager.getContainer();
                    break;
                }
                case 3: {
                    this.previousX = mainStage.getX();
                    this.previousY = mainStage.getY();
                    mainStage.hide();
                    return;
                }
                default: {
                    AppLogger.d(String.valueOf(newValue) + " state not handled...");
                }
            }
            if (root == null) {
                AppLogger.d("view container is null for global state --> " + String.valueOf((Object)newValue.appStateType));
                return;
            }
            Screen screen = Screen.getPrimary();
            Rectangle2D screenBounds = screen.getVisualBounds();
            double screenHeightFraction = screenBounds.getHeight() * 0.7;
            double minHeight = Math.min(screenBounds.getHeight(), 780.0);
            double maxHeight = Math.min(screenBounds.getHeight(), 1000.0);
            double prefHeight = Math.min(Math.max(minHeight, screenHeightFraction), maxHeight);
            double maxWidth = maxHeight * 1.6;
            if (maxWidth > screenBounds.getWidth()) {
                double ratio = screenBounds.getWidth() / maxWidth;
                minHeight *= ratio;
                prefHeight *= ratio;
            }
            double minWidth = minHeight * 1.6;
            double prefWidth = prefHeight * 1.6;
            root.setPrefHeight(prefHeight);
            root.setPrefWidth(prefWidth);
            root.setMinHeight(minHeight);
            root.setMinWidth(minWidth);
            root.requestFocus();
            if (root.getScene() == null) {
                Scene scene = new Scene((Parent)root);
                AppScenesManager.addCssStyleSheet(scene);
            }
            mainStage.setScene(root.getScene());
            if (this.previousX != null && this.previousY != null) {
                mainStage.setX(this.previousX.doubleValue());
                mainStage.setY(this.previousY.doubleValue());
            }
            mainStage.show();
            Window window = mainStage.getScene().getWindow();
            double titleBarHeight = window.getHeight() - mainStage.getScene().getHeight();
            if (prefHeight + titleBarHeight > screenBounds.getHeight()) {
                mainStage.setHeight(mainStage.getHeight() - titleBarHeight);
                if (mainStage.getY() < 0.0) {
                    mainStage.setY(0.0);
                }
            }
            if (!this.rawArgs.isEmpty() && !"--background".equals(this.rawArgs.getFirst())) {
                TcpServerNC.TcpMessageNotificationEnumType messageEnumType = AppRuntimeHelper.getArgType(this.rawArgs.getFirst());
                TcpMessageNotification tcpMessageNotification = new TcpMessageNotification(messageEnumType.messageId, this.rawArgs.getFirst());
                NCRegistry.getTCPServerNC().postNotification(tcpMessageNotification);
            }
        });
    }

    public static void addCssStyleSheet(Scene scene) {
        scene.getStylesheets().add((Object)Objects.requireNonNull(ViewControllerHelper.class.getClassLoader().getResource("fx/design_system/color.css")).toExternalForm());
        scene.getStylesheets().add((Object)Objects.requireNonNull(ViewControllerHelper.class.getClassLoader().getResource("fx/design_system/light_mode.css")).toExternalForm());
        scene.getStylesheets().add((Object)Objects.requireNonNull(ViewControllerHelper.class.getClassLoader().getResource("fx/design_system/font.css")).toExternalForm());
        scene.getStylesheets().add((Object)Objects.requireNonNull(ViewControllerHelper.class.getClassLoader().getResource("fx/design_system/pane.css")).toExternalForm());
        scene.getStylesheets().add((Object)Objects.requireNonNull(ViewControllerHelper.class.getClassLoader().getResource("fx/design_system/buttons.css")).toExternalForm());
        scene.getStylesheets().add((Object)Objects.requireNonNull(ViewControllerHelper.class.getClassLoader().getResource("fx/design_system/icon.css")).toExternalForm());
        scene.getStylesheets().add((Object)Objects.requireNonNull(ViewControllerHelper.class.getClassLoader().getResource("fx/design_system/shape.css")).toExternalForm());
        scene.getStylesheets().add((Object)Objects.requireNonNull(ViewControllerHelper.class.getClassLoader().getResource("fx/design_system/other.css")).toExternalForm());
        scene.getStylesheets().add((Object)Objects.requireNonNull(ViewControllerHelper.class.getClassLoader().getResource("fx/design_system/list.css")).toExternalForm());
    }

    public record GlobalAppState(AppStateType appStateType) {
    }

    public static enum AppStateType {
        PREREQUISITE,
        INITIALIZING,
        RUNNING_FOREGROUND,
        RUNNING_BACKGROUND;

    }
}

