/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.owned_identities;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.BubbleAndDescription;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableSet;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class OwnedIdentityDisplayView
extends BubbleAndDescription {
    private final SimpleObjectProperty<Id<OwnedIdentity>> ownedId = new SimpleObjectProperty(null);
    private final Label inactiveLabel = new Label();

    public OwnedIdentityDisplayView(Optional<ObservableSet<Id<OwnedIdentity>>> unreadLiveDataOpt) {
        unreadLiveDataOpt.ifPresent(ids -> this.bubble.bindUnreadVisibility((ObservableValue<Boolean>)Bindings.createBooleanBinding(() -> ids.contains(this.ownedId.get()), (Observable[])new Observable[]{ids, this.ownedId})));
        BorderPane.setMargin((Node)this.bubble, (Insets)new Insets(0.0, 12.0, 0.0, 4.0));
        this.rightVBox.maxHeightProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)this.title.heightProperty(), (ObservableNumberValue)this.subtitleHeightProperty()));
        this.inactiveLabel.managedProperty().bind((ObservableValue)this.inactiveLabel.visibleProperty());
        this.inactiveLabel.getStyleClass().add((Object)"tag-grey");
        this.inactiveLabel.setVisible(false);
        VBox.setMargin((Node)this.inactiveLabel, (Insets)new Insets(0.0, 8.0, 0.0, 0.0));
        this.inactiveLabel.setText(ViewControllerHelper.getString("inactive_identity_label"));
        Tooltip inactiveLabelTooltip = new Tooltip(ViewControllerHelper.getString("inactive_identity_tooltip"));
        inactiveLabelTooltip.setShowDelay(Duration.millis((double)200.0));
        this.inactiveLabel.setTooltip(inactiveLabelTooltip);
        this.rightVBox.getChildren().add((Object)this.inactiveLabel);
    }

    public void setOwnedIdentity(OwnedIdentityInfo ownedIdentity) {
        this.title.setText(ownedIdentity.getCustomDisplayNameOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY));
        this.setSubtitle(ownedIdentity.detailsInfo().getDisplayName(IdentityDetailsInfo.Format.POSITION_COMPANY));
        BubbleUtils.setBubbleData(ownedIdentity, this.bubble);
        this.ownedId.set(ownedIdentity.getItemId());
        this.inactiveLabel.setVisible(!ownedIdentity.isActive());
    }
}

