/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.owned_identities;

import io.olvid.windows.messenger.database.tables.OwnedDevice;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.OptionalUtils;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.misc.DateUtils;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;

public record DeviceInfo(String name, Optional<byte[]> uid, boolean isCurrent, Optional<Long> lastRegistrationTimestamp) implements Diffable
{
    public DeviceInfo(OwnedDevice ownedDevice) {
        this(ownedDevice.getDisplayNameOrDeviceHexName(), Optional.of(ownedDevice.getBytesDeviceUid()), ownedDevice.isCurrentDevice(), ownedDevice.getLastRegistrationTimestamp());
    }

    @Override
    public Object getItemId() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceInfo that = (DeviceInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.uid, that.uid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.uid);
    }

    @Override
    public boolean areContentTheSame(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceInfo that = (DeviceInfo)o;
        return Objects.equals(this.name, that.name) && OptionalUtils.equals(this.uid, that.uid);
    }

    public String getDescription() {
        if (this.uid().isEmpty()) {
            return ViewControllerHelper.getString("text_new_device");
        }
        if (this.isCurrent()) {
            return ViewControllerHelper.getString("text_this_device");
        }
        if (this.lastRegistrationTimestamp().isPresent()) {
            LocalDateTime date = DateUtils.of(this.lastRegistrationTimestamp().get());
            String formattedDate = DateUtils.formatTimeOrDate(date);
            MessageFormat messageFormat = new MessageFormat(ViewControllerHelper.getString("text_last_online"));
            return messageFormat.format(new String[]{formattedDate});
        }
        return ViewControllerHelper.getString("text_other_device");
    }
}

