/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.notifications;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.ContactRefGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionApi;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.engine.helpers.standalone_interfaces.AppSettingsHelper;
import io.olvid.windows.messenger.engine.helpers.standalone_interfaces.ContactApi;
import io.olvid.windows.messenger.engine.service.AbstractExpirationTimerService;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.OptionalUtils;
import io.olvid.windows.messenger.fx.scenes_management.AppScenesManager;
import io.olvid.windows.messenger.fx.settings.misc.MuteDuration;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.cache.UnreadMessageCountCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.StringUtils;
import io.olvid.windows.messenger.misc.Watches;
import io.olvid.windows.messenger.misc.cache.ApplicationSettingsDatabaseCache;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UtilityNC;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.awt.AWTException;
import java.awt.Frame;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class NotificationCenter
extends AbstractExpirationTimerService {
    private static NotificationCenter instance = null;
    private final AppLogger logger = new AppLogger(this.getClass());
    private Optional<TrayIcon> trayIcon = Optional.empty();
    private Optional<SystemTray> systemTray = Optional.empty();
    private Image icon;
    private Image unreadMessageIcon;
    private Image muteIcon;

    public static synchronized NotificationCenter getInstance() {
        if (instance == null) {
            instance = new NotificationCenter();
        }
        return instance;
    }

    private NotificationCenter() {
        this.configureTray();
        NCRegistry.getUtilityNC().subscribe(UtilityNC.UtilityNotificationEnumType.SCHEDULE_MUTE_NOTIFICATION, n -> this.scheduleNextExpiration());
    }

    private void configureTray() {
        if (!AppRuntimeHelper.isBackgroundModeSupported()) {
            return;
        }
        this.systemTray = Optional.of(SystemTray.getSystemTray());
        this.icon = Toolkit.getDefaultToolkit().createImage(ViewControllerHelper.class.getClassLoader().getResource("fx/icons/olvid/ic-launcher.png"));
        this.unreadMessageIcon = Toolkit.getDefaultToolkit().createImage(ViewControllerHelper.class.getClassLoader().getResource("fx/icons/olvid/ic-tray-notif.gif"));
        this.muteIcon = Toolkit.getDefaultToolkit().createImage(ViewControllerHelper.class.getClassLoader().getResource("fx/icons/olvid/ic-launcher-mute.png"));
        TrayIcon trayIcon = new TrayIcon(this.icon, "Olvid");
        trayIcon.setImageAutoSize(true);
        trayIcon.setToolTip("Olvid Desktop");
        this.configureAction(trayIcon);
        this.configureNotificationsAction(trayIcon);
        try {
            this.systemTray.get().add(trayIcon);
            this.trayIcon = Optional.of(trayIcon);
        }
        catch (AWTException e) {
            this.logger.error("Cannot add TrayIcon", e);
            this.trayIcon = Optional.empty();
            return;
        }
        UnreadMessageCountCache.getInstance().getUnreadCountLiveData().addListener((newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(this::updateIcon));
        LiveData<Optional> muteLiveData = LiveDataFactory.buildDbLiveDataItemField(() -> DbManager.getInstance().getApplicationSettingsDao().getAppConfigSettingItem(ApplicationSetting.GlobalAppSettings.MUTE_NOTIFICATION_TIMESTAMP), List.of(ApplicationSetting.class));
        muteLiveData.addListener((newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(this::updateIcon));
    }

    private void updateIcon() {
        boolean isMute;
        if (this.trayIcon.isEmpty()) {
            return;
        }
        boolean bl = isMute = ApplicationSettingsDatabaseCache.getInstance().get(ApplicationSetting.GlobalAppSettings.MUTE_NOTIFICATION_TIMESTAMP) != null;
        if (isMute) {
            this.trayIcon.get().setImage(this.muteIcon);
            return;
        }
        UnreadMessageCountCache.Info value = UnreadMessageCountCache.getInstance().getUnreadCountLiveData().getValue();
        if (value.getOwnedIdentitiesWithUnreadMessages().isEmpty()) {
            this.trayIcon.get().setImage(this.icon);
        } else {
            this.trayIcon.get().setImage(this.unreadMessageIcon);
        }
    }

    private void configureAction(TrayIcon trayIcon) {
        trayIcon.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    NotificationCenter.this.openApp();
                } else {
                    final JDialog hiddenDialog = new JDialog((Frame)null, "");
                    hiddenDialog.setUndecorated(true);
                    hiddenDialog.setAlwaysOnTop(true);
                    hiddenDialog.setDefaultCloseOperation(2);
                    hiddenDialog.getContentPane().setLayout(null);
                    hiddenDialog.setType(Window.Type.POPUP);
                    hiddenDialog.pack();
                    hiddenDialog.setBounds(0, 0, 0, 0);
                    hiddenDialog.setVisible(true);
                    JPopupMenu menu = new JPopupMenu();
                    menu.setFocusable(true);
                    NotificationCenter.this.configureMenu(menu);
                    menu.setLocation(e.getX(), e.getY());
                    menu.setInvoker(hiddenDialog.getContentPane());
                    menu.setVisible(true);
                    menu.setBorder(BorderFactory.createEmptyBorder());
                    menu.requestFocusInWindow();
                    menu.addPopupMenuListener(new PopupMenuListener(){

                        @Override
                        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        }

                        @Override
                        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                            hiddenDialog.setVisible(false);
                            hiddenDialog.toBack();
                        }

                        @Override
                        public void popupMenuCanceled(PopupMenuEvent e) {
                        }
                    });
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private void configureNotificationsAction(TrayIcon trayIcon) {
        if (AppRuntimeHelper.isMac()) {
            return;
        }
        trayIcon.addActionListener(action -> {
            long discussionIdAsLong;
            String actionCommand;
            if (AppScenesManager.globalAppStateContext.getCurrentState().appStateType() == AppScenesManager.AppStateType.RUNNING_BACKGROUND) {
                AppScenesManager.globalAppStateContext.pushState(new AppScenesManager.GlobalAppState(AppScenesManager.AppStateType.RUNNING_FOREGROUND));
            }
            if ((actionCommand = action.getActionCommand()) == null) {
                return;
            }
            try {
                discussionIdAsLong = Long.parseLong(actionCommand);
            }
            catch (Exception e) {
                this.logger.error("configureNotificationsAction: cannot parse action command", e);
                return;
            }
            AsyncTaskExecutor.submitTask(() -> {
                Id<Discussion> discussionId = new Id<Discussion>(Discussion.class, discussionIdAsLong);
                Discussion discussion = DbManager.getInstance().getDiscussionDao().get(discussionId);
                if (discussion == null) {
                    return;
                }
                Optional<Id<OwnedIdentity>> selectedOwnedIdentityId = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityId();
                if (selectedOwnedIdentityId.isEmpty()) {
                    return;
                }
                if (!selectedOwnedIdentityId.get().equals(discussion.getOwnedIdentityId())) {
                    return;
                }
                NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, discussion.getItemId()));
            });
        });
    }

    private void openApp() {
        if (AppScenesManager.globalAppStateContext.getCurrentState().appStateType() != AppScenesManager.AppStateType.RUNNING_BACKGROUND) {
            return;
        }
        AppScenesManager.globalAppStateContext.pushState(new AppScenesManager.GlobalAppState(AppScenesManager.AppStateType.RUNNING_FOREGROUND));
    }

    private void configureMenu(JPopupMenu menu) {
        String timestampAsString;
        if (AppScenesManager.globalAppStateContext.getCurrentState().appStateType() == AppScenesManager.AppStateType.RUNNING_BACKGROUND) {
            JMenuItem openItem = new JMenuItem(ViewControllerHelper.getString("tray_open"));
            openItem.addActionListener(e -> this.openApp());
            menu.add(openItem);
        }
        if ((timestampAsString = ApplicationSettingsDatabaseCache.getInstance().get(ApplicationSetting.GlobalAppSettings.MUTE_NOTIFICATION_TIMESTAMP)) == null) {
            JMenu muteMenu = new JMenu(ViewControllerHelper.getString("settings_disable_notifications_label"));
            for (MuteDuration muteDuration : MuteDuration.values()) {
                if (muteDuration == MuteDuration.NONE) continue;
                muteMenu.add(muteDuration.getJMenuItem());
            }
            menu.add(muteMenu);
        } else {
            menu.add(MuteDuration.NONE.getJMenuItem());
        }
        menu.add(new JSeparator());
        JMenuItem exitItem = new JMenuItem(ViewControllerHelper.getString("tray_exit"));
        exitItem.addActionListener(e -> {
            if (AppRuntimeHelper.watchLogDelay.isPresent()) {
                Watches.getInstance().print();
            }
            Platform.exit();
        });
        menu.add(exitItem);
    }

    @Override
    protected Optional<Long> getNextExpiration() {
        Optional<Long> prefMuteNotificationsTimestamp = DbManager.getInstance().getDiscussionCustomizationDao().getNextUnmuteTimestamp();
        Optional<Long> muteNotificationsTimestamp = AppSettingsHelper.getMuteNotificationsTimestamp().getLimitedTimestamp();
        return OptionalUtils.longMin(prefMuteNotificationsTimestamp, muteNotificationsTimestamp);
    }

    @Override
    protected void expirationAction() {
        long currentTimeMillis = System.currentTimeMillis();
        int updatedDiscussionCount = DbManager.getInstance().getDiscussionCustomizationDao().resetExpiredMuteNotificationsTimestamp(currentTimeMillis);
        this.logger.info(String.format("Unmute %d discussion(s)", updatedDiscussionCount));
        Optional<Long> muteNotificationsTimestamp = AppSettingsHelper.getMuteNotificationsTimestamp().getLimitedTimestamp();
        if (muteNotificationsTimestamp.isPresent() && muteNotificationsTimestamp.get() != -1L && currentTimeMillis >= muteNotificationsTimestamp.get()) {
            AppSettingsHelper.updateMuteDuration(MuteDuration.NONE);
            this.logger.info("Unmute app ", updatedDiscussionCount);
        }
    }

    private void postHiddenNotification() {
        if (this.trayIcon.isEmpty()) {
            return;
        }
        String notificationTitle = ViewControllerHelper.getString("text_neutral_notification");
        this.trayIcon.get().displayMessage(notificationTitle, null, TrayIcon.MessageType.NONE);
    }

    private boolean isNotificationMute(Id<Discussion> discussionId) {
        AppSettingsHelper.Timestamp muteNotificationsTimestamp = AppSettingsHelper.getMuteNotificationsTimestamp();
        switch (muteNotificationsTimestamp.kind()) {
            case NONE: {
                break;
            }
            case LIMITED: {
                assert (muteNotificationsTimestamp.getLimitedTimestamp().isPresent());
                if (System.currentTimeMillis() >= muteNotificationsTimestamp.getLimitedTimestamp().get()) break;
                return true;
            }
            case UNLIMITED: {
                return true;
            }
        }
        DiscussionCustomization discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization(discussionId);
        Optional<Long> muteNotificationsTimestampOpt = discussionCustomization.getPrefMuteNotificationsTimestamp();
        if (muteNotificationsTimestampOpt.isPresent()) {
            long timestamp = muteNotificationsTimestampOpt.get();
            if (System.currentTimeMillis() < timestamp || timestamp == -1L) {
                return true;
            }
        }
        return false;
    }

    public void post(InboundMessage message) {
        Optional<String> contentOpt;
        ViewControllerHelper.checkNotUIThread();
        if (this.trayIcon.isEmpty()) {
            return;
        }
        if (this.isNotificationMute(message.getDiscussionId())) {
            return;
        }
        boolean hideNotificationContent = ApplicationSettingsDatabaseCache.getInstance().getAsBoolean(ApplicationSetting.GlobalAppSettings.HIDE_NOTIFICATION_CONTENT);
        if (hideNotificationContent) {
            this.postHiddenNotification();
            return;
        }
        StringBuilder notificationTitle = new StringBuilder();
        StringBuilder notificationContent = new StringBuilder();
        Id<Discussion> discussionId = message.getDiscussionId();
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(discussionId);
        if (discussion.isGroupDiscussion()) {
            String title = DiscussionApi.computeTitle(discussion);
            notificationContent.append(title);
            notificationContent.append(System.lineSeparator());
        }
        if ((contentOpt = MessageHelper.getStringContent(message)).isPresent()) {
            notificationContent.append(contentOpt.get());
        }
        int attachmentCount = message.getTotalAttachmentCount();
        if (!message.isBoxed() && attachmentCount > 0) {
            notificationContent.append(System.lineSeparator());
            if (attachmentCount == 1) {
                notificationContent.append(ViewControllerHelper.getString("one_attachment_count"));
            } else {
                notificationContent.append(MessageFormat.format(ViewControllerHelper.getString("multiple_attachment_count"), attachmentCount));
            }
        }
        Id<ContactRef> senderId = message.getSenderId();
        ContactRef contactRef = DbManager.getInstance().getContactRefDao().get(senderId);
        if (contactRef.getContactId().isEmpty()) {
            this.logger.error("Cannot found ContactRef from InboundMessage ");
            return;
        }
        Id<Contact> contactId = contactRef.getContactId().get();
        String displayName = ContactApi.getDisplayName(contactId, IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY);
        notificationTitle.append(displayName);
        this.trayIcon.get().setActionCommand(Long.toString(message.getDiscussionId().getId()));
        this.trayIcon.get().displayMessage(StringUtils.ifEmptyThenNull(notificationTitle.toString()), StringUtils.ifEmptyThenNull(notificationContent.toString()), TrayIcon.MessageType.NONE);
    }

    public void post(Invitation invitation) {
        String title;
        ViewControllerHelper.checkNotUIThread();
        if (this.trayIcon.isEmpty()) {
            return;
        }
        if (this.isNotificationMute((Id<Discussion>)invitation.getDiscussion().getItemId())) {
            return;
        }
        boolean hideNotificationContent = ApplicationSettingsDatabaseCache.getInstance().getAsBoolean(ApplicationSetting.GlobalAppSettings.HIDE_NOTIFICATION_CONTENT);
        if (hideNotificationContent) {
            this.postHiddenNotification();
            return;
        }
        StringBuilder notificationTitle = new StringBuilder();
        StringBuilder notificationContent = new StringBuilder();
        String discussionTitle = DiscussionApi.computeTitle(invitation.getDiscussion());
        switch (invitation.getState()) {
            case INVITATION_WAIT_YOU_TO_ACCEPT: {
                notificationContent.append(ViewControllerHelper.getString("new_invitation_message", discussionTitle));
                break;
            }
            case INVITATION_WAIT_YOU_FOR_SAS_EXCHANGE: {
                notificationContent.append(ViewControllerHelper.getString("invitation_status_description_enter_their_sas_notification", discussionTitle));
                break;
            }
            case INTRODUCTION_WAIT_YOU_TO_ACCEPT: {
                Optional mediatorInfo = invitation.getMediatorRef().flatMap(ContactRefGenerated::getContactId).flatMap(id -> DbCache.getInstance().getContactInfo((Id<Contact>)id));
                if (mediatorInfo.isPresent()) {
                    notificationContent.append(ViewControllerHelper.getString("new_invitation_via_mediator_message", discussionTitle, ((ContactInfo)mediatorInfo.get()).getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY)));
                    break;
                }
                notificationContent.append(ViewControllerHelper.getString("new_invitation_message", discussionTitle));
                break;
            }
            case GROUP_V1_INVITATION_WAIT_YOU_TO_ACCEPT: 
            case GROUP_V2_INVITATION_WAIT_YOU_TO_ACCEPT: {
                title = DiscussionApi.computeTitle(invitation.getDiscussion());
                notificationContent.append(ViewControllerHelper.getString("new_group_invitation_via_message_notification", title));
                break;
            }
            case ONE_TO_ONE_INVITATION_WAIT_YOU_TO_ACCEPT: {
                notificationContent.append(ViewControllerHelper.getString("new_one_to_one_invitation_message", discussionTitle));
                break;
            }
            case GROUP_V2_INVITATION_FROZEN: 
            case INVITATION_WAIT_IT_FOR_SAS_EXCHANGE: 
            case INTRODUCTION_WAIT_IT_TO_ACCEPT: 
            case INVITATION_STATUS_IN_PROGRESS: 
            case INVITATION_WAIT_IT_TO_ACCEPT: 
            case ONE_TO_ONE_INVITATION_WAIT_IT_TO_ACCEPT: 
            case GROUP_V2_INVITATION_ACCEPTED: {
                return;
            }
        }
        this.trayIcon.get().setActionCommand(Long.toString(((Id)invitation.getDiscussion().getItemId()).getId()));
        title = StringUtils.ifEmptyThenNull(notificationTitle.toString());
        String content = StringUtils.ifEmptyThenNull(notificationContent.toString());
        if (title != null || content != null) {
            this.trayIcon.get().displayMessage(title, content, TrayIcon.MessageType.NONE);
        }
    }

    public void removeTrayIcon() {
        if (this.trayIcon.isPresent() && this.systemTray.isPresent()) {
            this.systemTray.get().remove(this.trayIcon.get());
        }
    }
}

