/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.standard_ui.state_builder;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.modal.standard_ui.button.ButtonBuilder;
import io.olvid.windows.messenger.fx.modal.standard_ui.button.ModalButtonType;
import io.olvid.windows.messenger.fx.modal.standard_ui.state_builder.ModalBuilder;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jetbrains.annotations.NotNull;

public class ModalInnerNodeWrapperController
extends BaseViewController {
    private Region root;

    public ModalInnerNodeWrapperController(ModalBuilder modalBuilder) {
        this.createModalPanel(modalBuilder);
    }

    private void createModalPanel(ModalBuilder builder) {
        VBox mainVbox = this.createVBox(builder);
        if (builder.floatingButton != null) {
            StackPane mainStackPane = new StackPane();
            StackPane.setMargin((Node)builder.floatingButton, (Insets)new Insets(24.0));
            StackPane.setAlignment((Node)builder.floatingButton, (Pos)Pos.BOTTOM_RIGHT);
            mainStackPane.getChildren().setAll((Object[])new Node[]{mainVbox, builder.floatingButton});
            mainStackPane.getStyleClass().add((Object)"modal");
            mainStackPane.setMaxHeight(Double.NEGATIVE_INFINITY);
            this.root = mainStackPane;
        } else {
            mainVbox.getStyleClass().add((Object)"modal");
            mainVbox.setMaxHeight(Double.NEGATIVE_INFINITY);
            this.root = mainVbox;
        }
    }

    private VBox createVBox(ModalBuilder builder) {
        HBox titleHBox = this.createTitleBox(builder);
        StackPane innerModalContainer = this.createInnerModalContainer(builder);
        VBox mainVBox = new VBox(new Node[]{titleHBox, innerModalContainer});
        if (builder.bottomButton.size() > 0) {
            HBox bottomHBox = this.createBottomButtonBox(builder);
            mainVBox.getChildren().add((Object)bottomHBox);
            mainVBox.setPadding(new Insets(32.0, 24.0, 32.0, 24.0));
        } else {
            mainVBox.setPadding(new Insets(32.0, 24.0, 18.0, 24.0));
        }
        return mainVBox;
    }

    @NotNull
    private StackPane createInnerModalContainer(ModalBuilder builder) {
        StackPane innerModalContainer = new StackPane(new Node[]{builder.innerNode});
        innerModalContainer.setAlignment(Pos.TOP_CENTER);
        VBox.setVgrow((Node)innerModalContainer, (Priority)Priority.ALWAYS);
        return innerModalContainer;
    }

    @NotNull
    private HBox createBottomButtonBox(ModalBuilder builder) {
        builder.bottomButton.stream().filter(it -> it.type().equals((Object)ModalButtonType.CANCEL)).forEach(cancelButton -> cancelButton.button().setOnAction(event -> builder.close.run()));
        HBox bottomHBox = new HBox((Node[])builder.bottomButton.stream().map(ButtonBuilder.ButtonData::button).toArray(Node[]::new));
        bottomHBox.setAlignment(Pos.CENTER_RIGHT);
        bottomHBox.setSpacing(12.0);
        VBox.setMargin((Node)bottomHBox, (Insets)new Insets(12.0, 0.0, 0.0, 0.0));
        return bottomHBox;
    }

    @NotNull
    private HBox createTitleBox(ModalBuilder builder) {
        HBox titleHBox = new HBox();
        titleHBox.setAlignment(Pos.CENTER);
        if (builder.previousStep != null) {
            SvgSizeable icon = new SvgSizeable();
            icon.getStyleClass().addAll((Object[])new String[]{"icon-black", "icon-xlarge", "svg-arrow-left"});
            Button previousButton = new Button("", (Node)icon);
            previousButton.getStyleClass().add((Object)"transparent-icon-button");
            previousButton.setOnAction(event -> builder.previousStep.run());
            titleHBox.getChildren().add((Object)previousButton);
        }
        builder.titleLabel.getStyleClass().add((Object)"h1");
        titleHBox.getChildren().add((Object)builder.titleLabel);
        titleHBox.setPadding(new Insets(8.0, 0.0, 12.0, 0.0));
        Region filler = new Region();
        HBox.setHgrow((Node)filler, (Priority)Priority.ALWAYS);
        titleHBox.getChildren().add((Object)filler);
        if (builder.containCancelButton) {
            SvgSizeable icon = new SvgSizeable();
            icon.getStyleClass().addAll((Object[])new String[]{"svg-close", "icon-black", "icon-xlarge"});
            Button cancelCrossButton = new Button("", (Node)icon);
            cancelCrossButton.setCancelButton(true);
            cancelCrossButton.getStyleClass().add((Object)"transparent-icon-button");
            cancelCrossButton.setOnAction(event -> builder.close.run());
            titleHBox.getChildren().add((Object)cancelCrossButton);
        }
        return titleHBox;
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }
}

