/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.standard_ui.flow;

import io.olvid.windows.messenger.fx.framework.animation.AnimationConfiguration;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.framework.view_controller.ViewControllerManager;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.modal.standard_ui.state_builder.ModalBuilder;
import io.olvid.windows.messenger.fx.modal.standard_ui.state_builder.ModalBuilderInterfaces;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.state_pattern.SimpleContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

public class ModalFlowController<StateId>
extends BaseModalController {
    public static final int WIDTH = 539;
    public static final int MAX_HEIGHT = 705;
    public static final String FLOW_ROOT_CONTROLLER_ID = "flow_root_controller";
    private final StackPane stackPane = new StackPane();
    private final ViewControllerManager<StateId> viewManager = new ViewControllerManager(ViewControllerManager.ManagementMode.LAZY);
    private final Map<StateId, Callable<BaseViewController>> stateMap = new HashMap<StateId, Callable<BaseViewController>>();
    private final SimpleContext<StateId> context = new SimpleContext();

    public static ModalBuilderInterfaces.Container builder() {
        return new ModalBuilder();
    }

    public ModalFlowController() {
        this.stackPane.setId(FLOW_ROOT_CONTROLLER_ID);
        this.stackPane.setPrefWidth(539.0);
        this.stackPane.setMaxWidth(539.0);
        this.stackPane.setMinWidth(539.0);
        this.stackPane.setMaxHeight(705.0);
        this.setSize(ModalConfiguration.ModalSize.SELF_SIZE);
        this.context.getCurrentStateLiveData().addListener((newValue, oldValue) -> {
            if (newValue == null) {
                return;
            }
            ViewControllerHelper.smartUIUpdate(() -> this.viewManager.replaceView(newValue, (Pane)this.stackPane, AnimationConfiguration.AnimationEnumType.FADE_IN, AnimationConfiguration.AnimationEnumType.FADE_OUT));
        });
    }

    public StackPane getLayout() {
        return this.stackPane;
    }

    public void setState(StateId id) {
        if (this.context.getCurrentState() == null) {
            this.viewManager.registerChildrenControllers(this.stateMap);
        }
        this.context.pushState(id);
    }

    public void registerState(StateId id, Callable<BaseViewController> innerControllerFactory) {
        if (this.stateMap.containsKey(id)) {
            AppLogger.e("The modal flow already contain the key %s".formatted(id));
            return;
        }
        if (this.context.getCurrentState() != null) {
            AppLogger.e("The modal flow was already initialized");
            return;
        }
        this.stateMap.put(id, innerControllerFactory);
    }

    public void close() {
        this.closeModalDelegate.run();
    }

    public SimpleContext<StateId> getContext() {
        return this.context;
    }
}

