/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.reactions_details.components;

import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.EmojiHelper;
import io.olvid.windows.messenger.fx.modal.reactions_details.ReactionDetailsInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.misc.DateUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class ReactionInfoRow
extends HBox
implements DiffUtils.NodeController<ReactionDetailsInfo> {
    protected ReactionDetailsInfo currentIdentityInfo;
    final Label sender = new Label(ViewControllerHelper.getString("reactions_details_unknown_sender"));
    final IdentityBubble identityBubble = new IdentityBubble(16.0);
    final Region spacer = new Region();
    final Label timestamp = new Label();
    final ReactionDetailsInfo reaction;
    private int index;
    EmojiHelper.EmojiView emojiView = new EmojiHelper.EmojiView("");

    public ReactionInfoRow(ReactionDetailsInfo reaction) {
        super(12.0);
        this.reaction = reaction;
        this.setPadding(new Insets(8.0, 12.0, 8.0, 12.0));
        this.setAlignment(Pos.CENTER_LEFT);
        this.getStyleClass().add((Object)"reaction-row");
        this.sender.getStyleClass().add((Object)"reaction-sender");
        HBox.setHgrow((Node)this.spacer, (Priority)Priority.ALWAYS);
        this.timestamp.getStyleClass().add((Object)"reaction-ts");
        this.getChildren().addAll((Object[])new Node[]{this.identityBubble, this.sender, this.spacer, this.timestamp, this.emojiView});
        this.update(reaction);
    }

    public static ReactionInfoRow of(ReactionDetailsInfo reactionDetails) {
        return new ReactionInfoRow(reactionDetails);
    }

    @Override
    public ReactionDetailsInfo getValue() {
        return this.currentIdentityInfo;
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public void update(ReactionDetailsInfo value) {
        if (value != null && this.reaction != null) {
            if (value.identityInfo().isMe()) {
                this.sender.setText(value.identityInfo().getCustomDisplayNameOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST).orElse(ViewControllerHelper.getString("reactions_details_unknown_sender")) + " (" + ViewControllerHelper.getString("reactions_details_you") + ")");
            } else {
                this.sender.setText(value.identityInfo().getCustomDisplayNameOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST).orElse(ViewControllerHelper.getString("reactions_details_unknown_sender")));
            }
            if (!value.identityInfo().areContentTheSame(this.currentIdentityInfo)) {
                BubbleUtils.setBubbleData(value.identityInfo(), this.identityBubble);
            }
            LocalDateTime tsDateTime = DateUtils.of(this.reaction.timestamp());
            String dateStr = DateUtils.formatRelativeDate(tsDateTime);
            String timeStr = tsDateTime.format(DateTimeFormatter.ofPattern("HH:mm"));
            String fullStr = ViewControllerHelper.getString("reactions_details_controller_timestamp", dateStr, timeStr);
            this.timestamp.setText(fullStr);
            this.emojiView = new EmojiHelper.EmojiView(this.reaction.reaction());
            this.emojiView.configure((DoubleExpression)new SimpleDoubleProperty(20.0));
            this.emojiView.getStyleClass().add((Object)"reaction-emoji");
        }
        this.currentIdentityInfo = value;
    }

    @Override
    public void dispose() {
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }
}

