/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.reactions_details;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.reaction.AbstractReactionGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageItem;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.EmojiHelper;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.modal.message_infos.view.VBoxList;
import io.olvid.windows.messenger.fx.modal.reactions_details.AbstractReactionsDetailsInfoController;
import io.olvid.windows.messenger.fx.modal.reactions_details.ReactionDetailsInfo;
import io.olvid.windows.messenger.fx.modal.reactions_details.components.ReactionGroupHeader;
import io.olvid.windows.messenger.fx.modal.reactions_details.components.ReactionInfoRow;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;

public class ReactionsDetailsModalController
extends BaseModalController
implements LiveDataListener<Map<String, List<ReactionDetailsInfo>>> {
    private final VBox root = new VBox(12.0);
    private final VBox groupsContainer = new VBox();
    private final Button closeButton = new Button();
    private AbstractReactionsDetailsInfoController<? extends AbstractUserMessageGenerated<?>, ? extends AbstractReactionGenerated<?>> reactionsInfoController;
    private final Map<String, VBoxList<ReactionDetailsInfo, ReactionInfoRow>> groupedReactionCollections = new LinkedHashMap<String, VBoxList<ReactionDetailsInfo, ReactionInfoRow>>();
    private final Map<String, ListChangeListener<Node>> vboxListeners = new HashMap<String, ListChangeListener<Node>>();
    private final Map<String, ReactionGroupHeader> reactionHeaders = new LinkedHashMap<String, ReactionGroupHeader>();

    @Override
    public ModalConfiguration.ModalSize getSize() {
        return ModalConfiguration.ModalSize.SELF_SIZE;
    }

    public ReactionsDetailsModalController(MessageItem messageItem, DiscussionViewModel viewModel) {
        switch (messageItem.getKind()) {
            case DISCLAIMER: 
            case SYSTEM: {
                this.reactionsInfoController = null;
                throw new IllegalStateException();
            }
            case INBOUND: {
                this.reactionsInfoController = new AbstractReactionsDetailsInfoController.InboundReactionsDetailsInfoController((Id<InboundMessage>)messageItem.getInboundMessage().getItemId(), viewModel, this);
                break;
            }
            case OUTBOUND: {
                this.reactionsInfoController = new AbstractReactionsDetailsInfoController.OutboundReactionsDetailsInfoController((Id<OutboundMessage>)messageItem.getOutboundMessage().getItemId(), viewModel, this);
                break;
            }
            case OWNED: {
                this.reactionsInfoController = new AbstractReactionsDetailsInfoController.OwnedReactionsDetailsInfoController((Id<OwnedMessage>)messageItem.getOwnedMessage().getItemId(), viewModel, this);
            }
        }
        this.buildUI();
        this.reactionsInfoController.subscribe();
    }

    private void buildUI() {
        this.root.getStyleClass().add((Object)"reactions-modal-root");
        this.root.setMinWidth(500.0);
        this.root.setMaxWidth(500.0);
        this.root.maxHeightProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> Math.min(this.groupsContainer.heightProperty().get() + 75.0, 550.0), (Observable[])new Observable[]{this.groupsContainer.heightProperty()}));
        this.root.getStylesheets().add((Object)"fx/modal/reactions_details/reactions_details.css");
        this.root.getStylesheets().add((Object)"fx/modal/modal.css");
        HBox header = new HBox();
        header.setAlignment(Pos.CENTER_LEFT);
        header.setPadding(new Insets(16.0, 16.0, 0.0, 16.0));
        Label title = new Label(ViewControllerHelper.getString("modal_reactions_title"));
        title.getStyleClass().add((Object)"h1");
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.closeButton.getStyleClass().add((Object)"close-button");
        this.closeButton.setOnAction(e -> this.close());
        header.getChildren().addAll((Object[])new Node[]{title, spacer, this.closeButton});
        this.groupsContainer.setPadding(new Insets(4.0, 16.0, 16.0, 16.0));
        ScrollPane scrollPane = new ScrollPane((Node)this.groupsContainer);
        scrollPane.setFitToWidth(true);
        scrollPane.getStyleClass().add((Object)"no-border");
        this.root.getChildren().addAll((Object[])new Node[]{header, scrollPane});
    }

    private void render(Map<String, List<ReactionDetailsInfo>> lastReactionDetails, Map<String, List<ReactionDetailsInfo>> oldValue) {
        ReactionGroupHeader header;
        if (lastReactionDetails.isEmpty()) {
            this.groupsContainer.getChildren().clear();
            this.unplugVboxList();
            this.groupedReactionCollections.clear();
            this.reactionHeaders.clear();
            VBox emptyBox = new VBox(8.0);
            emptyBox.setAlignment(Pos.CENTER);
            EmojiHelper.EmojiView sadEmoji = new EmojiHelper.EmojiView("\ud83d\ude1e");
            sadEmoji.configure((DoubleExpression)new SimpleDoubleProperty(50.0));
            sadEmoji.getStyleClass().add((Object)"empty-emoji");
            Label textLabel = new Label(ViewControllerHelper.getString("reactions_details_no_reactions"));
            textLabel.getStyleClass().add((Object)"empty-text");
            emptyBox.getChildren().addAll((Object[])new Node[]{sadEmoji, textLabel});
            this.groupsContainer.getChildren().add((Object)emptyBox);
            return;
        }
        this.groupsContainer.getChildren().removeIf(node -> {
            VBox v;
            return node instanceof VBox && (v = (VBox)node).getChildren().stream().anyMatch(c -> {
                Label lbl;
                return c instanceof Label && (lbl = (Label)c).getStyleClass().contains((Object)"empty-text");
            });
        });
        for (Map.Entry<String, List<ReactionDetailsInfo>> entry : lastReactionDetails.entrySet()) {
            ReactionGroupHeader header2;
            String emoji = entry.getKey();
            List<ReactionDetailsInfo> reactions = entry.getValue();
            if (this.groupedReactionCollections.containsKey(emoji)) {
                header2 = this.reactionHeaders.get(emoji);
                if (header2 == null) continue;
                header2.updateCount(reactions.size());
                continue;
            }
            header2 = new ReactionGroupHeader(emoji, reactions.size());
            VBoxList<ReactionDetailsInfo, ReactionInfoRow> newBox = this.buildVBoxList(emoji);
            this.reactionHeaders.put(emoji, header2);
            this.groupedReactionCollections.put(emoji, newBox);
            this.groupsContainer.getChildren().addAll((Object[])new Node[]{header2, newBox});
        }
        ArrayList<String> existing = new ArrayList<String>(lastReactionDetails.keySet());
        HashSet<String> toRemove = new HashSet<String>(this.reactionHeaders.keySet());
        existing.forEach(toRemove::remove);
        for (String emoji : toRemove) {
            VBoxList<ReactionDetailsInfo, ReactionInfoRow> vbox = this.groupedReactionCollections.remove(emoji);
            header = this.reactionHeaders.remove(emoji);
            this.groupsContainer.getChildren().removeAll((Object[])new Node[]{header, vbox});
        }
        ArrayList<Object> reordered = new ArrayList<Object>(existing.size());
        for (String emoji : existing) {
            header = this.reactionHeaders.get(emoji);
            VBoxList<ReactionDetailsInfo, ReactionInfoRow> list = this.groupedReactionCollections.get(emoji);
            if (header == null || list == null) continue;
            reordered.add((Object)header);
            reordered.add(list);
        }
        this.groupsContainer.getChildren().setAll(reordered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unplugVboxList() {
        Map<String, VBoxList<ReactionDetailsInfo, ReactionInfoRow>> map = this.groupedReactionCollections;
        synchronized (map) {
            for (String key : this.groupedReactionCollections.keySet()) {
                Optional<VBoxList<ReactionDetailsInfo, ReactionInfoRow>> identityInfoRowDetails = Optional.ofNullable(this.groupedReactionCollections.get(key));
                identityInfoRowDetails.ifPresent(VBoxList::unplug);
            }
        }
    }

    private VBoxList<ReactionDetailsInfo, ReactionInfoRow> buildVBoxList(String key) {
        VBoxList<ReactionDetailsInfo, ReactionInfoRow> vboxList = new VBoxList<ReactionDetailsInfo, ReactionInfoRow>(ReactionInfoRow.class, reactionDetailsInfo -> {
            ReactionInfoRow row = ReactionInfoRow.of(reactionDetailsInfo);
            return row;
        });
        vboxList.getStyleClass().add((Object)"vboxlist");
        Rectangle clip = new Rectangle();
        clip.arcWidthProperty().set(16.0);
        clip.arcHeightProperty().set(16.0);
        clip.widthProperty().bind((ObservableValue)vboxList.widthProperty());
        clip.heightProperty().bind((ObservableValue)vboxList.heightProperty());
        vboxList.setClip((Node)clip);
        LiveData liveData = this.reactionsInfoController.model.getReactionsEntryValue(key);
        vboxList.plug(liveData);
        ListChangeListener childListener = change -> {
            int total = vboxList.getChildren().size();
            for (int i = 0; i < total; ++i) {
                Node node = (Node)vboxList.getChildren().get(i);
                if (!(node instanceof ReactionInfoRow)) continue;
                ReactionInfoRow row = (ReactionInfoRow)node;
                row.getStyleClass().removeAll((Object[])new String[]{"reaction-row-single", "reaction-row-last"});
                if (total == 1) {
                    row.getStyleClass().add((Object)"reaction-row-single");
                    continue;
                }
                if (i != total - 1) continue;
                row.getStyleClass().add((Object)"reaction-row-last");
            }
        };
        vboxList.getChildren().addListener(childListener);
        this.vboxListeners.put(key, (ListChangeListener<Node>)childListener);
        return vboxList;
    }

    private void close() {
        this.reactionsInfoController.model.unplug();
        this.vboxListeners.forEach((key, listener) -> {
            VBoxList<ReactionDetailsInfo, ReactionInfoRow> vbox = this.groupedReactionCollections.get(key);
            if (vbox != null) {
                vbox.getChildren().removeListener(listener);
            }
        });
        this.vboxListeners.clear();
        this.unplugVboxList();
        this.groupedReactionCollections.clear();
        this.getCloseModalDelegate().run();
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        super.onLayoutAttached();
    }

    @Override
    public void onLayoutDetached() {
        this.close();
        super.onLayoutDetached();
    }

    @Override
    public void onChange(Map<String, List<ReactionDetailsInfo>> newValue, Map<String, List<ReactionDetailsInfo>> oldValue) {
        ViewControllerHelper.smartUIUpdate(() -> this.render(newValue, oldValue));
    }
}

