/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.qrcode;

import io.olvid.windows.messenger.engine.helpers.invitations.InvitationApi;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.standard_ui.flow.ModalFlowController;
import io.olvid.windows.messenger.fx.modal.standard_ui.state_builder.ModalBuilderInterfaces;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import net.glxn.qrgen.QRCode;
import net.glxn.qrgen.image.ImageType;

@FXMLView(path="fx/modal/qrcode/qrcode_modal.fxml")
public class QrCodeModalController
extends BaseViewController {
    public static final PseudoClass ERROR_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"error");
    @FXML
    private VBox root;
    @FXML
    private ImageView qrcode_image_view;
    @FXML
    private Button copy_button;
    @FXML
    private TextField link;
    @FXML
    private StackPane bubble_container;
    @FXML
    private ToggleButton share_id_toggle;
    @FXML
    private ToggleButton import_id_toggle;
    @FXML
    private Region share_id_container;
    @FXML
    private Region import_id_container;
    @FXML
    private TextField input_id;
    @FXML
    private Button validate;
    @FXML
    private Label description;
    private String invitationUrl;
    private Runnable close;

    public QrCodeModalController(Runnable close) {
        this.loadFxml();
        this.close = close;
    }

    public static <StateId> ModalBuilderInterfaces.AllBuilder builder(ModalFlowController<StateId> flowController) {
        QrCodeModalController qrCodeModalController = new QrCodeModalController(flowController::close);
        return ModalFlowController.builder().withInnerNode((Node)qrCodeModalController.root).withTitle(ViewControllerHelper.RESOURCE_BUNDLE.getString("modal.new_contact.title")).withoutButton();
    }

    private Image createQrCodeImageView() {
        Optional<OwnedIdentityInfo> selectedOwnedIdentityInfo = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
        if (selectedOwnedIdentityInfo.isPresent()) {
            this.invitationUrl = InvitationApi.getUrlRepresentation(selectedOwnedIdentityInfo.get());
        } else {
            this.invitationUrl = "";
            AppLogger.e("Unable to find current identity for invitation link !!!");
        }
        int qrcodeSize = 250;
        ByteArrayOutputStream out = QRCode.from((String)this.invitationUrl).to(ImageType.PNG).withSize(qrcodeSize, qrcodeSize).stream();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        return new Image((InputStream)in);
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.qrcode_image_view.setImage(this.createQrCodeImageView());
        this.link.textProperty().set((Object)this.invitationUrl);
        this.link.getStyleClass().setAll((Object[])new String[]{"read-only-text-field"});
        IdentityBubble contactBubble = new IdentityBubble(28.0);
        Optional<OwnedIdentityInfo> selectedOwnedIdentityInfo = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
        selectedOwnedIdentityInfo.ifPresent(ownedIdentityInfo -> BubbleUtils.setBubbleData(ownedIdentityInfo, contactBubble));
        this.bubble_container.getChildren().add((Object)contactBubble);
        this.initPaneSwitch();
    }

    private void initPaneSwitch() {
        this.share_id_container.managedProperty().bind((ObservableValue)this.share_id_container.visibleProperty());
        this.share_id_container.visibleProperty().bind((ObservableValue)this.share_id_toggle.selectedProperty());
        this.import_id_container.managedProperty().bind((ObservableValue)this.import_id_container.visibleProperty());
        this.import_id_container.visibleProperty().bind((ObservableValue)this.import_id_toggle.selectedProperty());
        this.validate.setOnAction(event -> this.eventHandlerSendInvitation());
        this.import_id_toggle.getToggleGroup().selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                oldValue.setSelected(true);
            }
        });
        this.description.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.share_id_toggle.selectedProperty()).then(ViewControllerHelper.getString("modal_new_contact_sheared_description")).otherwise(ViewControllerHelper.getString("modal_new_contact_import_description")));
    }

    private void eventHandlerSendInvitation() {
        Optional<OwnedIdentityInfo> ownedIdentity = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
        boolean isInError = ownedIdentity.isEmpty() || !InvitationApi.sendInvitation(this.input_id.getText(), ownedIdentity.get().bytesOwnedIdentity());
        this.input_id.pseudoClassStateChanged(ERROR_PSEUDO_CLASS, true);
        this.input_id.setText("");
        if (!isInError) {
            this.close.run();
        }
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    public Node getRoot() {
        return this.root;
    }

    @FXML
    private void select_and_copy_action() {
        this.link.selectAll();
        this.copy_action(null);
    }

    @FXML
    private void copy_action(ActionEvent event) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(this.invitationUrl);
        clipboard.setContent((Map)content);
    }
}

