/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.view.messages;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.MessageStatusView;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.InfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.model.InfoData;
import io.olvid.windows.messenger.fx.modal.message_infos.model.MetadataKind;
import io.olvid.windows.messenger.fx.modal.message_infos.model.RecipientStatus;
import io.olvid.windows.messenger.fx.modal.message_infos.view.AbstractInfoDataListCell;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.IdentityInfo;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import java.util.Optional;
import javafx.geometry.Insets;

public final class MetadataListCell
extends AbstractInfoDataListCell<InfoData.MetadataOrStatus> {
    public final MessageStatusView statusView = new MessageStatusView("icon-medium", 4.5);

    public MetadataListCell(StackContext<InfoController.InfoState> stackContext) {
        super(stackContext, true);
        this.label.getStyleClass().add((Object)"h2");
        this.mainHBox.setPadding(new Insets(12.0));
        this.label.setMinHeight(40.0);
        this.mainHBox.getChildren().add(0, (Object)this.statusView);
    }

    @Override
    public void update(InfoData.MetadataOrStatus item) {
        super.update(item);
        this.updateWithIdentityInfo(Optional.empty());
        Optional<Id<IdentityRef>> identityRefId = item.deleterId();
        this.updateIdentityRefListener(identityRefId);
    }

    @Override
    protected void updateWithIdentityInfo(Optional<IdentityInfo> identityInfo) {
        if (this.current == null) {
            return;
        }
        Either<MetadataKind, RecipientStatus> either = ((InfoData.MetadataOrStatus)this.current).kind();
        if (either.isLeft()) {
            MetadataKind kind = either.getLeft();
            this.statusView.update(kind.getIcon());
            if (identityInfo.isEmpty()) {
                this.label.setText(kind.getLabel(Optional.empty()));
            } else if (identityInfo.get().isMe()) {
                this.label.setText(kind.getLabel(Optional.of(ViewControllerHelper.getString("you"))));
            } else if (identityInfo.get().getContactInfo().isPresent()) {
                ContactInfo contactInfo = identityInfo.get().getContactInfo().get();
                String contactName = contactInfo.getCustomOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST);
                this.label.setText(kind.getLabel(Optional.of(contactName)));
            } else {
                this.label.setText(kind.getLabel(Optional.empty()));
            }
        } else {
            RecipientStatus recipientStatus = either.getRight();
            this.statusView.update(recipientStatus.getIcon());
            this.label.setText(recipientStatus.getLabel());
        }
    }
}

