/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.model;

import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.fx.misc.MessageStatusView;
import io.olvid.windows.messenger.fx.misc.OptionalUtils;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.InfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.model.MetadataKind;
import io.olvid.windows.messenger.fx.modal.message_infos.model.RecipientStatus;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.misc.Either;
import java.util.List;
import java.util.Optional;

public interface InfoData
extends Diffable,
Comparable<InfoData> {
    public Optional<Long> getTimestamp();

    default public Optional<InfoController.InfoState> getNextState() {
        return Optional.empty();
    }

    @Override
    default public int compareTo(InfoData o) {
        return OptionalUtils.OptionalComparator.of(OptionalUtils.OptionalComparator.EmptyOrder.EMPTY_LAST).compare(this.getTimestamp(), o.getTimestamp());
    }

    @Override
    default public boolean areContentTheSame(Object obj) {
        return this.equals(obj);
    }

    @Override
    default public Object getItemId() {
        return this.toString();
    }

    public record StatusInfoData(OutboundMessageGenerated.Status status) implements InfoData
    {
        @Override
        public Optional<Long> getTimestamp() {
            return Optional.empty();
        }
    }

    public record AttachmentsSummaryData(InfoController.InfoState.AttachmentsListState<?, ?> state, int count) implements InfoData
    {
        @Override
        public Optional<Long> getTimestamp() {
            return Optional.empty();
        }

        @Override
        public Optional<InfoController.InfoState> getNextState() {
            return Optional.of(this.state);
        }
    }

    public record AttachmentData<Attachement extends AbstractAttachmentGenerated<Attachement>>(Id<Attachement> id, String name, MessageStatusView.Icon icon, Optional<InfoController.InfoState> nextState) implements InfoData
    {
        @Override
        public Optional<Long> getTimestamp() {
            return Optional.empty();
        }

        @Override
        public Optional<InfoController.InfoState> getNextState() {
            return this.nextState;
        }

        private static MessageStatusView.Icon getIcon(ReceivedAttachmentGenerated.Status status) {
            return switch (status) {
                default -> throw new MatchException(null, null);
                case ReceivedAttachmentGenerated.Status.DOWNLOADABLE -> MessageStatusView.Icon.DOWNLOADABLE;
                case ReceivedAttachmentGenerated.Status.DOWNLOADING -> MessageStatusView.Icon.PROCESSING;
                case ReceivedAttachmentGenerated.Status.COMPLETE -> MessageStatusView.Icon.DELIVERED_TO_ONE;
                case ReceivedAttachmentGenerated.Status.DOWNLOAD_FAILED -> MessageStatusView.Icon.NONE;
            };
        }

        private static MessageStatusView.Icon getIcon(OutboundAttachmentGenerated.Status status) {
            return switch (status) {
                default -> throw new MatchException(null, null);
                case OutboundAttachmentGenerated.Status.CANCELLED, OutboundAttachmentGenerated.Status.FAILED, OutboundAttachmentGenerated.Status.DRAFT_READY, OutboundAttachmentGenerated.Status.NO_CONTACT_RECIPIENTS -> MessageStatusView.Icon.NONE;
                case OutboundAttachmentGenerated.Status.COPYING, OutboundAttachmentGenerated.Status.UPLOADING, OutboundAttachmentGenerated.Status.UNPROCESSED -> MessageStatusView.Icon.PROCESSING;
                case OutboundAttachmentGenerated.Status.SENT -> MessageStatusView.Icon.SENT;
                case OutboundAttachmentGenerated.Status.DELIVERED -> MessageStatusView.Icon.DELIVERED_TO_ONE;
                case OutboundAttachmentGenerated.Status.READ -> MessageStatusView.Icon.READ_BY_ONE;
            };
        }

        public static AttachmentData<InboundAttachment> of(InboundAttachment attachment) {
            return new AttachmentData<InboundAttachment>((Id<InboundAttachment>)attachment.getItemId(), attachment.getFilename(), AttachmentData.getIcon(attachment.getStatus()), Optional.empty());
        }

        public static AttachmentData<OutboundAttachment> of(OutboundAttachment attachment, int recipientsCount, boolean hasOwnedDevice) {
            InfoController.InfoState.OutboundAttachmentInfoState state = new InfoController.InfoState.OutboundAttachmentInfoState((Id<OutboundAttachment>)attachment.getItemId(), attachment.getMessageId(), recipientsCount, hasOwnedDevice);
            return new AttachmentData<OutboundAttachment>((Id<OutboundAttachment>)attachment.getItemId(), attachment.getFilename(), AttachmentData.getIcon(attachment.getStatus()), Optional.of(state));
        }

        public static AttachmentData<OwnedAttachment> of(OwnedAttachment attachment) {
            return new AttachmentData<OwnedAttachment>((Id<OwnedAttachment>)attachment.getItemId(), attachment.getFilename(), AttachmentData.getIcon(attachment.getStatus()), Optional.empty());
        }
    }

    public record NotSentToPendingMemberInfo(Id<PendingGroupMember> recipientId) implements InfoData
    {
        @Override
        public Optional<Long> getTimestamp() {
            return Optional.empty();
        }
    }

    public record NotSentYetInfo(Id<ContactRef> recipientId) implements InfoData
    {
        @Override
        public Optional<Long> getTimestamp() {
            return Optional.empty();
        }
    }

    public record PreviousRecipientInfo(RecipientStatus status, long timestamp) implements InfoData
    {
        @Override
        public Optional<Long> getTimestamp() {
            return Optional.of(this.timestamp);
        }
    }

    public record RecipientInfo(RecipientStatus status, Optional<Long> timestamp, Id<IdentityRef> recipientId, List<PreviousRecipientInfo> previousRecipientInfos) implements InfoData
    {
        @Override
        public Optional<Long> getTimestamp() {
            return this.timestamp;
        }
    }

    public record MetadataOrStatus(Either<MetadataKind, RecipientStatus> kind, long timestamp, Optional<Id<IdentityRef>> deleterId) implements InfoData
    {
        @Override
        public Optional<Long> getTimestamp() {
            return Optional.of(this.timestamp);
        }
    }
}

