/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.controller.messages;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.gen.metadata.OwnedMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.metadata.OwnedMessageMetadata;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.InfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.messages.AbstractReceivedMessageInfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.model.InfoData;
import io.olvid.windows.messenger.fx.modal.message_infos.model.MetadataKind;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public final class OwnedMessageInfoController
extends AbstractReceivedMessageInfoController<OwnedMessage, OwnedAttachment, OwnedMessageMetadata> {
    public OwnedMessageInfoController(StackContext<InfoController.InfoState> stackContext, Id<OwnedMessage> messageId) {
        super(stackContext, 0, false, messageId, OwnedMessage.class, DbManager.getInstance().getOwnedMessageDao(), OwnedMessageMetadata.class, DbManager.getInstance().getOwnedMessageMetadataDao(), OwnedAttachment.class, DbManager.getInstance().getOwnedAttachmentDao(), InfoData.AttachmentData::of);
        HBox explanationHBox = new HBox(12.0);
        explanationHBox.setAlignment(Pos.TOP_CENTER);
        explanationHBox.setPadding(new Insets(12.0));
        explanationHBox.getStyleClass().add((Object)"explanation-view");
        SvgSizeable icon = new SvgSizeable();
        icon.getStyleClass().addAll((Object[])new String[]{"svg-error", "icon-medium", "icon-orange-2"});
        explanationHBox.getChildren().add((Object)icon);
        VBox explanationVBox = new VBox(7.0);
        explanationHBox.getChildren().add((Object)explanationVBox);
        Label title = new Label();
        title.setText(ViewControllerHelper.getString("title_message_sent_from_other_device"));
        title.getStyleClass().add((Object)"h2");
        explanationVBox.getChildren().add((Object)title);
        Label explanation = new Label();
        explanation.setWrapText(true);
        explanation.setText(ViewControllerHelper.getString("explanation_message_sent_from_other_device"));
        explanationVBox.getChildren().add((Object)explanation);
        explanation.getStyleClass().addAll((Object[])new String[]{"body-1-size", "grey-text"});
        VBox.setMargin((Node)explanationHBox, (Insets)new Insets(24.0, 0.0, 0.0, 0.0));
        this.mainVBox.getChildren().add((Object)explanationHBox);
    }

    @Override
    protected MetadataKind getMetadataKind(OwnedMessageMetadata metadata) {
        return switch (metadata.getKind()) {
            default -> throw new MatchException(null, null);
            case OwnedMessageMetadataGenerated.Kind.WIPED -> MetadataKind.WIPED;
            case OwnedMessageMetadataGenerated.Kind.EDITED -> MetadataKind.EDITED;
            case OwnedMessageMetadataGenerated.Kind.UNDELIVERED -> MetadataKind.UNDELIVERED;
            case OwnedMessageMetadataGenerated.Kind.UPLOADED -> MetadataKind.UPLOADED;
            case OwnedMessageMetadataGenerated.Kind.RECEIVED -> MetadataKind.RECEIVED;
            case OwnedMessageMetadataGenerated.Kind.REMOTE_DELETED -> MetadataKind.REMOTE_DELETED;
            case OwnedMessageMetadataGenerated.Kind.LOCATION_SHARING_LATEST_UPDATE -> MetadataKind.LOCATION_SHARING_LATEST_UPDATE;
            case OwnedMessageMetadataGenerated.Kind.LOCATION_SHARING_END -> MetadataKind.LOCATION_SHARING_END;
        };
    }
}

