/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.controller.messages;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.metadata.OutboundMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.metadata.OutboundMessageMetadata;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.CollectionUtils;
import io.olvid.windows.messenger.fx.misc.MessageStatusView;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.InfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.messages.AbstractMessageInfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.model.InfoData;
import io.olvid.windows.messenger.fx.modal.message_infos.model.MetadataKind;
import io.olvid.windows.messenger.fx.modal.message_infos.model.RecipientStatus;
import io.olvid.windows.messenger.fx.modal.message_infos.view.VBoxList;
import io.olvid.windows.messenger.fx.modal.message_infos.view.messages.RecipientInfoListCell;
import io.olvid.windows.messenger.livedata.ListLiveData;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.layout.Pane;

public final class OutboundMessageInfoController
extends AbstractMessageInfoController<OutboundMessage, OutboundAttachment, OutboundMessageMetadata> {
    private LiveData<List<MessageRecipientInfo>> messageRecipientInfoLiveData;

    public OutboundMessageInfoController(StackContext<InfoController.InfoState> stackContext, Id<OutboundMessage> messageId, int recipientsCount, boolean hasOwnedDevice) {
        super(stackContext, recipientsCount, hasOwnedDevice, messageId, OutboundMessage.class, DbManager.getInstance().getOutboundMessageDao(), OutboundMessageMetadata.class, DbManager.getInstance().getOutboundMessageMetadataDao(), OutboundAttachment.class, DbManager.getInstance().getOutboundAttachmentDao(), a -> InfoData.AttachmentData.of(a, recipientsCount, hasOwnedDevice));
        int index = 3;
        if (this.showIndividualRecipientStatus()) {
            MessageRecipientInfo.Status[] statuses = MessageRecipientInfo.Status.values();
            for (int i = statuses.length - 1; 0 <= i; --i) {
                MessageRecipientInfo.Status status = statuses[i];
                RecipientStatus recipientStatus = RecipientStatus.of(status);
                this.buildRecipientInfoListView(recipientStatus.getLabel(), this.buildMessageRecipientInfoLiveData(status), recipientStatus.getIcon(), index);
                index += 2;
            }
            this.buildPendingMemberInfoListView(ViewControllerHelper.getString("text_not_sent_yet_pending"), OutboundMessageInfoController.buildPendingMemberLiveData(messageId), Optional.of(index));
            this.buildNotSentYetInfoListView(ViewControllerHelper.getString("text_not_sent_yet_canal"), OutboundMessageInfoController.buildPendingLiveData(messageId), Optional.of(index));
        }
    }

    private List<InfoData.PreviousRecipientInfo> buildPreviousInfo(MessageRecipientInfo info, MessageRecipientInfo.Status status) {
        ArrayList<InfoData.PreviousRecipientInfo> previous = new ArrayList<InfoData.PreviousRecipientInfo>();
        for (MessageRecipientInfo.Status s : MessageRecipientInfo.Status.values()) {
            Optional<Long> timestamp;
            if (status.isLessOrEqualTo(s) || (timestamp = info.getTimestamp(s)).isEmpty()) continue;
            previous.add(new InfoData.PreviousRecipientInfo(RecipientStatus.of(s), timestamp.get()));
        }
        return previous;
    }

    private LiveData<List<InfoData.RecipientInfo>> buildMessageRecipientInfoLiveData(MessageRecipientInfo.Status status) {
        return LiveDataFactory.map(this.messageRecipientInfoLiveData, List.of(), infos -> {
            ArrayList<InfoData.RecipientInfo> result = new ArrayList<InfoData.RecipientInfo>();
            for (MessageRecipientInfo info : infos) {
                if (info.status() != status) continue;
                Optional<Long> timestamp = info.getTimestamp(info.status());
                List<InfoData.PreviousRecipientInfo> previousInfos = this.buildPreviousInfo(info, status);
                result.add(new InfoData.RecipientInfo(RecipientStatus.of(info.status()), timestamp, info.getRecipientRefId(), previousInfos));
            }
            Collections.sort(result);
            return result;
        });
    }

    @Override
    protected LiveData<List<InfoData.MetadataOrStatus>> getTimelineLiveData() {
        this.messageRecipientInfoLiveData = LiveDataFactory.buildDbLiveDataList(MessageRecipientInfo.class, () -> DbManager.getInstance().getMessageRecipientInfoDao().getAllByMessage(this.messageId));
        LiveData<List<InfoData.MetadataOrStatus>> metadataLiveData = super.getTimelineLiveData();
        LiveData metadataWithSentLiveData = LiveDataFactory.map(metadataLiveData, List.of(), datas -> {
            OutboundMessage outboundMessage = (OutboundMessage)DbManager.getInstance().getOutboundMessageDao().get(this.messageId);
            InfoData.MetadataOrStatus uploaded = new InfoData.MetadataOrStatus(Either.left(MetadataKind.SENT), outboundMessage.getTimestamp(), Optional.empty());
            return CollectionUtils.asList(uploaded, datas);
        });
        LiveData recipientInfoLiveData = LiveDataFactory.map(this.messageRecipientInfoLiveData, List.of(), infos -> {
            if (infos.size() > 1) {
                return List.of();
            }
            ArrayList<InfoData.MetadataOrStatus> datas = new ArrayList<InfoData.MetadataOrStatus>();
            for (MessageRecipientInfo info : infos) {
                for (MessageRecipientInfo.Status status : MessageRecipientInfo.Status.values()) {
                    Optional<Long> timestamp = info.getTimestamp(status);
                    if (timestamp.isEmpty()) continue;
                    RecipientStatus recipientStatus = RecipientStatus.of(status);
                    datas.add(new InfoData.MetadataOrStatus(Either.right(recipientStatus), timestamp.get(), Optional.empty()));
                }
            }
            return datas;
        });
        return ListLiveData.concat(metadataWithSentLiveData, recipientInfoLiveData);
    }

    @Override
    protected MetadataKind getMetadataKind(OutboundMessageMetadata metadata) {
        return switch (metadata.getKind()) {
            default -> throw new MatchException(null, null);
            case OutboundMessageMetadataGenerated.Kind.WIPED -> MetadataKind.WIPED;
            case OutboundMessageMetadataGenerated.Kind.EDITED -> MetadataKind.EDITED;
            case OutboundMessageMetadataGenerated.Kind.UNDELIVERED -> MetadataKind.UNDELIVERED;
            case OutboundMessageMetadataGenerated.Kind.REMOTE_DELETED -> MetadataKind.REMOTE_DELETED;
            case OutboundMessageMetadataGenerated.Kind.LOCATION_SHARING_LATEST_UPDATE -> MetadataKind.LOCATION_SHARING_LATEST_UPDATE;
            case OutboundMessageMetadataGenerated.Kind.LOCATION_SHARING_END -> MetadataKind.LOCATION_SHARING_END;
        };
    }

    private void buildRecipientInfoListView(String title, LiveData<List<InfoData.RecipientInfo>> messageInfoLiveData, MessageStatusView.Icon icon, int index) {
        VBoxList vBoxList = AbstractMessageInfoController.makeVBoxList((Pane)this.mainVBox, RecipientInfoListCell.class, () -> new RecipientInfoListCell(this.stackContext), Optional.of(index));
        OutboundMessageInfoController.attachTitle((Pane)this.mainVBox, title, Optional.of(icon), vBoxList);
        vBoxList.plug(messageInfoLiveData);
        vBoxList.visibleProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)vBoxList.getChildren()).not());
    }
}

