/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.controller.messages;

import io.olvid.windows.messenger.database.dao.attachment.AbstractAttachmentDao;
import io.olvid.windows.messenger.database.dao.message.AbstractUserMessageDao;
import io.olvid.windows.messenger.database.dao.metadata.AbstractMessageMetadataDao;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.ReceivedMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.AbstractMessageMetadataGenerated;
import io.olvid.windows.messenger.fx.misc.CollectionUtils;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.InfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.messages.AbstractMessageInfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.model.InfoData;
import io.olvid.windows.messenger.fx.modal.message_infos.model.MetadataKind;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public abstract class AbstractReceivedMessageInfoController<Message extends ReceivedMessageGenerated<Message>, Attachment extends ReceivedAttachmentGenerated<Attachment>, Metadata extends AbstractMessageMetadataGenerated<Metadata>>
extends AbstractMessageInfoController<Message, Attachment, Metadata> {
    protected AbstractReceivedMessageInfoController(StackContext<InfoController.InfoState> stackContext, int recipientsCount, boolean hasOwnedDevice, Id<Message> messageId, Class<Message> messageClass, AbstractUserMessageDao<Message, ?, ?> messageDao, Class<Metadata> metadataClass, AbstractMessageMetadataDao<Message, Metadata> metadataDao, Class<Attachment> attachmentClass, AbstractAttachmentDao<Message, Attachment> attachmentDao, Function<Attachment, InfoData.AttachmentData<Attachment>> makeData) {
        super(stackContext, recipientsCount, hasOwnedDevice, messageId, messageClass, messageDao, metadataClass, metadataDao, attachmentClass, attachmentDao, makeData);
    }

    @Override
    protected LiveData<List<InfoData.MetadataOrStatus>> getTimelineLiveData() {
        LiveData<List<InfoData.MetadataOrStatus>> timelineLiveData = super.getTimelineLiveData();
        return LiveDataFactory.map(timelineLiveData, List.of(), datas -> {
            boolean hasUploadedMetadata = false;
            for (InfoData.MetadataOrStatus data : datas) {
                if (data.kind().isRight() || data.kind().getLeft() != MetadataKind.UPLOADED) continue;
                hasUploadedMetadata = true;
                break;
            }
            if (hasUploadedMetadata) {
                return datas;
            }
            ReceivedMessageGenerated inboundMessage = (ReceivedMessageGenerated)this.messageDao.get(this.messageId);
            InfoData.MetadataOrStatus uploaded = new InfoData.MetadataOrStatus(Either.left(MetadataKind.UPLOADED), inboundMessage.getTimestamp(), Optional.empty());
            return CollectionUtils.asList(uploaded, datas);
        });
    }
}

