/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.controller.messages;

import io.olvid.windows.messenger.database.dao.attachment.AbstractAttachmentDao;
import io.olvid.windows.messenger.database.dao.message.AbstractUserMessageDao;
import io.olvid.windows.messenger.database.dao.metadata.AbstractMessageMetadataDao;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.AbstractMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.AbstractInfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.InfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.model.InfoData;
import io.olvid.windows.messenger.fx.modal.message_infos.model.MetadataKind;
import io.olvid.windows.messenger.fx.modal.message_infos.view.StatusInfoListCell;
import io.olvid.windows.messenger.fx.modal.message_infos.view.VBoxList;
import io.olvid.windows.messenger.fx.modal.message_infos.view.attachments.AttachmentInfoListCell;
import io.olvid.windows.messenger.fx.modal.message_infos.view.attachments.AttachmentSummaryListCell;
import io.olvid.windows.messenger.fx.modal.message_infos.view.messages.MetadataListCell;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;

public abstract class AbstractMessageInfoController<Message extends AbstractUserMessageGenerated<Message>, Attachment extends AbstractAttachmentGenerated<Attachment>, Metadata extends AbstractMessageMetadataGenerated<Metadata>>
extends AbstractInfoController<Message> {
    private final LiveData<List<Metadata>> metadataLiveData;
    protected final Id<Message> messageId;
    protected final LiveData<List<InfoData.MetadataOrStatus>> metadataInfoLiveData;
    protected final int recipientsCount;
    protected final boolean hasOwnedDevice;

    protected AbstractMessageInfoController(StackContext<InfoController.InfoState> stackContext, int recipientsCount, boolean hasOwnedDevice, Id<Message> messageId, Class<Message> messageClass, AbstractUserMessageDao<Message, ?, ?> messageDao, Class<Metadata> metadataClass, AbstractMessageMetadataDao<Message, Metadata> metadataDao, Class<Attachment> attachmentClass, AbstractAttachmentDao<Message, Attachment> attachmentDao, Function<Attachment, InfoData.AttachmentData<Attachment>> makeData) {
        super(stackContext, messageId, messageClass, messageDao);
        this.recipientsCount = recipientsCount;
        this.hasOwnedDevice = hasOwnedDevice;
        this.messageId = messageId;
        this.title.setText(ViewControllerHelper.getString("message_info_title"));
        this.metadataLiveData = LiveDataFactory.buildDbLiveDataList(metadataClass, () -> metadataDao.getAllMetadataForMessage(messageId));
        this.metadataInfoLiveData = this.getTimelineLiveData();
        VBoxList vBoxList = AbstractMessageInfoController.makeVBoxList((Pane)this.mainVBox, MetadataListCell.class, () -> new MetadataListCell(stackContext), Optional.empty());
        AbstractMessageInfoController.attachTitle((Pane)this.mainVBox, ViewControllerHelper.getString("message_timeline"), Optional.empty(), vBoxList);
        vBoxList.visibleProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)vBoxList.getChildren()).not());
        vBoxList.plug(this.metadataInfoLiveData);
        LiveData<List<Attachment>> allAttachmentLiveData = LiveDataFactory.buildDbLiveDataList(attachmentClass, () -> attachmentDao.getAttachmentsForMessage(messageId));
        LiveData onlyOneAttachmentOrEmpty = LiveDataFactory.map(allAttachmentLiveData, List.of(), attachments -> {
            if (attachments != null && attachments.size() == 1) {
                return attachments;
            }
            return List.of();
        });
        this.buildAttachmentInfoDataListView(onlyOneAttachmentOrEmpty, makeData, () -> new AttachmentInfoListCell(stackContext));
        LiveData<List<Attachment>> onlyMoreThanOneAttachmentsOrEmpty = LiveDataFactory.map(allAttachmentLiveData, List.of(), attachments -> {
            if (attachments != null && attachments.size() > 1) {
                return attachments;
            }
            return List.of();
        });
        InfoController.InfoState.AttachmentsListState<Message, Attachment> state = new InfoController.InfoState.AttachmentsListState<Message, Attachment>(messageId, messageClass, messageDao, attachmentClass, attachmentDao, makeData);
        this.buildAttachmentsSummaryDataListView(onlyMoreThanOneAttachmentsOrEmpty, state);
        if (recipientsCount > 0) {
            int effectiveRecipientsCountForStatusComputation = recipientsCount;
            if (recipientsCount > 1 && hasOwnedDevice) {
                --effectiveRecipientsCountForStatusComputation;
            }
            boolean multipleRecipientsStatus = effectiveRecipientsCountForStatusComputation > 1;
            this.buildStatusSummary(multipleRecipientsStatus);
        }
    }

    protected boolean showIndividualRecipientStatus() {
        return this.recipientsCount > 1;
    }

    protected abstract MetadataKind getMetadataKind(Metadata var1);

    protected LiveData<List<InfoData.MetadataOrStatus>> getTimelineLiveData() {
        return LiveDataFactory.map(this.metadataLiveData, List.of(), metadatas -> {
            ArrayList<InfoData.MetadataOrStatus> datas = new ArrayList<InfoData.MetadataOrStatus>();
            for (AbstractMessageMetadataGenerated metadata : metadatas) {
                datas.add(new InfoData.MetadataOrStatus(Either.left(this.getMetadataKind(metadata)), metadata.getTimestamp(), metadata.getDeleterId()));
            }
            return datas;
        });
    }

    private void buildAttachmentsSummaryDataListView(LiveData<List<Attachment>> attachmentLiveData, InfoController.InfoState.AttachmentsListState<Message, Attachment> state) {
        LiveData infoDataLiveData = LiveDataFactory.map(attachmentLiveData, List.of(), datas -> {
            if (datas == null || datas.size() <= 1) {
                return List.of();
            }
            return List.of(new InfoData.AttachmentsSummaryData(state, datas.size()));
        });
        VBoxList vBoxList = AbstractMessageInfoController.makeVBoxList((Pane)this.mainVBox, AttachmentSummaryListCell.class, () -> new AttachmentSummaryListCell(this.stackContext), Optional.empty());
        vBoxList.plug(infoDataLiveData);
        vBoxList.visibleProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)vBoxList.getChildren()).not());
        VBox.setMargin(vBoxList, (Insets)new Insets(24.0, 0.0, 0.0, 0.0));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void buildStatusSummary(boolean multipleRecipients) {
        VBoxList vBoxList = AbstractMessageInfoController.makeVBoxList((Pane)this.mainVBox, StatusInfoListCell.class, () -> new StatusInfoListCell(this.stackContext), Optional.empty());
        ArrayList<InfoData.StatusInfoData> datas = new ArrayList<InfoData.StatusInfoData>();
        OutboundMessageGenerated.Status[] statusArray = OutboundMessageGenerated.Status.values();
        int n = statusArray.length;
        int n2 = 0;
        while (true) {
            block8: {
                if (n2 >= n) {
                    vBoxList.update(datas);
                    AbstractMessageInfoController.attachTitle((Pane)this.mainVBox, ViewControllerHelper.getString("legend"), Optional.empty(), vBoxList);
                    return;
                }
                OutboundMessageGenerated.Status status = statusArray[n2];
                OutboundMessage.StatusKind statusKind = OutboundMessage.getStatusKind(status);
                switch (statusKind) {
                    case NONE: {
                        break block8;
                    }
                    case ANY_RECIPIENT: {
                        break;
                    }
                    case ONE_RECIPIENT: {
                        if (!multipleRecipients) break;
                        break block8;
                    }
                    case MULTIPLE_RECIPIENTS: {
                        if (!multipleRecipients) break block8;
                    }
                }
                datas.add(new InfoData.StatusInfoData(status));
            }
            ++n2;
        }
    }
}

