/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.message_infos.controller.attachments;

import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.AbstractInfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.controller.InfoController;
import io.olvid.windows.messenger.fx.modal.message_infos.view.attachments.AttachmentInfoListCell;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.Label;

public class AttachmentsListInfoController<Message extends AbstractUserMessageGenerated<Message>, Attachment extends AbstractAttachmentGenerated<Attachment>>
extends AbstractInfoController<Message> {
    private final LiveData<List<Attachment>> attachmentLiveData;
    private final Label count = new Label();

    public AttachmentsListInfoController(StackContext<InfoController.InfoState> stackContext, InfoController.InfoState.AttachmentsListState<Message, Attachment> state) {
        super(stackContext, state.messageId(), state.messageClass(), state.messageDao());
        this.attachmentLiveData = LiveDataFactory.buildDbLiveDataList(state.attachmentClass(), () -> state.attachmentDao().getAttachmentsForMessage(state.messageId()));
        this.buildAttachmentInfoDataListView(this.attachmentLiveData, state.makeData(), () -> new AttachmentInfoListCell(stackContext));
        this.title.setText(ViewControllerHelper.getString("text_attachments"));
        this.count.getStyleClass().addAll((Object[])new String[]{"h1", "grey-text"});
        ObservableList headerChildren = this.headerHBox.getChildren();
        int indexOfTitle = headerChildren.indexOf((Object)this.title);
        headerChildren.add(indexOfTitle + 1, (Object)this.count);
        this.attachmentLiveData.addListener(this::attachmentLiveDataListener);
    }

    @Override
    public void onLayoutDetached() {
        super.onLayoutDetached();
        this.attachmentLiveData.removeListener(this::attachmentLiveDataListener);
    }

    private void attachmentLiveDataListener(List<Attachment> newValue, List<Attachment> oldValue) {
        ViewControllerHelper.smartUIUpdate(() -> {
            if (newValue == null) {
                this.count.setText(null);
            } else {
                this.count.setText(String.format(" (%d)", newValue.size()));
            }
        });
    }
}

