/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.invitation_new;

import io.olvid.windows.messenger.engine.helpers.invitations.InvitationApi;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.helpers.SizeObserver;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import net.glxn.qrgen.QRCode;
import net.glxn.qrgen.image.ImageType;

@FXMLView(path="fx/modal/invitation_new/invitation_new_modal.fxml")
public class InvitationNewModalController
extends BaseModalController {
    @FXML
    private VBox invitation_container;
    @FXML
    private ImageView qrcode_image_view;
    @FXML
    private Button button_import_link;
    @FXML
    private Button button_export_link;
    private String invitationUrl;
    private final Optional<OwnedIdentityInfo> currentOwnedIdentityInfo = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();

    public InvitationNewModalController() {
        this.loadFxml();
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        if (this.currentOwnedIdentityInfo.isEmpty()) {
            return;
        }
        this.invitationUrl = InvitationApi.getUrlRepresentation(this.currentOwnedIdentityInfo.get());
        this.qrcode_image_view.setImage(this.createQrCodeImageView(this.invitationUrl));
        this.button_export_link.setOnMouseClicked(event -> this.eventHandlerCopyUrlInvitationLinkToClipboard());
        this.button_import_link.setOnMouseClicked(event -> this.eventHandlerSendInvitationFromClipboard());
        this.button_export_link.prefWidthProperty().bind((ObservableValue)this.getModalWidth());
        this.button_import_link.prefWidthProperty().bind((ObservableValue)this.getModalWidth());
        ReadOnlyDoubleProperty buttonHeightProperty = SizeObserver.getObservableSizePercentWithMax((ReadOnlyDoubleProperty)this.getModalHeight(), 10, 40.0);
        this.button_export_link.prefHeightProperty().bind((ObservableValue)buttonHeightProperty);
        this.button_import_link.prefHeightProperty().bind((ObservableValue)buttonHeightProperty);
    }

    @Override
    public Region getLayout() {
        return this.invitation_container;
    }

    private Image createQrCodeImageView(String invitationUrl) {
        ByteArrayOutputStream out = QRCode.from((String)invitationUrl).to(ImageType.PNG).withSize(400, 400).stream();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        return new Image((InputStream)in);
    }

    private void eventHandlerCopyUrlInvitationLinkToClipboard() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(this.invitationUrl);
        clipboard.setContent((Map)content);
    }

    private void eventHandlerSendInvitationFromClipboard() {
        if (this.currentOwnedIdentityInfo.isEmpty()) {
            return;
        }
        Clipboard clipboard = Clipboard.getSystemClipboard();
        String clipboardContent = (String)clipboard.getContent(DataFormat.PLAIN_TEXT);
        if (clipboardContent != null && InvitationApi.sendInvitation(clipboardContent, this.currentOwnedIdentityInfo.get().bytesOwnedIdentity())) {
            this.closeModalDelegate.run();
        } else {
            AppLogger.e("Invitation is not valid !!");
        }
    }
}

