/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.confirmation.keycloak;

import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakUserDetailsListItemData;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListPanelSelectModel;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.confirmation.ConfirmationModalController;
import io.olvid.windows.messenger.keycloak.KeycloakCallReturn;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import java.text.MessageFormat;
import java.util.Optional;
import javafx.collections.ObservableSet;
import javafx.scene.input.MouseEvent;

public class AddKeycloakContactConfirmationModalController
extends ConfirmationModalController {
    public static final String ADD_KEYCLOAK_USER_HEADER_TEXT_LABEL = "add_keycloak_user_header_text_label";
    public static final String ADD_KEYCLOAK_USER_DESCRIPTION_TEXT_LABEL = "add_keycloak_user_description_text_label";
    public static final String ADD_KEYCLOAK_USER_COUNT_TEXT_LABEL = "add_keycloak_user_count_text_label";
    public static final String VALIDATE = "validate";
    private final ListPanelSelectModel<KeycloakUserDetailsListItemData> keycloakDirSelectedContact;

    public AddKeycloakContactConfirmationModalController(ListPanelSelectModel<KeycloakUserDetailsListItemData> keycloakDirSearchSelectModel) {
        String args;
        String resource;
        this.keycloakDirSelectedContact = keycloakDirSearchSelectModel;
        if (this.keycloakDirSelectedContact == null) {
            return;
        }
        ObservableSet<KeycloakUserDetailsListItemData> selectedItems = this.keycloakDirSelectedContact.getSelectedItems();
        if (selectedItems.isEmpty()) {
            return;
        }
        if (selectedItems.size() == 1) {
            String formattedDisplayName = JsonIdentityDetails.joinNames((String)((KeycloakUserDetailsListItemData)selectedItems.iterator().next()).firstName, (String)((KeycloakUserDetailsListItemData)selectedItems.iterator().next()).lastName, (boolean)false, (boolean)false);
            resource = ADD_KEYCLOAK_USER_DESCRIPTION_TEXT_LABEL;
            args = formattedDisplayName;
        } else {
            resource = ADD_KEYCLOAK_USER_COUNT_TEXT_LABEL;
            args = String.valueOf(selectedItems.size());
        }
        this.modalContentText.setText(MessageFormat.format(ViewControllerHelper.RESOURCE_BUNDLE.getString(resource).replace("\n", System.lineSeparator()), args));
        this.confirmationModalHeaderLabel.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString(ADD_KEYCLOAK_USER_HEADER_TEXT_LABEL).replace("\n", System.lineSeparator()));
        this.validateButton.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString(VALIDATE));
    }

    @Override
    protected void onCancelClicked(MouseEvent mouseEvent) {
        this.closeModalDelegate.run();
    }

    @Override
    protected void onValidateClicked(MouseEvent mouseEvent) {
        Optional<OwnedIdentityInfo> selectedOwnedIdentityOpt = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
        if (selectedOwnedIdentityOpt.isEmpty()) {
            return;
        }
        for (KeycloakUserDetailsListItemData keycloakUserDetailsListItemData : this.keycloakDirSelectedContact.getSelectedItems()) {
            KeycloakCallReturn<Integer> ret = KeycloakManager.getInstance().addContact(selectedOwnedIdentityOpt.get().bytesOwnedIdentity(), keycloakUserDetailsListItemData.id, keycloakUserDetailsListItemData.identity);
            if (ret.isSuccess()) continue;
            this.logger.error("AddKeycloakContactConfirmationModalController::onValidateClicked Couldn't add contact...");
        }
        this.keycloakDirSelectedContact.clearSelection();
        this.closeModalDelegate.run();
    }
}

