/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.confirmation.discussion_deletion;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.fx.custom_components.loader.RingProgressIndicator;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.modal.confirmation.ConfirmationModalController;
import io.olvid.windows.messenger.fx.modal.confirmation.discussion_deletion.DiscussionDeletionModalModel;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class DiscussionDeletionModalController
extends ConfirmationModalController {
    public static final String SURE_DELETE_TITLE_LABEL = "modal_delete_discussion_title";
    public static final String SURE_DELETE_DESCRIPTION_LABEL = "modal_delete_discussion_description";
    public static final String DELETE_LOCALLY_RADIO_LABEL = "modal_delete_discussion_locally";
    public static final String DELETE_OWNED_DEVICES_RADIO_LABEL = "modal_delete_discussion_owned_devices";
    public static final String DELETE_EVERYWHERE_RADIO_LABEL = "modal_delete_discussion_everywhere";
    final StackPane contentOrSpinner = new StackPane();
    final RingProgressIndicator contentRingProgress = new RingProgressIndicator();
    protected final StackPane contentRingContainer = new StackPane();
    final VBox choiceContainer = new VBox();
    final RadioButton deleteLocallyRadio = new RadioButton(ViewControllerHelper.getString("modal_delete_discussion_locally"));
    final RadioButton deleteOwnedDevices = new RadioButton(ViewControllerHelper.getString("modal_delete_discussion_owned_devices"));
    final RadioButton deleteEverywhere = new RadioButton(ViewControllerHelper.getString("modal_delete_discussion_everywhere"));
    final ToggleGroup tg = new ToggleGroup();
    private final DiscussionDeletionModalModel model;

    public DiscussionDeletionModalController(Id<Discussion> discussionId) {
        Objects.requireNonNull(discussionId);
        this.model = new DiscussionDeletionModalModel(discussionId);
        this.setSize(ModalConfiguration.ModalSize.MEDIUM);
        this.confirmationModalHeaderLabel.setText(ViewControllerHelper.getString(SURE_DELETE_TITLE_LABEL));
        this.modalContentText.setText(ViewControllerHelper.getString(SURE_DELETE_DESCRIPTION_LABEL));
        this.deleteLocallyRadio.getStyleClass().addAll((Object[])new String[]{"black-radio-button", "body-1"});
        this.deleteLocallyRadio.setFocusTraversable(false);
        this.deleteLocallyRadio.setUserData((Object)DeletionMode.LOCAL);
        this.deleteLocallyRadio.setToggleGroup(this.tg);
        this.deleteOwnedDevices.getStyleClass().addAll((Object[])new String[]{"black-radio-button", "body-1"});
        this.deleteOwnedDevices.setFocusTraversable(false);
        this.deleteOwnedDevices.setUserData((Object)DeletionMode.ONLY_OWNED_DEVICES);
        this.deleteOwnedDevices.setToggleGroup(this.tg);
        this.deleteEverywhere.getStyleClass().addAll((Object[])new String[]{"black-radio-button", "body-1"});
        this.deleteEverywhere.setFocusTraversable(false);
        this.deleteEverywhere.visibleProperty().bind((ObservableValue)this.model.canDeleteEverywhere);
        this.deleteEverywhere.setUserData((Object)DeletionMode.EVERYWHERE);
        this.deleteEverywhere.setToggleGroup(this.tg);
        this.contentRingProgress.getStyleClass().setAll((Object[])new String[]{"sync-progress-indicator", "indeterminate"});
        this.contentRingProgress.setProgress(-1);
        this.contentRingProgress.setInnerCircleRadius(8);
        this.contentRingProgress.setRingWidth(2);
        this.contentRingContainer.getChildren().add((Object)this.contentRingProgress);
        this.contentRingContainer.visibleProperty().bind((ObservableValue)this.model.loading);
        this.choiceContainer.setSpacing(12.0);
        this.choiceContainer.setPadding(new Insets(8.0, 8.0, 8.0, 8.0));
        this.choiceContainer.setAlignment(Pos.CENTER_LEFT);
        this.choiceContainer.visibleProperty().bind((ObservableValue)this.model.loading.not());
        this.choiceContainer.getChildren().addAll((Object[])new Node[]{this.deleteLocallyRadio, this.deleteOwnedDevices, this.deleteEverywhere});
        this.contentOrSpinner.setAlignment(Pos.CENTER);
        this.contentOrSpinner.getChildren().addAll((Object[])new Node[]{this.choiceContainer, this.contentRingContainer});
        this.validateButton.setText(ViewControllerHelper.getString("validate"));
        this.contextualTextVbox.getChildren().add(2, (Object)this.contentOrSpinner);
    }

    public static DiscussionDeletionModalController of(Id<Discussion> discussionId) {
        return new DiscussionDeletionModalController(discussionId);
    }

    @Override
    protected void onValidateClicked(MouseEvent mouseEvent) {
        this.model.loading.set(true);
        AsyncTaskExecutor.submitTask(() -> {
            RadioButton rb;
            Object patt1$temp;
            Toggle patt0$temp = this.tg.getSelectedToggle();
            if (patt0$temp instanceof RadioButton && (patt1$temp = (rb = (RadioButton)patt0$temp).getUserData()) instanceof DeletionMode) {
                DeletionMode delMode = (DeletionMode)((Object)((Object)patt1$temp));
                if (this.model.handleDeletion(delMode)) {
                    ViewControllerHelper.smartUIUpdate(() -> this.closeModalDelegate.run());
                } else {
                    ViewControllerHelper.smartUIUpdate(() -> this.model.loading.set(false));
                }
            }
        });
    }

    public static enum DeletionMode {
        LOCAL,
        ONLY_OWNED_DEVICES,
        EVERYWHERE;

    }
}

