/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.confirmation;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.engine.helpers.owned_identity.OwnedIdentityApi;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.MainStackManager;
import io.olvid.windows.messenger.fx.misc.OptionalUtils;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.modal.confirmation.ConfirmationModalController;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import java.util.List;
import java.util.Optional;
import javafx.scene.input.MouseEvent;

public class ConfirmationDeleteOwnedIdentityModalController
extends ConfirmationModalController {
    private final OwnedIdentityInfo ownedIdentityInfo;
    private static final String MODAL_CONTENT = "are_you_sure_to_delete_owned_identity_modal_content";
    private static final String REMOVE = "remove";

    public ConfirmationDeleteOwnedIdentityModalController(OwnedIdentityInfo ownedIdentityInfo) {
        this.ownedIdentityInfo = ownedIdentityInfo;
        if (this.ownedIdentityInfo != null) {
            Object text = ViewControllerHelper.getString(REMOVE);
            Optional<String> firstAndLastName = OptionalUtils.join(" ", List.of(ownedIdentityInfo.detailsInfo().firstName(), ownedIdentityInfo.detailsInfo().lastName()));
            if (firstAndLastName.isPresent()) {
                text = (String)text + " " + firstAndLastName.get();
            }
            text = (String)text + " ?";
            this.confirmationModalHeaderLabel.setText((String)text);
            this.validateButton.setText((String)text);
            this.setSize(ModalConfiguration.ModalSize.SMALL);
            this.modalContentText.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString(MODAL_CONTENT));
            this.validateButton.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString(REMOVE));
        }
    }

    @Override
    protected void onCancelClicked(MouseEvent mouseEvent) {
        this.closeModalDelegate.run();
    }

    @Override
    protected void onValidateClicked(MouseEvent mouseEvent) {
        AsyncTaskExecutor.submitTask(() -> {
            List<OwnedIdentity> ownedIdentityList = DbManager.getInstance().getOwnedIdentityDao().getAllSortedByIndexWithoutThisIdentity(this.ownedIdentityInfo.genId());
            OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(this.ownedIdentityInfo.genId());
            OwnedIdentityApi.deleteOwnedIdentityAndNotifyContacts(ownedIdentity, false);
            ViewControllerHelper.smartUIUpdate(() -> {
                this.closeModalDelegate.run();
                if (ownedIdentityList.isEmpty()) {
                    MainStackManager.displayedLayerState.pushState(MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.OWNED_IDENTITY_MANAGEMENT));
                } else {
                    SelectedOwnedIdentitySingleton.getInstance().updateCurrentIdentity((OwnedIdentity)ownedIdentityList.getFirst());
                }
            });
        });
    }
}

