/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.confirmation;

import io.olvid.windows.messenger.fx.framework.utils.FxIcons;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Shape;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

public class ConfirmModalController
extends BaseModalController {
    private final StackPane root = new StackPane();
    private final VBox container = new VBox(16.0);
    private final HBox header = new HBox(12.0);
    private final StackPane iconWrapper = new StackPane();
    private final Label titleLabel = new Label();
    private final Pane spacer = new Pane();
    private final Button closeButton = new Button();
    private final Label descriptionLabel = new Label();
    private final VBox actionsBox = new VBox(8.0);
    private final StringProperty title = new SimpleStringProperty();
    private final StringProperty description = new SimpleStringProperty();
    private final ObjectProperty<Node> icon = new SimpleObjectProperty(null);
    private final ObjectProperty<BadgeKind> badgeKind = new SimpleObjectProperty((Object)BadgeKind.DEFAULT);
    private final EventHandler<KeyEvent> keyEventHandler = this::keyPressedHandler;

    public StringProperty titleProperty() {
        return this.title;
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public ObjectProperty<Node> iconProperty() {
        return this.icon;
    }

    public Parent getRoot() {
        return this.root;
    }

    public ObjectProperty<BadgeKind> badgeKindProperty() {
        return this.badgeKind;
    }

    public void setBadgeKind(BadgeKind kind) {
        this.badgeKind.set((Object)kind);
    }

    public BadgeKind getBadgeKind() {
        return (BadgeKind)((Object)this.badgeKind.get());
    }

    public ConfirmModalController(ModalConfiguration.ModalSize size) {
        this.setSize(size);
        this.buildUI();
        this.handleBehavior();
        this.handleBindings();
    }

    public ConfirmModalController(double width) {
        this.setSize(ModalConfiguration.ModalSize.SELF_SIZE);
        this.buildUI();
        this.root.setPrefWidth(width);
        this.handleBehavior();
        this.handleBindings();
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    protected Optional<EventHandler<KeyEvent>> getCloseKeyEventHandler() {
        return Optional.of(this.keyEventHandler);
    }

    public void configure(String title, String description, Node icon, List<ConfirmationAction> actions) {
        this.title.set((Object)title);
        this.description.set((Object)description);
        this.icon.set((Object)icon);
        if (icon != null) {
            if (title != null) {
                this.iconWrapper.setPadding(new Insets(16.0, 0.0, 0.0, 16.0));
                this.titleLabel.setPadding(new Insets(16.0, 0.0, 0.0, 0.0));
            } else {
                this.iconWrapper.setPadding(new Insets(24.0, 0.0, 0.0, 16.0));
            }
        }
        this.setActions(actions);
    }

    public void setActions(List<ConfirmationAction> actionList) {
        this.actionsBox.getChildren().clear();
        if (actionList == null || actionList.isEmpty()) {
            return;
        }
        for (ConfirmationAction a : actionList) {
            Button b = new Button(a.label());
            b.getStyleClass().addAll(a.classes);
            b.setMaxWidth(Double.MAX_VALUE);
            b.setDefaultButton(a.isDefault());
            b.setCancelButton(a.isCancel());
            b.setOnAction(ev -> {
                if (a.onAction() != null) {
                    try {
                        a.onAction().run();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                this.close();
            });
            this.actionsBox.getChildren().add((Object)b);
        }
    }

    private void buildUI() {
        this.root.setOpacity(0.0);
        this.header.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow((Node)this.spacer, (Priority)Priority.ALWAYS);
        this.closeButton.getStyleClass().addAll((Object[])new String[]{"transparent-icon-button"});
        this.closeButton.setFocusTraversable(false);
        this.closeButton.setTooltip(new Tooltip("Fermer"));
        Label x = new Label("x");
        x.getStyleClass().add((Object)"h1");
        x.setPadding(new Insets(0.0, 12.0, 0.0, 12.0));
        Node closeIcon = FxIcons.icon(FxIcons.CLOSE((Paint)Color.BLACK, (Paint)Color.BLACK), 12.0, 12.0);
        this.closeButton.setGraphic(closeIcon);
        HBox.setMargin((Node)this.closeButton, (Insets)new Insets(12.0, 12.0, 0.0, 0.0));
        this.titleLabel.setAlignment(Pos.CENTER);
        this.titleLabel.setTextAlignment(TextAlignment.CENTER);
        this.titleLabel.getStyleClass().add((Object)"h1");
        this.titleLabel.setPadding(new Insets(16.0, 0.0, 0.0, 12.0));
        this.header.getChildren().addAll((Object[])new Node[]{this.iconWrapper, this.titleLabel, this.spacer, this.closeButton});
        this.descriptionLabel.getStyleClass().add((Object)"h2");
        this.descriptionLabel.setPadding(new Insets(16.0, 16.0, 0.0, 20.0));
        this.descriptionLabel.setWrapText(true);
        this.descriptionLabel.maxWidthProperty().bind((ObservableValue)this.container.widthProperty().subtract(32));
        this.descriptionLabel.setMinHeight(Double.NEGATIVE_INFINITY);
        this.actionsBox.getStyleClass().add((Object)"actions-vertical");
        this.actionsBox.setPadding(new Insets(16.0, 16.0, 16.0, 16.0));
        this.actionsBox.setMinHeight(Double.NEGATIVE_INFINITY);
        StackPane.setAlignment((Node)this.container, (Pos)Pos.CENTER);
        if (this.getSize() == ModalConfiguration.ModalSize.SELF_SIZE) {
            this.root.setPrefSize(-1.0, -1.0);
            this.root.setMinSize(380.0, Double.NEGATIVE_INFINITY);
        } else {
            this.root.prefWidthProperty().bind((ObservableValue)this.getModalWidth());
            this.root.prefHeightProperty().bind((ObservableValue)this.getModalHeight());
        }
        this.container.setFillWidth(true);
        this.container.getChildren().addAll((Object[])new Node[]{this.header, this.descriptionLabel, this.actionsBox});
        this.root.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.root.getStyleClass().addAll((Object[])new String[]{"modal", "confirmation-modal"});
        this.root.getChildren().add((Object)this.container);
    }

    private void handleBehavior() {
        this.closeButton.setOnAction(e -> this.close());
        this.root.sceneProperty().addListener((obs, oldS, newS) -> {
            if (newS != null) {
                this.root.requestFocus();
                if (this.root.getOpacity() == 0.0) {
                    FadeTransition ft = new FadeTransition(Duration.millis((double)150.0), (Node)this.root);
                    ft.setFromValue(0.0);
                    ft.setToValue(1.0);
                    FadeTransition fadeContainer = new FadeTransition(Duration.millis((double)150.0), (Node)this.container);
                    ft.setFromValue(0.0);
                    ft.setToValue(1.0);
                    ParallelTransition appearsTransition = new ParallelTransition(new Animation[]{ft, fadeContainer});
                    appearsTransition.play();
                }
            }
        });
    }

    private void keyPressedHandler(KeyEvent e) {
        if (e.getCode() == KeyCode.ESCAPE) {
            e.consume();
            this.close();
        } else if (e.getCode() == KeyCode.ENTER) {
            e.consume();
            this.triggerDefaultAction();
        }
    }

    private void handleBindings() {
        this.titleLabel.textProperty().bind((ObservableValue)this.title);
        this.titleLabel.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.title.get() != null && !((String)this.title.get()).isBlank(), (Observable[])new Observable[]{this.title}));
        this.icon.addListener((obs, oldNode, newNode) -> this.rebuildIconWrapper((Node)newNode));
        this.badgeKind.addListener((obs, o, n) -> this.rebuildIconWrapper((Node)this.icon.get()));
        this.iconWrapper.visibleProperty().bind((ObservableValue)this.icon.isNotNull());
        this.iconWrapper.managedProperty().bind((ObservableValue)this.iconWrapper.visibleProperty());
        this.descriptionLabel.textProperty().bind((ObservableValue)this.description);
        this.descriptionLabel.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.description.get() != null && !((String)this.description.get()).isBlank(), (Observable[])new Observable[]{this.description}));
        this.descriptionLabel.managedProperty().bind((ObservableValue)this.descriptionLabel.visibleProperty());
    }

    private void triggerDefaultAction() {
        this.actionsBox.getChildren().stream().filter(n -> n instanceof Button && ((Button)n).isDefaultButton()).map(n -> (Button)n).findFirst().ifPresent(Button::fire);
    }

    private void close() {
        Runnable delegate = this.getCloseModalDelegate();
        if (this.root.getScene() == null) {
            if (delegate != null) {
                delegate.run();
            }
            return;
        }
        FadeTransition ft = new FadeTransition(Duration.millis((double)120.0), (Node)this.root);
        ft.setFromValue(this.root.getOpacity());
        ft.setToValue(0.0);
        ft.setCycleCount(1);
        this.root.setCache(true);
        this.root.setCacheHint(CacheHint.SPEED);
        ft.setOnFinished(ev -> {
            this.root.setCache(false);
            if (delegate != null) {
                delegate.run();
            }
        });
        ft.play();
    }

    private void rebuildIconWrapper(Node content) {
        this.iconWrapper.getChildren().clear();
        if (content == null) {
            return;
        }
        BadgeKind kind = this.getBadgeKind();
        if (kind == BadgeKind.TRANSPARENT) {
            this.iconWrapper.getChildren().setAll((Object[])new Node[]{content});
            StackPane.setAlignment((Node)content, (Pos)Pos.CENTER);
            this.applyStrokeFillToContent(content, kind, false);
            return;
        }
        Color base = Color.web((String)this.cssColorFor(kind));
        Circle bgOuter = new Circle(24.0);
        Circle bgInner = new Circle(18.0);
        bgOuter.setFill((Paint)base.deriveColor(0.0, 1.0, 1.0, 0.08));
        bgInner.setFill((Paint)base.deriveColor(0.0, 1.0, 1.0, 0.12));
        this.iconWrapper.getChildren().setAll((Object[])new Node[]{bgOuter, bgInner, content});
        StackPane.setAlignment((Node)content, (Pos)Pos.CENTER);
        this.applyStrokeFillToContent(content, kind, false);
    }

    private String cssColorFor(BadgeKind kind) {
        return switch (kind.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> "#2962FF";
            case 2 -> "#6A6D78";
            case 3 -> "#F9A825";
            case 4 -> "#E53935";
            case 0 -> "#5F6368";
            case 5 -> "transparent";
        };
    }

    private void applyStrokeFillToContent(Node content, BadgeKind kind, boolean setFillToo) {
        if (content == null) {
            return;
        }
        String css = this.cssColorFor(kind);
        if (content instanceof Shape) {
            Shape s = (Shape)content;
            this.applyOnShape(s, css, setFillToo);
            return;
        }
        if (content instanceof Parent) {
            Parent p = (Parent)content;
            for (Node child : p.getChildrenUnmodifiable()) {
                this.applyStrokeFillToContent(child, kind, setFillToo);
            }
        }
    }

    private void applyOnShape(Shape s, String css, boolean setFillToo) {
        StringBuilder sb = new StringBuilder("-fx-color: ").append(css).append(";");
        if (setFillToo) {
            sb.append(" -fx-fill: ").append(css).append(";");
        }
        s.setStyle(sb.toString());
    }

    public static enum BadgeKind {
        DEFAULT,
        PRIMARY,
        SECONDARY,
        WARNING,
        DANGER,
        TRANSPARENT;

    }

    public static final class ConfirmationAction {
        private final String label;
        private final List<String> classes;
        private final Runnable onAction;
        private final boolean isDefault;
        private final boolean isCancel;

        private ConfirmationAction(String label, List<String> classes, Runnable onAction, boolean isDefault, boolean isCancel) {
            this.label = Objects.requireNonNull(label);
            this.classes = classes == null ? List.of("button") : classes;
            this.onAction = onAction;
            this.isDefault = isDefault;
            this.isCancel = isCancel;
        }

        public static ConfirmationAction of(String label, List<String> classes, Runnable onAction) {
            return new ConfirmationAction(label, classes, onAction, false, false);
        }

        public ConfirmationAction asDefault() {
            return new ConfirmationAction(this.label, this.classes, this.onAction, true, this.isCancel);
        }

        public ConfirmationAction asCancel() {
            return new ConfirmationAction(this.label, this.classes, this.onAction, this.isDefault, true);
        }

        public String label() {
            return this.label;
        }

        public List<String> classes() {
            return this.classes;
        }

        public Runnable onAction() {
            return this.onAction;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public boolean isCancel() {
            return this.isCancel;
        }

        public static enum Kind {
            PRIMARY,
            SECONDARY,
            DANGER,
            LINK;

        }
    }
}

