/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal.attachmentsViewer;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.ephemerality.InboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.ephemerality.OwnedMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.InboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageKind;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.attachment.AttachmentUtils;
import io.olvid.windows.messenger.fx.custom_components.LoadingViewController;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.custom_components.ephemerality.EphemeralInfoView;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.AttachmentInfos;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageItem;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.ImageHelper;
import io.olvid.windows.messenger.fx.misc.ImageLruCache;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.modal.attachmentsViewer.AttachmentView;
import io.olvid.windows.messenger.fx.modal.attachmentsViewer.AttachmentViewerViewModel;
import io.olvid.windows.messenger.fx.modal.attachmentsViewer.AttachmentsViewerModel;
import io.olvid.windows.messenger.fx.modal.attachmentsViewer.ErrorType;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.AttachmentProgressCache;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.DateUtils;
import io.olvid.windows.messenger.misc.ImageUtils;
import io.olvid.windows.messenger.misc.Result;
import java.lang.runtime.SwitchBootstraps;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

@FXMLView(path="fx/modal/media_viewer/mediaViewer.fxml")
public class AttachmentsViewerModalController
extends BaseModalController
implements LoadingViewController.ConfiguratorDelegate<AttachmentView, AttachmentConfiguration, Throwable> {
    private final ImageLruCache IMAGE_VIEWER_LRU_CACHE = new ImageLruCache(100L);
    private AttachmentView view;
    private EventHandler<KeyEvent> keyEventEventHandler;
    @FXML
    private Label source_name;
    @FXML
    private Label image_data;
    @FXML
    private Region root;
    @FXML
    private Button close;
    @FXML
    private Button left_button;
    @FXML
    private Button right_button;
    @FXML
    private Label error_label;
    @FXML
    private Pane image_container;
    @FXML
    private Pane bubble_container;
    @FXML
    private Button download_button;
    @FXML
    private Button save_button;
    @FXML
    private StackPane expiration_container;
    private final IdentityBubble bubble = new IdentityBubble(28.0);
    private final AttachmentViewerViewModel viewModel = new AttachmentViewerViewModel();
    private MessageItem currentMessage;
    private AttachmentInfos currentAttachment;
    private LoadingViewController<AttachmentView, AttachmentConfiguration, Throwable> loadingAttachmentView;
    private final EphemeralInfoView ephemeralInfoView;
    private final LiveDataListener<List<AttachmentInfos>> attachmentsLiveDataListener = this::attachmentListChangeListener;
    private final LiveDataListener<Optional<InboundMessageEphemeralInfo>> inboundMessageEphemeralInfoChangeListener = this::messageEphemeralInfoChangeListener;
    private final LiveDataListener<Optional<OutboundMessageEphemeralInfo>> outboundMessageEphemeralInfoChangeListener = this::messageEphemeralInfoChangeListener;
    private final LiveDataListener<Optional<OwnedMessageEphemeralInfo>> ownedMessageEphemeralInfoChangeListener = this::messageEphemeralInfoChangeListener;
    private Optional<Id<ContactRef>> senderRefId = Optional.empty();
    private boolean isListeningOwnedIdentity = false;
    private final LiveDataListener<ContactInfoLiveData.ContactInfoState> contactInfoChangeListener = this::contactInfoChangeListener;
    private final LiveDataListener<Optional<OwnedIdentityInfo>> ownedIdentityInfoChangeListener = this::ownedIdentityInfoChangeListener;
    private boolean isListeningInboundDownloadCache = false;
    private final LiveDataListener<Map<Id<InboundAttachment>, Float>> inboundDownloadingProgressListener = this::inboundDownloadingProgressListener;
    private boolean isListeningOwnedDownloadCache = false;
    private final LiveDataListener<Map<Id<OwnedAttachment>, Float>> ownedDownloadingProgressListener = this::ownedDownloadingProgressListener;
    private final AttachmentsViewerModel model;

    public AttachmentsViewerModalController(AttachmentsViewerModel model) {
        this.model = model;
        this.ephemeralInfoView = new EphemeralInfoView(model.getTickerLiveData());
        model.getViewerAttachmentsListLiveData().addListener(this.attachmentsLiveDataListener);
        this.loadFxml();
        this.setSize(ModalConfiguration.ModalSize.SELF_SIZE);
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.close.setOnAction(event -> this.close());
        this.left_button.setOnAction(this::onLeftButtonClicked);
        this.right_button.setOnAction(this::onRightButtonClicked);
        this.view = new AttachmentView(this.image_container);
        this.loadingAttachmentView = LoadingViewController.make(this.view, this);
        this.image_container.getChildren().add(0, (Object)this.loadingAttachmentView.getLayout());
        this.error_label.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.viewModel.getErrorType().getErrorText(), (Observable[])new Observable[]{this.viewModel.errorTypeProperty()}));
        this.source_name.textProperty().bind(this.viewModel.senderNameProperty().orElse((Object)ViewControllerHelper.getString("deleted_contact")));
        this.image_data.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> String.join((CharSequence)" - ", Stream.of(this.viewModel.getDate(), this.viewModel.getImageName()).filter(Objects::nonNull).filter(str -> !str.isEmpty()).toList()), (Observable[])new Observable[]{this.viewModel.dateProperty(), this.viewModel.imageNameProperty()}));
        this.bubble_container.getChildren().add((Object)this.bubble);
        this.expiration_container.getChildren().add((Object)this.ephemeralInfoView);
        this.initDownloadButton();
        this.initSaveButton();
    }

    private void initDownloadButton() {
        this.download_button.setOnAction(event -> this.buttonHandler());
        this.download_button.managedProperty().bind((ObservableValue)this.download_button.visibleProperty());
        this.download_button.visibleProperty().bind((ObservableValue)this.viewModel.downloadableProperty());
        this.download_button.setText(ViewControllerHelper.getString("media_viewer_download"));
    }

    private void initSaveButton() {
        this.save_button.setOnAction(event -> this.save());
        this.save_button.managedProperty().bind((ObservableValue)this.save_button.visibleProperty());
        this.save_button.visibleProperty().bind((ObservableValue)this.viewModel.completeProperty());
    }

    @Override
    public void configureView(AttachmentView attachmentView, AttachmentConfiguration configuration) {
        if (configuration instanceof ImageConfiguration) {
            ImageConfiguration imageConfiguration = (ImageConfiguration)configuration;
            attachmentView.configureImage(imageConfiguration);
        }
    }

    @Override
    public void configureError(Result<AttachmentConfiguration, Throwable> throwable) {
        this.loadingAttachmentView.showLabel("Internal error");
    }

    @Override
    public void configureButton(Button button) {
        button.getStyleClass().add((Object)"download-button-pane");
    }

    @Override
    public void configureLabel(Label label) {
    }

    @Override
    public void buttonHandler() {
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                if (this.currentAttachment.isReceived()) {
                    Id<Discussion> discussionId = this.currentMessage.getDiscussionId();
                    Discussion discussion = DbManager.getInstance().getDiscussionDao().get(discussionId);
                    Id<OwnedIdentity> ownedIdentityId = discussion.getOwnedIdentityId();
                    OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(ownedIdentityId);
                    byte[] bytesOwnedIdentity = ownedIdentity.getBytesOwnedIdentity();
                    ReceivedAttachmentGenerated<?> receivedAttachment = this.currentAttachment.getReceivedAttachment();
                    byte[] engineMessageIdentifier = receivedAttachment.getEngineMessageIdentifier();
                    Api.getAttachmentApi().downloadLargeAttachment(bytesOwnedIdentity, receivedAttachment.getItemId(), engineMessageIdentifier, this.currentAttachment.getIdx());
                }
                return null;
            });
        }
        catch (SQLException e) {
            AppLogger.e("AttachmentsViewerModelController:buttonHandler: cannot perform download", e);
        }
    }

    private void clean() {
        if (this.currentAttachment != null) {
            this.loadingAttachmentView.getView().imageView.setImage(null);
            switch (this.currentMessage.kind) {
                case INBOUND: {
                    Optional<Id<InboundMessageEphemeralInfo>> inboundMessageEphemeralInfoId = this.currentMessage.getInboundMessage().getInboundMessageEphemeralInfoId();
                    if (!inboundMessageEphemeralInfoId.isPresent()) break;
                    this.model.getInboundMessageEphemeralInfoPerMessageId().removeListener(inboundMessageEphemeralInfoId.get(), this.inboundMessageEphemeralInfoChangeListener);
                    break;
                }
                case OUTBOUND: {
                    Optional<Id<OutboundMessageEphemeralInfo>> outboundMessageEphemeralInfoId = this.currentMessage.getOutboundMessage().getOutboundMessageEphemeralInfoId();
                    if (!outboundMessageEphemeralInfoId.isPresent()) break;
                    this.model.getOutboundMessageEphemeralInfoPerMessageId().removeListener(outboundMessageEphemeralInfoId.get(), this.outboundMessageEphemeralInfoChangeListener);
                    break;
                }
                case OWNED: {
                    Optional<Id<OwnedMessageEphemeralInfo>> ownedMessageEphemeralInfoId = this.currentMessage.getOwnedMessage().getOwnedMessageEphemeralInfoId();
                    if (!ownedMessageEphemeralInfoId.isPresent()) break;
                    this.model.getOwnedMessageEphemeralInfoPerMessageId().removeListener(ownedMessageEphemeralInfoId.get(), this.ownedMessageEphemeralInfoChangeListener);
                    break;
                }
            }
        }
        if (this.senderRefId.isPresent()) {
            DbCache.getInstance().contactRefInfoMapLiveData.removeListener(this.senderRefId.get(), this.contactInfoChangeListener);
            this.senderRefId = Optional.empty();
        }
        if (this.isListeningOwnedIdentity) {
            SelectedOwnedIdentitySingleton.getInstance().removeListener(this.ownedIdentityInfoChangeListener);
            this.isListeningOwnedIdentity = false;
        }
        if (this.isListeningInboundDownloadCache) {
            AttachmentProgressCache.getInstance().getInboundDownloadProgressLiveData().removeListener(this.inboundDownloadingProgressListener);
            this.isListeningInboundDownloadCache = false;
        }
        if (this.isListeningOwnedDownloadCache) {
            AttachmentProgressCache.getInstance().getOwnedDownloadProgressLiveData().removeListener(this.ownedDownloadingProgressListener);
            this.isListeningOwnedDownloadCache = false;
        }
    }

    private void close() {
        this.clean();
        this.model.getViewerAttachmentsListLiveData().removeListener(this.attachmentsLiveDataListener);
        if (this.closeModalDelegate != null) {
            this.closeModalDelegate.run();
        }
    }

    private void save() {
        if (this.currentAttachment == null) {
            return;
        }
        AsyncTaskExecutor.submitTask(() -> {
            if (this.currentMessage.kind == MessageKind.INBOUND && this.currentMessage.getInboundMessage().isBoxed()) {
                return;
            }
            ViewControllerHelper.smartUIUpdate(() -> AttachmentUtils.save(this.currentAttachment));
        });
    }

    private void showSaveError() {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(ViewControllerHelper.getString("save_attachment_error_title"));
        alert.setContentText(ViewControllerHelper.getString("save_attachment_error_label"));
        alert.show();
    }

    private void updateHeader() {
        switch (this.currentMessage.kind) {
            case INBOUND: {
                InboundMessageGenerated.Interface inboundMessage = this.currentMessage.getInboundMessage();
                if (!this.senderRefId.isEmpty()) break;
                Id<ContactRef> senderId = inboundMessage.getSenderId();
                DbCache.getInstance().contactRefInfoMapLiveData.addListener(senderId, this.contactInfoChangeListener);
                this.senderRefId = Optional.of(senderId);
                break;
            }
            case OUTBOUND: 
            case OWNED: {
                if (this.isListeningOwnedIdentity) break;
                SelectedOwnedIdentitySingleton.getInstance().addListener(this.ownedIdentityInfoChangeListener);
                this.isListeningOwnedIdentity = true;
                break;
            }
        }
    }

    private void updateExpiration() {
        switch (this.currentMessage.getKind()) {
            case INBOUND: {
                InboundMessageGenerated.Interface inboundMessage = this.currentMessage.getInboundMessage();
                Optional<Id<InboundMessageEphemeralInfo>> ephemeralInfoOpt = inboundMessage.getInboundMessageEphemeralInfoId();
                this.ephemeralInfoView.setShowReadOnceStatus(!inboundMessage.isBoxed());
                if (ephemeralInfoOpt.isPresent()) {
                    this.model.getInboundMessageEphemeralInfoPerMessageId().addListener(ephemeralInfoOpt.get(), this.inboundMessageEphemeralInfoChangeListener);
                    break;
                }
                ViewControllerHelper.smartUIUpdate(() -> this.ephemeralInfoView.updateEphemeralInfo(System.currentTimeMillis(), Optional.empty()));
                break;
            }
            case OUTBOUND: {
                Optional<Id<OutboundMessageEphemeralInfo>> ephemeralInfoOpt = this.currentMessage.getOutboundMessage().getOutboundMessageEphemeralInfoId();
                this.ephemeralInfoView.setShowReadOnceStatus(true);
                if (ephemeralInfoOpt.isPresent()) {
                    this.model.getOutboundMessageEphemeralInfoPerMessageId().addListener(ephemeralInfoOpt.get(), this.outboundMessageEphemeralInfoChangeListener);
                    break;
                }
                ViewControllerHelper.smartUIUpdate(() -> this.ephemeralInfoView.updateEphemeralInfo(System.currentTimeMillis(), Optional.empty()));
                break;
            }
            case OWNED: {
                Optional<Id<OwnedMessageEphemeralInfo>> ephemeralInfoOpt = this.currentMessage.getOwnedMessage().getOwnedMessageEphemeralInfoId();
                this.ephemeralInfoView.setShowReadOnceStatus(true);
                if (ephemeralInfoOpt.isPresent()) {
                    this.model.getOwnedMessageEphemeralInfoPerMessageId().addListener(ephemeralInfoOpt.get(), this.ownedMessageEphemeralInfoChangeListener);
                    break;
                }
                ViewControllerHelper.smartUIUpdate(() -> this.ephemeralInfoView.updateEphemeralInfo(System.currentTimeMillis(), Optional.empty()));
                break;
            }
        }
    }

    private void updateImage(AbstractAttachmentGenerated<?> attachment) {
        if (ImageUtils.isSupportedImage(attachment.getMimeType())) {
            this.loadingAttachmentView.updateViewToProgress();
            AsyncTaskExecutor.submitTask(() -> {
                Fyle fyle = DbManager.getInstance().getFyleDao().get(attachment.getFyleId());
                if (fyle == null) {
                    AppLogger.w("PreviewAttachment::update fyle null for attachement id : " + String.valueOf(attachment.getItemId()));
                    return;
                }
                if (fyle.getSha256().isEmpty()) {
                    return;
                }
                ImageHelper.ImageData imageData = new ImageHelper.ImageData((Id<Fyle>)fyle.getItemId(), fyle.getFilePath(), fyle.getSha256().get(), attachment.getMimeType());
                this.IMAGE_VIEWER_LRU_CACHE.compute(imageData, result -> {
                    Result resultRemix;
                    if (result.isSuccess()) {
                        ImageHelper.ImageInfo info = (ImageHelper.ImageInfo)result.getSuccess();
                        resultRemix = Result.success(new ImageConfiguration(info.image(), info.orientation(), false));
                    } else {
                        try {
                            resultRemix = Result.failure((Throwable)result.getFailureOrThrow());
                        }
                        catch (Throwable e) {
                            resultRemix = Result.failure(e);
                        }
                    }
                    this.loadingAttachmentView.displayOnImageResult(resultRemix);
                }, ImageHelper::computeLargeImage, Optional.empty());
            });
        } else if (ImageUtils.isImage(attachment.getMimeType()) && !ImageUtils.isSupportedImage(attachment.getMimeType())) {
            this.loadingAttachmentView.showLabel(ViewControllerHelper.getString("unsupported_mimetype_image"));
        } else {
            this.loadingAttachmentView.showLabel(ViewControllerHelper.getString("unsupported_mimetype_attachment"));
        }
    }

    public void update(MessageItem message, AttachmentInfos attachment) {
        if (!DbManager.isOnUIThread()) {
            AppLogger.t("AttachmentsViewerModelController:update: should be called on ui thread");
        }
        if (this.currentAttachment != null && !this.currentAttachment.getItemId().equals(attachment.getItemId())) {
            this.clean();
        }
        this.currentAttachment = attachment;
        this.currentMessage = message;
        if (!attachment.getMessageId().equals(this.currentMessage.getItemId().itemId())) {
            this.loadingAttachmentView.showLabel("Internal error");
            return;
        }
        AsyncTaskExecutor.submitTask(() -> {
            if (message.getKind() == MessageKind.INBOUND && message.getInboundMessage().isBoxed()) {
                this.save_button.setDisable(true);
            } else {
                this.save_button.setDisable(false);
            }
            this.updateHeader();
            this.updateExpiration();
            ViewControllerHelper.smartUIUpdate(() -> {
                LocalDateTime time = message.getLocalDateTime();
                String date = DateUtils.formatRelativeDateAndTime(time);
                this.viewModel.setDate(date);
                this.viewModel.setImageName(attachment.getFilename());
                block0 : switch (message.getKind()) {
                    case INBOUND: {
                        if (message.getInboundMessage().isBoxed()) {
                            this.loadingAttachmentView.showLabel(ViewControllerHelper.getString("attachment_hidden_label"));
                            return;
                        }
                        InboundAttachment inboundAttachment = attachment.getInboundAttachment();
                        this.viewModel.downloadableProperty().set(inboundAttachment.getStatus() == ReceivedAttachmentGenerated.Status.DOWNLOADABLE);
                        this.viewModel.completeProperty().set(inboundAttachment.getStatus() == ReceivedAttachmentGenerated.Status.COMPLETE);
                        switch (inboundAttachment.getStatus()) {
                            case DOWNLOADABLE: {
                                this.loadingAttachmentView.showButton();
                                break;
                            }
                            case DOWNLOADING: {
                                if (this.isListeningInboundDownloadCache) break;
                                AttachmentProgressCache.getInstance().getInboundDownloadProgressLiveData().addListener(this.inboundDownloadingProgressListener);
                                this.isListeningInboundDownloadCache = true;
                                break;
                            }
                            case COMPLETE: {
                                this.updateImage(inboundAttachment);
                                break;
                            }
                            case DOWNLOAD_FAILED: {
                                this.loadingAttachmentView.showLabel("download_failed");
                            }
                        }
                        break;
                    }
                    case OUTBOUND: {
                        OutboundAttachment outboundAttachment = attachment.getOutboundAttachment();
                        switch (outboundAttachment.getStatus()) {
                            case COPYING: {
                                this.viewModel.completeProperty().set(false);
                                break block0;
                            }
                            case UNPROCESSED: 
                            case NO_CONTACT_RECIPIENTS: 
                            case DRAFT_READY: 
                            case UPLOADING: 
                            case SENT: 
                            case DELIVERED: 
                            case READ: 
                            case CANCELLED: {
                                this.updateImage(outboundAttachment);
                                this.viewModel.completeProperty().set(true);
                                break block0;
                            }
                            case FAILED: {
                                this.loadingAttachmentView.showLabel("Internal error");
                                this.viewModel.completeProperty().set(false);
                                break block0;
                            }
                        }
                        throw new IllegalStateException("Unexpected value: " + String.valueOf(outboundAttachment.getStatus()));
                    }
                    case OWNED: {
                        OwnedAttachment ownedAttachment = attachment.getOwnedAttachment();
                        this.viewModel.downloadableProperty().set(ownedAttachment.getStatus() == ReceivedAttachmentGenerated.Status.DOWNLOADABLE);
                        this.viewModel.completeProperty().set(ownedAttachment.getStatus() == ReceivedAttachmentGenerated.Status.COMPLETE);
                        switch (ownedAttachment.getStatus()) {
                            case DOWNLOADABLE: {
                                this.loadingAttachmentView.showButton();
                                break;
                            }
                            case DOWNLOADING: {
                                if (this.isListeningOwnedDownloadCache) break;
                                AttachmentProgressCache.getInstance().getOwnedDownloadProgressLiveData().addListener(this.ownedDownloadingProgressListener);
                                this.isListeningOwnedDownloadCache = true;
                                break;
                            }
                            case COMPLETE: {
                                this.updateImage(ownedAttachment);
                                break;
                            }
                            case DOWNLOAD_FAILED: {
                                this.loadingAttachmentView.showLabel("download_failed");
                            }
                        }
                        break;
                    }
                    case SYSTEM: {
                        this.loadingAttachmentView.showLabel("Internal error");
                    }
                }
            });
        });
        this.updateLeftRightButtons();
    }

    private void ownedIdentityInfoChangeListener(Optional<OwnedIdentityInfo> newValue, Optional<OwnedIdentityInfo> oldValue) {
        if (newValue.equals(oldValue)) {
            return;
        }
        if (newValue.isEmpty()) {
            ViewControllerHelper.smartUIUpdate(() -> this.viewModel.setErrorType(ErrorType.OWNED_INFORMATION_ERROR));
            return;
        }
        OwnedIdentityInfo ownedIdentityInfo = newValue.get();
        ViewControllerHelper.smartUIUpdate(() -> {
            this.viewModel.setSenderName(ownedIdentityInfo.detailsInfo().getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST));
            BubbleUtils.setBubbleData(ownedIdentityInfo, this.bubble);
        });
    }

    private void contactInfoChangeListener(ContactInfoLiveData.ContactInfoState newValue, ContactInfoLiveData.ContactInfoState oldValue) {
        if (newValue.equals(oldValue)) {
            return;
        }
        if (this.currentAttachment == null) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> {
            ContactInfoLiveData.ContactInfoState contactInfoState = newValue;
            Objects.requireNonNull(contactInfoState);
            ContactInfoLiveData.ContactInfoState selector0$temp = contactInfoState;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ContactInfoLiveData.ContactInfoState.Computing.class, ContactInfoLiveData.ContactInfoState.Deleted.class, ContactInfoLiveData.ContactInfoState.Present.class}, (Object)selector0$temp, index$1)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ContactInfoLiveData.ContactInfoState.Computing computing = (ContactInfoLiveData.ContactInfoState.Computing)selector0$temp;
                    BubbleUtils.resetBubbleData(this.bubble);
                    this.viewModel.setSenderName(null);
                    this.viewModel.setErrorType(ErrorType.CONTACT_INFORMATION_ERROR);
                    break;
                }
                case 1: {
                    ContactInfoLiveData.ContactInfoState.Deleted deleted = (ContactInfoLiveData.ContactInfoState.Deleted)selector0$temp;
                    BubbleUtils.resetBubbleData(this.bubble);
                    this.viewModel.setErrorType(ErrorType.NONE);
                    this.viewModel.setSenderName(ViewControllerHelper.getString("deleted_contact"));
                    break;
                }
                case 2: {
                    ContactInfoLiveData.ContactInfoState.Present present = (ContactInfoLiveData.ContactInfoState.Present)selector0$temp;
                    ContactInfo contactInfo = present.info();
                    this.viewModel.setSenderName(contactInfo.detailsInfo().getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST));
                    BubbleUtils.setBubbleData(contactInfo, this.bubble);
                }
            }
        });
    }

    private void updateLeftRightButtons() {
        AsyncTaskExecutor.submitTask(() -> {
            Optional<AttachmentInfos> previousAttachment = this.getPreviousAttachment();
            ViewControllerHelper.smartUIUpdate(() -> this.left_button.setVisible(previousAttachment.isPresent()));
            Optional<AttachmentInfos> nextAttachment = this.getNextAttachment();
            ViewControllerHelper.smartUIUpdate(() -> this.right_button.setVisible(nextAttachment.isPresent()));
        });
    }

    private void attachmentListChangeListener(List<AttachmentInfos> newValue, List<AttachmentInfos> oldValue) {
        ViewControllerHelper.smartUIUpdate(this::updateLeftRightButtons);
        if (this.currentAttachment == null) {
            return;
        }
        if (newValue == null) {
            this.close();
            return;
        }
        AttachmentInfos attachment = null;
        for (AttachmentInfos a : newValue) {
            if (!a.getItemId().equals(this.currentAttachment.getItemId())) continue;
            attachment = a;
            break;
        }
        if (attachment == null) {
            this.close();
            return;
        }
        if (attachment.areContentTheSame(this.currentAttachment)) {
            return;
        }
        MessageItem message = attachment.getMessageItem();
        AttachmentInfos finalAttachment = attachment;
        ViewControllerHelper.smartUIUpdate(() -> this.update(message, finalAttachment));
    }

    private <Info extends AbstractMessageEphemeralInfoGenerated<?>> void messageEphemeralInfoChangeListener(Optional<Info> newValue, Optional<Info> oldValue) {
        if (DiffUtils.areContentTheSame(newValue, oldValue)) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> this.ephemeralInfoView.updateEphemeralInfo(System.currentTimeMillis(), newValue));
    }

    private Optional<AttachmentInfos> getPreviousAttachment() {
        List<AttachmentInfos> attachments = this.model.getViewerAttachmentsListLiveData().getValue();
        int indexOf = attachments.indexOf(this.currentAttachment);
        if (indexOf == 0) {
            return Optional.empty();
        }
        return Optional.of(attachments.get(indexOf - 1));
    }

    private Optional<AttachmentInfos> getNextAttachment() {
        List<AttachmentInfos> attachments = this.model.getViewerAttachmentsListLiveData().getValue();
        int indexOf = attachments.indexOf(this.currentAttachment);
        if (indexOf != attachments.size() - 1) {
            return Optional.of(attachments.get(indexOf + 1));
        }
        return Optional.empty();
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    private void onLeftButtonClicked(Event event) {
        AsyncTaskExecutor.submitTask(() -> {
            Optional<AttachmentInfos> previousAttachmentOptional = this.getPreviousAttachment();
            if (previousAttachmentOptional.isEmpty()) {
                return;
            }
            AttachmentInfos previousAttachment = previousAttachmentOptional.get();
            MessageItem message = previousAttachment.getMessageItem();
            ViewControllerHelper.smartUIUpdate(() -> this.update(message, previousAttachment));
        });
    }

    private void onRightButtonClicked(Event event) {
        AsyncTaskExecutor.submitTask(() -> {
            Optional<AttachmentInfos> nextAttachmentOptional = this.getNextAttachment();
            if (nextAttachmentOptional.isEmpty()) {
                return;
            }
            AttachmentInfos nextAttachment = nextAttachmentOptional.get();
            MessageItem message = nextAttachment.getMessageItem();
            ViewControllerHelper.smartUIUpdate(() -> this.update(message, nextAttachment));
        });
    }

    @Override
    public void onLayoutAttached() {
        super.onLayoutAttached();
        this.keyEventEventHandler = event -> {
            if (event.getCode() == KeyCode.LEFT || event.getCode() == KeyCode.J) {
                this.onLeftButtonClicked(event);
                event.consume();
            }
            if (event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.L) {
                this.onRightButtonClicked(event);
                event.consume();
            }
        };
        ViewControllerHelper.MAIN_STAGE.getScene().addEventFilter(KeyEvent.KEY_PRESSED, this.keyEventEventHandler);
    }

    @Override
    public void onLayoutDetached() {
        super.onLayoutDetached();
        ViewControllerHelper.MAIN_STAGE.getScene().removeEventFilter(KeyEvent.KEY_PRESSED, this.keyEventEventHandler);
    }

    private void inboundDownloadingProgressListener(Map<Id<InboundAttachment>, Float> newValue, Map<Id<InboundAttachment>, Float> oldValue) {
        if (this.currentAttachment == null) {
            return;
        }
        if (!this.currentAttachment.isInbound()) {
            return;
        }
        InboundAttachment inboundAttachment = this.currentAttachment.getInboundAttachment();
        Float progress = newValue.get(inboundAttachment.getItemId());
        if (progress == null) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> this.loadingAttachmentView.showProgression(progress.floatValue()));
    }

    private void ownedDownloadingProgressListener(Map<Id<OwnedAttachment>, Float> newValue, Map<Id<OwnedAttachment>, Float> oldValue) {
        if (this.currentAttachment == null) {
            return;
        }
        if (!this.currentAttachment.isOwned()) {
            return;
        }
        OwnedAttachment ownedAttachment = this.currentAttachment.getOwnedAttachment();
        Float progress = newValue.get(ownedAttachment.getItemId());
        if (progress == null) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> this.loadingAttachmentView.showProgression(progress.floatValue()));
    }

    public record ImageConfiguration(Image image, Optional<ImageUtils.Orientation> orientation, boolean isDefault) implements AttachmentConfiguration
    {
    }

    public static sealed interface AttachmentConfiguration
    permits ImageConfiguration {
    }
}

