/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.modal;

import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.framework.view_controller.CloseGuard;
import io.olvid.windows.messenger.fx.helpers.SizeObserver;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.logger.AppLogger;
import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;

public abstract class BaseModalController
extends BaseViewController {
    private ModalConfiguration.ModalSize size = ModalConfiguration.ModalSize.SMALL;
    protected Runnable closeModalDelegate;

    public void setSize(ModalConfiguration.ModalSize size) {
        this.size = size;
    }

    public ModalConfiguration.ModalSize getSize() {
        return this.size;
    }

    public void setCloseModalDelegate(Runnable delegate) {
        this.closeModalDelegate = delegate;
    }

    public Runnable getCloseModalDelegate() {
        return this.closeModalDelegate;
    }

    protected CloseGuard getActiveCloseGuard() {
        return null;
    }

    protected SimpleDoubleProperty getModalHeight() {
        return SizeObserver.getModalHeight(this.size);
    }

    protected SimpleDoubleProperty getModalWidth() {
        return SizeObserver.getModalWidth(this.size);
    }

    protected void attemptClose() {
        this.closeModalDelegate.run();
    }

    protected Optional<EventHandler<KeyEvent>> getCloseKeyEventHandler() {
        return Optional.empty();
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
    }

    @Override
    public void onLayoutAttached() {
        AppLogger.t("BaseModalController::onAttached CLAZZZZZZZZZZZ : " + this.getClass().getSimpleName());
    }

    @Override
    public void onLayoutDetached() {
        AppLogger.t("BaseModalController::onDetached CLAZZZZZZZZZZZ : " + this.getClass().getSimpleName());
    }
}

