/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.textflow;

import io.olvid.windows.messenger.fx.misc.EmojiHelper;
import io.olvid.windows.messenger.fx.misc.textflow.EmojiTextFlow;
import java.text.BreakIterator;
import java.util.Map;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.geometry.Point2D;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Path;
import javafx.scene.text.HitInfo;
import javafx.scene.text.Text;

public class SelectableTextFlow
extends EmojiTextFlow {
    private final ReadOnlyObjectWrapper<IndexRange> selection = new ReadOnlyObjectWrapper((Object)this, "selection", (Object)new IndexRange(0, 0));
    private final ReadOnlyIntegerWrapper anchor = new ReadOnlyIntegerWrapper((Object)this, "anchor", 0);
    private final ReadOnlyIntegerWrapper caretPosition = new ReadOnlyIntegerWrapper((Object)this, "caretPosition", 0);
    private final ReadOnlyStringWrapper selectedText = new ReadOnlyStringWrapper((Object)this, "selectedText");
    private final Group selectionHighlightGroup = new Group();
    private boolean isSelectionDirty = true;
    private boolean shiftDown = false;
    private boolean deferClick = false;
    private BreakIterator wordIterator;

    public final IndexRange getSelection() {
        return (IndexRange)this.selection.getValue();
    }

    public final int getAnchor() {
        return this.anchor.get();
    }

    public final int getCaretPosition() {
        return this.caretPosition.get();
    }

    public final String getSelectedText() {
        return this.selectedText.get();
    }

    public SelectableTextFlow() {
        this.selectionHighlightGroup.setId("selectionHighlightGroup");
        this.selectionHighlightGroup.setManaged(false);
        this.selectionHighlightGroup.setVisible(false);
        this.getChildren().add((Object)this.selectionHighlightGroup);
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            this.mousePressed((MouseEvent)event);
            event.consume();
        });
        this.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> {
            this.mouseReleased((MouseEvent)event);
            event.consume();
        });
        this.addEventHandler(MouseEvent.MOUSE_DRAGGED, event -> {
            this.mouseDragged((MouseEvent)event);
            event.consume();
        });
        this.selection.addListener((ob, o, n) -> {
            this.updateSelectedText();
            this.requestLayout();
        });
        this.addEventHandler(KeyEvent.KEY_PRESSED, evt -> {
            if (evt.getCode() == KeyCode.COPY || evt.isShortcutDown() && evt.getCode() == KeyCode.C) {
                this.copy();
            }
        });
        this.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.selectRange(0, 0);
            }
        });
    }

    @Override
    public void clear() {
        this.getChildren().subList(1, this.getChildren().size()).clear();
    }

    public void copy() {
        String selectedText = this.getSelectedText();
        if (!selectedText.isEmpty()) {
            ClipboardContent content = new ClipboardContent();
            content.putString(selectedText);
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
    }

    protected void layoutSelection(Group group, int start, int end) {
        int index = 0;
        int max = this.getChildren().size();
        for (int i = 0; i < max; ++i) {
            int paragraphLength;
            Node paragraphNode = (Node)this.getChildren().get(i);
            int paragraphStart = index;
            if (paragraphNode instanceof Text) {
                Text textNode = (Text)paragraphNode;
                paragraphLength = textNode.getText().length();
            } else {
                if (!(paragraphNode instanceof EmojiHelper.EmojiView)) continue;
                paragraphLength = 1;
            }
            int paragraphEnd = index + paragraphLength;
            index += paragraphLength;
            if (end < paragraphStart || start > paragraphEnd) continue;
            int rangeStart = Math.max(start, paragraphStart);
            int rangeEnd = Math.min(end, paragraphEnd);
            if (paragraphNode instanceof Text) {
                Text textNode = (Text)paragraphNode;
                textNode.setSelectionStart(rangeStart);
                textNode.setSelectionEnd(rangeEnd);
            }
            Path path = new Path();
            path.getStyleClass().add((Object)"main-selection");
            path.setManaged(false);
            path.setStroke(null);
            Object[] selectionShape = this.rangeShape(rangeStart, rangeEnd);
            if (selectionShape != null) {
                path.getElements().addAll(selectionShape);
            }
            group.getChildren().add((Object)path);
            group.setVisible(true);
        }
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (this.isSelectionDirty) {
            IndexRange selection = this.getSelection();
            this.selectionHighlightGroup.getChildren().clear();
            int selectionStart = selection.getStart();
            int selectionEnd = selection.getEnd();
            this.layoutSelection(this.selectionHighlightGroup, selectionStart, selectionEnd);
            this.isSelectionDirty = false;
        }
    }

    public HitInfo getIndex(double x, double y) {
        Point2D p = new Point2D(x, y);
        return this.hitTest(p);
    }

    public void selectPositionCaret(int pos) {
        this.selectRange(this.getAnchor(), SelectableTextFlow.clamp(0, pos, this.getLength()));
    }

    public void selectRange(int anchor, int caretPosition) {
        caretPosition = SelectableTextFlow.clamp(0, caretPosition, this.getLength());
        anchor = SelectableTextFlow.clamp(0, anchor, this.getLength());
        this.doSelectRange(anchor, caretPosition);
    }

    private void doSelectRange(int anchor, int caretPosition) {
        this.caretPosition.set(SelectableTextFlow.clamp(0, caretPosition, this.getLength()));
        this.anchor.set(SelectableTextFlow.clamp(0, anchor, this.getLength()));
        this.selection.set((Object)IndexRange.normalize((int)this.getAnchor(), (int)this.getCaretPosition()));
        this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_START);
        this.isSelectionDirty = true;
    }

    private void updateSelectedText() {
        String txt = this.getText();
        IndexRange sel = (IndexRange)this.selection.get();
        if (txt == null || sel == null) {
            this.selectedText.set("");
        } else {
            int start = sel.getStart();
            int end = sel.getEnd();
            this.selectedText.set(this.getText(start, end));
        }
    }

    public void positionCaret(int pos) {
        int p = SelectableTextFlow.clamp(0, pos, this.getLength());
        this.selectRange(p, p);
    }

    public void positionCaret(HitInfo hit, boolean select) {
        this.positionCaret(hit.getInsertionIndex(), hit.isLeading(), select);
    }

    private void positionCaret(int pos, boolean leading, boolean select) {
        boolean isNewLine;
        boolean bl = isNewLine = pos > 0 && pos <= this.getLength() && this.getText().codePointAt(pos - 1) == 10;
        if (!leading && isNewLine) {
            --pos;
        }
        if (select) {
            this.selectPositionCaret(pos);
        } else {
            this.positionCaret(pos);
        }
    }

    public void selectCurrentWord() {
        int caretPosition = this.getCaretPosition();
        int cur = 0;
        Text textNode = null;
        for (Node children : this.getChildren()) {
            if (children instanceof Text) {
                Text text = (Text)children;
                String textString = text.getText();
                int len = textString.length();
                if (cur + len <= caretPosition) {
                    cur += len;
                    continue;
                }
                textNode = text;
                break;
            }
            if (!(children instanceof EmojiHelper.EmojiView)) continue;
            if (cur + 1 <= caretPosition) {
                ++cur;
                continue;
            }
            this.doSelectRange(cur, cur + 1);
            return;
        }
        if (textNode == null) {
            return;
        }
        String text = textNode.getText();
        int relativeCaret = caretPosition - cur;
        if (this.wordIterator == null) {
            this.wordIterator = BreakIterator.getWordInstance();
        }
        this.wordIterator.setText(text);
        int start = this.wordIterator.preceding(SelectableTextFlow.clamp(0, relativeCaret, text.length()));
        while (start != -1 && !SelectableTextFlow.isLetterOrDigit(text, start)) {
            start = this.wordIterator.preceding(SelectableTextFlow.clamp(0, start, text.length()));
        }
        int end = this.wordIterator.following(SelectableTextFlow.clamp(0, start, text.length()));
        this.doSelectRange(cur + start, cur + end);
    }

    public void end() {
        int textLength = this.getLength();
        if (textLength > 0) {
            this.selectRange(textLength, textLength);
        }
    }

    private static boolean isLetterOrDigit(String text, int ix) {
        if (ix < 0) {
            return false;
        }
        if (ix >= text.length()) {
            return false;
        }
        int c = Character.codePointAt(text, ix);
        return Character.isLetterOrDigit(c);
    }

    private boolean isMouseEnable() {
        return !this.isDisabled() && !this.isMouseTransparent();
    }

    public void mousePressed(MouseEvent e) {
        if (this.isMouseEnable()) {
            if (e.getButton() == MouseButton.PRIMARY && !e.isMiddleButtonDown() && !e.isSecondaryButtonDown()) {
                HitInfo hit = this.getIndex(e.getX(), e.getY());
                int i = hit.getInsertionIndex();
                int anchor = this.getAnchor();
                int caretPosition = this.getCaretPosition();
                if (e.getClickCount() < 2 && (e.isSynthesized() || anchor != caretPosition && (i > anchor && i < caretPosition || i < anchor && i > caretPosition))) {
                    this.deferClick = true;
                } else if (!(e.isControlDown() || e.isAltDown() || e.isShiftDown() || e.isMetaDown() || e.isShortcutDown())) {
                    switch (e.getClickCount()) {
                        case 1: {
                            this.positionCaret(hit, false);
                            break;
                        }
                        case 2: {
                            this.mouseDoubleClick();
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                } else if (!(!e.isShiftDown() || e.isControlDown() || e.isAltDown() || e.isMetaDown() || e.isShortcutDown() || e.getClickCount() != 1)) {
                    this.shiftDown = true;
                    this.positionCaret(hit, true);
                }
            }
            this.requestFocus();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isMouseEnable() && !e.isSynthesized()) {
            if (!(e.getButton() != MouseButton.PRIMARY || e.isMiddleButtonDown() || e.isSecondaryButtonDown() || e.isControlDown() || e.isAltDown() || e.isShiftDown() || e.isMetaDown())) {
                HitInfo index = this.getIndex(e.getX(), e.getY());
                this.positionCaret(index, true);
            }
            this.requestFocus();
        }
        this.deferClick = false;
    }

    public void mouseReleased(MouseEvent e) {
        if (this.isMouseEnable()) {
            if (this.deferClick) {
                this.deferClick = false;
                this.positionCaret(this.getIndex(e.getX(), e.getY()), this.shiftDown);
                this.shiftDown = false;
            }
            this.requestFocus();
        }
    }

    protected void mouseDoubleClick() {
        this.selectCurrentWord();
        this.requestFocus();
    }

    public static int clamp(int min, int value, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }
}

