/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.textflow;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.SearchableTextArea;
import io.olvid.windows.messenger.fx.misc.textflow.SelectableTextFlow;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.StringUtils;
import java.util.List;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;

public class SearchableTextFlow
extends SelectableTextFlow
implements SearchableTextArea {
    private final Group searchHighlightGroup = new Group();
    private StringProperty searchText = null;
    private List<StringUtils.HighlightRange> ranges = null;
    private boolean disableSearch = false;
    private boolean isSearchDirty = true;

    public SearchableTextFlow() {
        this.searchHighlightGroup.setId("searchHighlightGroup");
        this.searchHighlightGroup.setManaged(false);
        this.searchHighlightGroup.setVisible(false);
        this.getChildren().add((Object)this.searchHighlightGroup);
    }

    private synchronized void highlight() {
        if (this.disableSearch) {
            return;
        }
        try {
            ViewControllerHelper.checkUIThread();
            if (this.searchText == null || this.searchText.getValue() == null || this.searchText.getValue().isEmpty()) {
                this.ranges = null;
                this.isSearchDirty = true;
                return;
            }
            String text = this.getText();
            List<StringUtils.HighlightRange> newRanges = StringUtils.highlightString(text, this.searchText.getValue());
            if (newRanges.equals(this.ranges)) {
                return;
            }
            this.ranges = newRanges;
            this.isSearchDirty = true;
        }
        finally {
            this.requestLayout();
        }
    }

    @Override
    public void clear() {
        this.getChildren().subList(2, this.getChildren().size()).clear();
    }

    @Override
    public void replaceText(String s) {
        super.replaceText(s);
        this.highlight();
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        if (this.isSearchDirty) {
            this.searchHighlightGroup.getChildren().clear();
            List<StringUtils.HighlightRange> ranges = this.ranges;
            if (ranges != null && !ranges.isEmpty()) {
                for (StringUtils.HighlightRange range : ranges) {
                    this.layoutSelection(this.searchHighlightGroup, range.start(), range.end());
                }
            }
            this.isSearchDirty = false;
        }
    }

    @Override
    public void configure(List<Node> siblings) {
        siblings.add((Node)this);
    }

    @Override
    public void bindSearchProperty(StringProperty search) {
        this.searchText = search;
        this.searchText.addListener((observable, oldValue, newValue) -> this.highlight());
    }

    @Override
    public void setDisableSearch(boolean disableSearch) {
        this.disableSearch = disableSearch;
    }

    @Override
    public void hide() {
        ViewControllerHelper.hideNode((Node)this);
    }

    @Override
    public void show() {
        ViewControllerHelper.showNode((Node)this);
    }

    @Override
    public void bindMaxWidthProperty(DoubleExpression maxWidthBinding) {
        this.maxWidthProperty().bind((ObservableValue)maxWidthBinding);
    }

    @Override
    public void setStyleClass(String styleClass) {
        this.getStyleClass().setAll((Object[])new String[]{styleClass});
    }

    @Override
    public void setEditable(boolean editable) {
        if (editable) {
            AppLogger.e("Editable text flow not implemented");
        }
    }
}

