/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.textflow;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.EmojiHelper;
import io.olvid.windows.messenger.fx.misc.textflow.EmojiTextFlow;
import io.olvid.windows.messenger.misc.Watches;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.text.Text;
import org.reactfx.util.Either;

public class LineLimitedTextFlow
extends EmojiTextFlow {
    private final LinkedList<Either<String, CharSequence>> truncated = new LinkedList();
    private final AtomicBoolean hasOtherLines = new AtomicBoolean(false);
    private final AtomicBoolean hasEllipsis = new AtomicBoolean(false);
    private final AtomicBoolean isUpdating = new AtomicBoolean(false);
    private static final String ELLIPSIS = "\u2026";
    private final Node ellipsisNode = this.makeNode((Either<String, CharSequence>)Either.left((Object)"\u2026"));
    private static final int initialSegmentsSize = 32;
    private static Double lineHeightCache = null;
    private static final Pattern spacePattern = Pattern.compile("\\r?\\n|\\r");

    public LineLimitedTextFlow() {
        this.maxWidthProperty().addListener((obv, oldValue, newValue) -> this.adjustHeight());
        this.heightProperty().addListener((obv, oldValue, newValue) -> this.adjustHeight());
    }

    @Override
    public void clear() {
        super.clear();
        this.truncated.clear();
        this.hasEllipsis.set(false);
        this.hasOtherLines.set(false);
    }

    @Override
    protected List<Either<String, CharSequence>> makeSegments(String str) {
        ArrayList<Either<String, CharSequence>> segments = new ArrayList<Either<String, CharSequence>>();
        EmojiHelper.split(str, text -> {
            int len = text.length();
            for (int cur = 0; cur < len; ++cur) {
                String word = text.substring(cur, cur + 1);
                Either seg = Either.left((Object)word);
                segments.add(seg);
            }
        }, emoji -> {
            Either seg = Either.right((Object)emoji);
            segments.add(seg);
        });
        return segments;
    }

    @Override
    public void replaceText(String text) {
        Matcher matcher;
        if (this.getText().equals(text)) {
            return;
        }
        this.clear();
        String limitedText = text;
        if (limitedText != null && (matcher = spacePattern.matcher(limitedText)).find()) {
            limitedText = limitedText.substring(0, matcher.start());
            this.hasOtherLines.set(true);
        }
        List<Either<String, CharSequence>> segments = this.makeSegments(limitedText);
        this.truncated.addAll(segments);
        int size = this.truncated.size();
        for (int i = 0; i < Math.min(size, 32); ++i) {
            this.addLast(this.truncated.poll());
        }
        if (!this.truncated.isEmpty() || this.hasOtherLines.get()) {
            this.addEllipsis();
            this.adjustHeight();
        }
    }

    private void addEllipsis() {
        if (this.hasEllipsis.get()) {
            return;
        }
        this.getChildren().add((Object)this.ellipsisNode);
        this.hasEllipsis.set(true);
    }

    private void removeEllipsis() {
        if (!this.hasEllipsis.get() || this.hasOtherLines.get()) {
            return;
        }
        if (this.getLength() == 0) {
            return;
        }
        this.getChildren().removeLast();
        this.hasEllipsis.set(false);
    }

    private Either<String, CharSequence> getLast() {
        ObservableList children = this.getChildren();
        Node last = this.hasEllipsis.get() ? (Node)children.get(children.size() - 2) : (Node)children.getLast();
        if (last instanceof Text) {
            Text text = (Text)last;
            return Either.left((Object)text.getText());
        }
        if (last instanceof EmojiHelper.EmojiView) {
            EmojiHelper.EmojiView emojiView = (EmojiHelper.EmojiView)last;
            return Either.right((Object)emojiView.getEmoji());
        }
        throw new IllegalStateException();
    }

    private void addLast(Either<String, CharSequence> seg) {
        ObservableList children = this.getChildren();
        Node node = this.makeNode(seg);
        if (this.hasEllipsis.get()) {
            children.add(children.size() - 1, (Object)node);
        } else {
            children.add((Object)node);
        }
    }

    private void removeLastChar() {
        ObservableList children = this.getChildren();
        if (this.hasEllipsis.get()) {
            children.remove(children.size() - 2);
        } else {
            children.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustHeight() {
        ViewControllerHelper.checkUIThread();
        if (this.getLength() == 0) {
            return;
        }
        if (this.isUpdating.get()) {
            return;
        }
        this.isUpdating.set(true);
        Watches.Watch watch = Watches.getInstance().start("LineLimitedTextFlow::adjustHeight");
        try {
            if (lineHeightCache == null) {
                lineHeightCache = this.computePrefHeight(-1.0);
            }
            double maxWidth = this.getMaxWidth() - 8.0;
            double height = this.computePrefHeight(maxWidth);
            if (this.hasEllipsis.get()) {
                while (height < 1.5 * lineHeightCache) {
                    if (this.truncated.isEmpty()) {
                        this.removeEllipsis();
                        break;
                    }
                    Either<String, CharSequence> s = this.truncated.poll();
                    if (s != null) {
                        this.addLast(s);
                    }
                    height = this.computePrefHeight(maxWidth);
                }
            }
            while (height > 1.5 * lineHeightCache) {
                int length = this.getLength();
                if (length == 0) {
                    break;
                }
                this.addEllipsis();
                Either<String, CharSequence> segments = this.getLast();
                this.truncated.addFirst(segments);
                this.removeLastChar();
                height = this.computePrefHeight(maxWidth);
            }
        }
        finally {
            this.isUpdating.set(false);
            watch.stop();
        }
    }
}

