/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.textflow;

import io.olvid.windows.messenger.fx.misc.EmojiHelper;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;
import javafx.scene.text.TextFlow;
import org.reactfx.util.Either;

public class EmojiTextFlow
extends TextFlow {
    private static final StyleablePropertyFactory<EmojiTextFlow> FACTORY = new StyleablePropertyFactory(TextFlow.getClassCssMetaData());
    private static final CssMetaData<EmojiTextFlow, Number> FONT_SIZE = FACTORY.createSizeCssMetaData("-fx-font-size", s -> s.fontSize, (Number)24);
    private final SimpleStyleableObjectProperty<Number> fontSize = new SimpleStyleableObjectProperty(FONT_SIZE, (Object)this, "font-size");

    public DoubleExpression fontSizeProperty() {
        ObservableValue map = this.fontSize.map(Number::doubleValue);
        return DoubleProperty.doubleExpression((ObservableValue)map);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    public void clear() {
        this.getChildren().clear();
    }

    protected List<Either<String, CharSequence>> makeSegments(String str) {
        ArrayList<Either<String, CharSequence>> segments = new ArrayList<Either<String, CharSequence>>();
        EmojiHelper.split(str, string -> segments.add(Either.left((Object)string)), emoji -> segments.add(Either.right((Object)emoji)));
        return segments;
    }

    protected Node makeNode(Either<String, CharSequence> segment) {
        if (segment.isLeft()) {
            String string = (String)segment.getLeft();
            Text text = new Text(string);
            text.getStyleClass().add((Object)"text");
            text.setBoundsType(TextBoundsType.VISUAL);
            text.selectionFillProperty().bind((ObservableValue)text.fillProperty());
            return text;
        }
        CharSequence emoji = (CharSequence)segment.getRight();
        EmojiHelper.EmojiView emojiView = new EmojiHelper.EmojiView(emoji.toString());
        emojiView.configure(this.fontSizeProperty());
        return emojiView;
    }

    public void replaceText(String s) {
        if (this.getText().equals(s)) {
            return;
        }
        this.clear();
        List<Either<String, CharSequence>> segments = this.makeSegments(s);
        for (Either<String, CharSequence> segment : segments) {
            Node node = this.makeNode(segment);
            this.getChildren().add((Object)node);
        }
    }

    public int getLength() {
        int len = 0;
        for (Node child : this.getChildren()) {
            if (child instanceof Text) {
                Text text = (Text)child;
                len += text.getText().length();
                continue;
            }
            if (!(child instanceof EmojiHelper.EmojiView)) continue;
            ++len;
        }
        return len;
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (Node child : this.getChildren()) {
            if (child instanceof Text) {
                Text text = (Text)child;
                sb.append(text.getText());
                continue;
            }
            if (!(child instanceof EmojiHelper.EmojiView)) continue;
            EmojiHelper.EmojiView emojiView = (EmojiHelper.EmojiView)child;
            sb.append(emojiView.getEmoji());
        }
        return sb.toString();
    }

    public String getText(int begin, int end) {
        StringBuilder stringBuilder = new StringBuilder();
        int cur = 0;
        for (Node node : this.getChildren()) {
            if (node instanceof Text) {
                Text text = (Text)node;
                String textString = text.getText();
                int len = textString.length();
                if (cur + len <= begin) {
                    cur += len;
                    continue;
                }
                if (cur >= end) break;
                stringBuilder.append(textString, Math.max(0, begin - cur), Math.min(len, end - cur));
                cur += len;
                continue;
            }
            if (!(node instanceof EmojiHelper.EmojiView)) continue;
            if (cur + 1 <= begin) {
                ++cur;
                continue;
            }
            if (cur >= end) break;
            stringBuilder.append(((EmojiHelper.EmojiView)node).getEmoji());
            ++cur;
        }
        return stringBuilder.toString();
    }
}

