/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx.utils;

import io.olvid.windows.messenger.fx.misc.richtextfx.style.ParagraphStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.SegmentStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.ActionableArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.EditableArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import io.olvid.windows.messenger.misc.StringUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.MultiChangeBuilder;
import org.fxmisc.richtext.model.GenericEditableStyledDocument;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TwoDimensional;

public interface ToggleableArea
extends EditableArea,
ActionableArea {
    private StyleDetection all() {
        if (this.getConfiguration().processDelimiter() == RichStyledConfiguration.DelimiterProcessing.TOGGLEABLE) {
            return StyleDetection.ALL;
        }
        return StyleDetection.ALL_INFO;
    }

    private StyleDetection none() {
        if (this.getConfiguration().processDelimiter() == RichStyledConfiguration.DelimiterProcessing.TOGGLEABLE) {
            return StyleDetection.NONE;
        }
        return StyleDetection.NONE_INFO;
    }

    default public StyleDetection detectStyle(IndexRange range, SegmentStyle.Style style) {
        TwoDimensional.Position startPosition = this.offsetToPosition(range.getStart(), TwoDimensional.Bias.Backward);
        TwoDimensional.Position endPosition = this.offsetToPosition(range.getEnd(), TwoDimensional.Bias.Forward);
        int startParagraph = startPosition.getMajor();
        int endParagraph = endPosition.getMajor();
        for (int p = startParagraph; p <= endParagraph; ++p) {
            if (!((ParagraphStyle)this.getParagraph(p).getParagraphStyle()).isCode()) continue;
            return StyleDetection.INVALID;
        }
        if (range.getLength() == 0) {
            SegmentStyle segmentStyle = (SegmentStyle)this.getTextStyleForInsertionAt(range.getStart());
            if (!(style instanceof SegmentStyle.Style.InlineCode) && segmentStyle.contains(SegmentStyle.Style.InlineCode.class)) {
                return StyleDetection.INVALID;
            }
            if (segmentStyle.styles().contains(style)) {
                return this.all();
            }
            return this.none();
        }
        String text = this.subDocument(range).getText();
        if (StringUtils.isEmpty(text)) {
            return StyleDetection.INVALID;
        }
        int noneCount = 0;
        int fullCount = 0;
        int level = 0;
        boolean onlyDelimiter = true;
        StyleSpans styleSpans = this.getStyleSpans(range);
        for (StyleSpan styleSpan : styleSpans) {
            SegmentStyle segmentStyle = (SegmentStyle)styleSpan.getStyle();
            if (!(style instanceof SegmentStyle.Style.InlineCode) && segmentStyle.contains(SegmentStyle.Style.InlineCode.class)) {
                return StyleDetection.INVALID;
            }
            if (segmentStyle.containsAny(Set.of(SegmentStyle.Style.BlockCode.class, SegmentStyle.Style.Delimiter.class))) {
                return StyleDetection.INVALID;
            }
            if (segmentStyle.contains(SegmentStyle.Style.OpenDelimiter.class)) {
                ++level;
            }
            if (segmentStyle.contains(SegmentStyle.Style.CloseDelimiter.class) && --level < 0) {
                return StyleDetection.INVALID;
            }
            if (segmentStyle.contains(style.getClass())) {
                ++fullCount;
            } else {
                ++noneCount;
            }
            if (segmentStyle.contains(SegmentStyle.Style.Delimiter.class)) continue;
            onlyDelimiter = false;
        }
        if (onlyDelimiter) {
            return StyleDetection.INVALID;
        }
        if (level != 0) {
            return StyleDetection.INVALID;
        }
        if (noneCount > 0 && fullCount > 0) {
            return StyleDetection.MIXED;
        }
        if (noneCount > 0) {
            return StyleDetection.NONE;
        }
        if (fullCount > 0) {
            return this.all();
        }
        return StyleDetection.NONE;
    }

    private int spaceCorrection(int position, boolean open) {
        int p;
        if (open) {
            for (p = position; p < this.getLength(); ++p) {
                String c = this.subDocument(p, p + 1).getText();
                if (StringUtils.isEmpty(c)) continue;
                return p;
            }
        } else {
            while (p > 0) {
                String c = this.subDocument(p - 1, p).getText();
                if (!StringUtils.isEmpty(c)) {
                    return p;
                }
                --p;
            }
        }
        return p;
    }

    default public void toggleStyle(SegmentStyle.Style style) {
        IndexRange selection = this.getSelection();
        if (selection.getLength() == 0) {
            return;
        }
        RichStyledConfiguration.DelimiterProcessing delimiterProcessing = this.getConfiguration().processDelimiter();
        StyleDetection styleDetection = this.detectStyle(selection, style);
        block0 : switch (delimiterProcessing) {
            case NONE: {
                this.logger().error("Try to toggle style when delimiter processing is NONE");
                break;
            }
            case DELETE_AND_RICH_REPLACE: {
                this.logger().error("Try to toggle style when delimiter processing is DELETE_AND_RICH_REPLACE");
                break;
            }
            case TOGGLEABLE: {
                switch (styleDetection.ordinal()) {
                    case 0: 
                    case 1: 
                    case 4: {
                        this.addStyle(selection.getStart(), selection.getEnd(), Optional.of(style), Optional.empty());
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.removeStyle(selection.getStart(), selection.getEnd(), Set.of(style.getClass()), false);
                        break;
                    }
                }
                this.clearLinkStyle();
                this.applyMarkdown();
                break;
            }
            case STYLE: {
                switch (styleDetection.ordinal()) {
                    case 0: 
                    case 4: {
                        TwoDimensional.Position startPosition = this.offsetToPosition(selection.getStart(), TwoDimensional.Bias.Backward);
                        TwoDimensional.Position endPosition = this.offsetToPosition(selection.getEnd(), TwoDimensional.Bias.Forward);
                        int startParagraph = startPosition.getMajor();
                        int endParagraph = endPosition.getMajor();
                        MultiChangeBuilder multiChange = this.createMultiChange();
                        for (int p = startParagraph; p <= endParagraph; ++p) {
                            int start = p == startParagraph ? selection.getStart() : this.getAbsolutePosition(p, 0);
                            int correctedStart = style instanceof SegmentStyle.Style.InlineCode ? start : this.spaceCorrection(start, true);
                            multiChange.insertText(correctedStart, style.delimiter(true));
                            int end = p == endParagraph ? selection.getEnd() : this.getAbsolutePosition(p, this.getParagraph(p).length());
                            int correctedEnd = style instanceof SegmentStyle.Style.InlineCode ? end : this.spaceCorrection(end, false);
                            multiChange.insertText(correctedEnd, style.delimiter(false));
                        }
                        if (multiChange.hasChanges()) {
                            multiChange.commit();
                        }
                        this.applyMarkdown();
                        break block0;
                    }
                }
            }
        }
    }

    default public StyleDetection detectStyle(IndexRange range, Class<? extends ParagraphStyle.BlockStyle> blockClass) {
        int startParagraphIndex = this.offsetToPosition(range.getStart(), TwoDimensional.Bias.Backward).getMajor();
        int endParagraphIndex = this.offsetToPosition(range.getEnd(), TwoDimensional.Bias.Forward).getMajor();
        int noneCount = 0;
        int lastCount = 0;
        for (int p = startParagraphIndex; p <= endParagraphIndex; ++p) {
            Paragraph paragraph = this.getParagraph(p);
            ParagraphStyle paragraphStyle = (ParagraphStyle)paragraph.getParagraphStyle();
            if (paragraphStyle.isCode() || paragraphStyle.hasCodeDelimiter) {
                return StyleDetection.INVALID;
            }
            List<ParagraphStyle.BlockStyle> blocks = paragraphStyle.blocks;
            if (blocks.isEmpty()) {
                ++noneCount;
                continue;
            }
            ParagraphStyle.BlockStyle lastBlock = blocks.get(blocks.size() - 1);
            if (blockClass.isInstance(lastBlock)) {
                ++lastCount;
                continue;
            }
            ++noneCount;
        }
        if (noneCount > 0 && lastCount > 0) {
            return StyleDetection.MIXED;
        }
        if (noneCount > 0) {
            return StyleDetection.NONE;
        }
        return this.all();
    }

    /*
     * Enabled aggressive block sorting
     */
    default public void toggleStyle(ParagraphStyle.BlockStyle style, boolean sameInstance) {
        IndexRange selection = this.getSelection();
        RichStyledConfiguration.DelimiterProcessing delimiterProcessing = this.getConfiguration().processDelimiter();
        TwoDimensional.Position startPosition = this.offsetToPosition(selection.getStart(), TwoDimensional.Bias.Backward);
        TwoDimensional.Position endPosition = this.offsetToPosition(selection.getEnd(), TwoDimensional.Bias.Forward);
        int startParagraph = startPosition.getMajor();
        int endParagraph = endPosition.getMajor();
        switch (delimiterProcessing) {
            case NONE: {
                this.logger().error("Try to toggle style when delimiter processing is NONE");
                return;
            }
            case DELETE_AND_RICH_REPLACE: {
                this.logger().error("Try to toggle style when delimiter processing is DELETE_AND_RICH_REPLACE");
                return;
            }
            case TOGGLEABLE: {
                ParagraphStyle.BlockStyle blockStyle = style;
                StyleDetection styleDetection = this.detectStyle(selection, blockStyle.getClass());
                MultiChangeBuilder multiChange = this.createMultiChange();
                GenericEditableStyledDocument document = new GenericEditableStyledDocument(ReadOnlyStyledDocument.from((StyledDocument)this.getDocument()));
                block11: for (int p = startParagraph; p <= endParagraph; ++p) {
                    if (!sameInstance) {
                        blockStyle = blockStyle.copy();
                    }
                    ParagraphStyle paragraphStyle = (ParagraphStyle)this.getParagraph(p).getParagraphStyle();
                    switch (styleDetection.ordinal()) {
                        case 0: 
                        case 1: {
                            if (paragraphStyle.blocks.isEmpty()) {
                                paragraphStyle = paragraphStyle.addBlocks(List.of(blockStyle));
                                break;
                            }
                            paragraphStyle = paragraphStyle.replaceLastBlock(blockStyle);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            paragraphStyle = paragraphStyle.removeLastBlock();
                            break;
                        }
                        case 5: {
                            continue block11;
                        }
                    }
                    document.setParagraphStyle(p, (Object)paragraphStyle);
                }
                multiChange.replace(0, this.getLength(), (StyledDocument)document);
                if (multiChange.hasChanges()) {
                    multiChange.commit();
                }
                this.updateParagraphs();
                return;
            }
            case STYLE: {
                MultiChangeBuilder multiChange = this.createMultiChange();
                int p = startParagraph;
                if (style instanceof ParagraphStyle.Code) {
                    ParagraphStyle.Code code = (ParagraphStyle.Code)style;
                    StringBuilder open = new StringBuilder();
                    open.append(code.delimiter(true)).append(System.lineSeparator());
                    multiChange.insertText(startParagraph, 0, open.toString());
                    StringBuilder close = new StringBuilder();
                    close.append(System.lineSeparator()).append(code.delimiter(false));
                    multiChange.insertText(endParagraph, this.getParagraph(endParagraph).length(), close.toString());
                    p = endParagraph + 1;
                } else {
                    StringBuilder replacement;
                    if (startPosition.getMinor() > 0) {
                        replacement = new StringBuilder();
                        replacement.append(System.lineSeparator());
                        replacement.append(style.delimiter());
                        replacement.append(" ");
                        multiChange.insertText(selection.getStart(), replacement.toString());
                        ++p;
                    }
                    while (p <= endParagraph) {
                        replacement = new StringBuilder();
                        replacement.append(style.delimiter());
                        replacement.append(" ");
                        multiChange.insertText(p, 0, replacement.toString());
                        ++p;
                    }
                    --p;
                }
                if (multiChange.hasChanges()) {
                    multiChange.commit();
                    this.applyMarkdown();
                }
                this.moveTo(p, this.getParagraphLength(p));
                return;
            }
        }
    }

    default public Optional<ParagraphStyle.Heading> detectHeader(IndexRange range) {
        int startParagraphIndex = this.offsetToPosition(range.getStart(), TwoDimensional.Bias.Backward).getMajor();
        int endParagraphIndex = this.offsetToPosition(range.getEnd(), TwoDimensional.Bias.Forward).getMajor();
        Integer level = null;
        block4: for (int p = startParagraphIndex; p <= endParagraphIndex; ++p) {
            Paragraph paragraph = this.getParagraph(p);
            switch (this.getConfiguration().processDelimiter()) {
                case NONE: 
                case DELETE_AND_RICH_REPLACE: {
                    return Optional.empty();
                }
                case TOGGLEABLE: 
                case STYLE: {
                    ParagraphStyle paragraphStyle = (ParagraphStyle)paragraph.getParagraphStyle();
                    if (paragraphStyle.isCode()) {
                        return Optional.empty();
                    }
                    int l = paragraphStyle.heading.level();
                    if (level == null) {
                        level = l;
                        continue block4;
                    }
                    if (level == l) continue block4;
                    return Optional.empty();
                }
            }
        }
        return Optional.of(ParagraphStyle.Heading.of(level == null ? 0 : level));
    }

    default public void updateHeader(ParagraphStyle.Heading heading) {
        IndexRange selection = this.getSelection();
        RichStyledConfiguration.DelimiterProcessing delimiterProcessing = this.getConfiguration().processDelimiter();
        TwoDimensional.Position startPosition = this.offsetToPosition(selection.getStart(), TwoDimensional.Bias.Backward);
        TwoDimensional.Position endPosition = this.offsetToPosition(selection.getEnd(), TwoDimensional.Bias.Forward);
        int startParagraph = startPosition.getMajor();
        int endParagraph = endPosition.getMajor();
        switch (delimiterProcessing) {
            case NONE: {
                this.logger().error("Try to toggle style when delimiter processing is NONE");
                break;
            }
            case DELETE_AND_RICH_REPLACE: {
                this.logger().error("Try to toggle style when delimiter processing is DELETE_AND_RICH_REPLACE");
                break;
            }
            case TOGGLEABLE: {
                MultiChangeBuilder multiChange = this.createMultiChange();
                GenericEditableStyledDocument document = new GenericEditableStyledDocument(ReadOnlyStyledDocument.from((StyledDocument)this.getDocument()));
                for (int p = startParagraph; p <= endParagraph; ++p) {
                    ParagraphStyle paragraphStyle = (ParagraphStyle)this.getParagraph(p).getParagraphStyle();
                    paragraphStyle = paragraphStyle.setHeading(Optional.of(heading));
                    document.setParagraphStyle(p, (Object)paragraphStyle);
                }
                multiChange.replace(0, this.getLength(), (StyledDocument)document);
                if (multiChange.hasChanges()) {
                    multiChange.commit();
                }
                this.updateParagraphs();
                break;
            }
            case STYLE: {
                int p;
                MultiChangeBuilder multiChange = this.createMultiChange();
                for (p = startParagraph; p <= endParagraph; ++p) {
                    multiChange.insertText(p, 0, heading.delimiter());
                }
                --p;
                if (multiChange.hasChanges()) {
                    multiChange.commit();
                    this.applyMarkdown();
                }
                this.moveTo(p, this.getParagraphLength(p));
            }
        }
    }

    public static enum StyleDetection {
        NONE,
        NONE_INFO,
        ALL,
        ALL_INFO,
        MIXED,
        INVALID;

    }
}

