/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx.utils;

import java.util.Optional;

public interface RichStyledConfiguration {
    public DelimiterProcessing processDelimiter();

    public boolean applyStyle();

    public boolean applyBlockCodeStyle();

    public boolean enableLinkDetection();

    public boolean clickableLinks();

    public void linkFound(Optional<String> var1);

    default public void handleEnter() {
    }

    default public boolean shouldProcessMarkdown() {
        if (this.enableLinkDetection()) {
            return true;
        }
        return this.processDelimiter() != DelimiterProcessing.NONE;
    }

    public static RichStyledConfiguration empty() {
        return new Empty();
    }

    public static RichStyledConfiguration style() {
        return new Style();
    }

    public static enum DelimiterProcessing {
        NONE,
        DELETE_AND_RICH_REPLACE,
        TOGGLEABLE,
        STYLE;


        public boolean isDelete() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1, 2 -> true;
                case 0, 3 -> false;
            };
        }
    }

    public static class Empty
    implements RichStyledConfiguration {
        @Override
        public DelimiterProcessing processDelimiter() {
            return DelimiterProcessing.NONE;
        }

        @Override
        public boolean applyStyle() {
            return false;
        }

        @Override
        public boolean applyBlockCodeStyle() {
            return false;
        }

        @Override
        public boolean enableLinkDetection() {
            return false;
        }

        @Override
        public boolean clickableLinks() {
            return false;
        }

        @Override
        public void linkFound(Optional<String> url) {
        }
    }

    public static class Style
    extends Empty {
        @Override
        public DelimiterProcessing processDelimiter() {
            return DelimiterProcessing.DELETE_AND_RICH_REPLACE;
        }

        @Override
        public boolean applyStyle() {
            return true;
        }

        @Override
        public boolean applyBlockCodeStyle() {
            return true;
        }

        @Override
        public boolean clickableLinks() {
            return true;
        }
    }
}

