/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx.utils;

import io.olvid.windows.messenger.fx.misc.richtextfx.style.ParagraphStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.SegmentStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.MarkdownChangeBuilder;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.control.IndexRange;
import org.commonmark.ext.gfm.strikethrough.Strikethrough;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Delimited;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Heading;
import org.commonmark.node.Link;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.SourceSpan;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.nibor.autolink.LinkExtractor;
import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;
import org.nibor.autolink.Span;

public class MarkdownVisitor
extends AbstractVisitor {
    private final MarkdownChangeBuilder changeBuilder;
    private final RichStyledConfiguration configuration;
    static final LinkExtractor linkExtractor = LinkExtractor.builder().linkTypes(EnumSet.of(LinkType.URL)).build();
    private static final boolean debug = false;

    public MarkdownVisitor(MarkdownChangeBuilder changeBuilder) {
        this.changeBuilder = changeBuilder;
        this.configuration = changeBuilder.getConfiguration();
    }

    private void processDelimited(Delimited delimited, SegmentStyle.Style style) {
        int textEnd;
        int openingDelimiterEnd;
        if (!(delimited instanceof Node)) {
            return;
        }
        Node node = (Node)delimited;
        List sourceSpans = node.getSourceSpans();
        if (sourceSpans.size() != 1) {
            return;
        }
        SourceSpan sourceSpan = (SourceSpan)sourceSpans.get(0);
        int paragraph = sourceSpan.getLineIndex();
        int openingDelimiterStart = sourceSpan.getColumnIndex();
        int textStart = openingDelimiterEnd = openingDelimiterStart + delimited.getOpeningDelimiter().length();
        int closingDelimiterStart = textEnd = textStart + sourceSpan.getLength() - delimited.getOpeningDelimiter().length() - delimited.getClosingDelimiter().length();
        int closingDelimiterEnd = closingDelimiterStart + delimited.getClosingDelimiter().length();
        this.changeBuilder.processDelimiter(MarkdownChangeBuilder.Range.relative(paragraph, openingDelimiterStart, openingDelimiterEnd), MarkdownChangeBuilder.DelimiterType.OPEN).addStyle(Optional.of(style), MarkdownChangeBuilder.Range.relative(paragraph, textStart, textEnd)).processDelimiter(MarkdownChangeBuilder.Range.relative(paragraph, closingDelimiterStart, closingDelimiterEnd), MarkdownChangeBuilder.DelimiterType.CLOSE);
    }

    public void visit(Emphasis emphasis) {
        super.visit(emphasis);
        this.processDelimited((Delimited)emphasis, new SegmentStyle.Style.Italic(emphasis.getOpeningDelimiter()));
    }

    public void visit(StrongEmphasis strongEmphasis) {
        super.visit(strongEmphasis);
        this.processDelimited((Delimited)strongEmphasis, new SegmentStyle.Style.Bold(strongEmphasis.getOpeningDelimiter()));
    }

    public void visit(CustomNode customNode) {
        super.visit(customNode);
        if (customNode instanceof Strikethrough) {
            Strikethrough strikethrough = (Strikethrough)customNode;
            this.processDelimited((Delimited)strikethrough, new SegmentStyle.Style.Strikethrough());
        }
    }

    public void visit(Heading heading) {
        super.visit(heading);
        int level = heading.getLevel();
        List sourceSpans = heading.getSourceSpans();
        if (sourceSpans.size() != 1) {
            return;
        }
        SourceSpan sourceSpan = (SourceSpan)sourceSpans.get(0);
        int paragraph = sourceSpan.getLineIndex();
        List<SourceSpan> childSourceSpans = MarkdownVisitor.getChildSourceSpan((Node)heading, paragraph);
        if (childSourceSpans.isEmpty()) {
            return;
        }
        int delimiterStart = sourceSpan.getColumnIndex();
        String text = this.changeBuilder.getParagraphText(paragraph);
        text = text.substring(delimiterStart);
        int spaceBefore = text.indexOf("#");
        int delimiterEnd = childSourceSpans.get(0).getColumnIndex();
        int spaceAfter = delimiterEnd - spaceBefore - level - delimiterStart;
        ParagraphStyle.Heading headingStyle = ParagraphStyle.Heading.of(level, spaceBefore, spaceAfter);
        this.changeBuilder.processDelimiter(MarkdownChangeBuilder.Range.relative(paragraph, delimiterStart, delimiterEnd), MarkdownChangeBuilder.DelimiterType.NONE).addHeading(paragraph, headingStyle);
    }

    public void visit(Code code) {
        super.visit(code);
        List sourceSpans = code.getSourceSpans();
        if (sourceSpans.size() != 1) {
            return;
        }
        SourceSpan sourceSpan = (SourceSpan)sourceSpans.get(0);
        int paragraph = sourceSpan.getLineIndex();
        String text = this.changeBuilder.getParagraphText(paragraph);
        int textStart = text.indexOf(code.getLiteral(), sourceSpan.getColumnIndex());
        int textEnd = textStart + code.getLiteral().length();
        int openingStart = sourceSpan.getColumnIndex();
        int openingEnd = textStart;
        String openingDelimiter = text.substring(openingStart, openingEnd);
        int closingStart = textEnd;
        int closingEnd = sourceSpan.getColumnIndex() + sourceSpan.getLength();
        String closingDelimiter = text.substring(closingStart, closingEnd);
        this.changeBuilder.processDelimiter(MarkdownChangeBuilder.Range.relative(paragraph, openingStart, openingEnd), MarkdownChangeBuilder.DelimiterType.OPEN).addStyle(Optional.of(new SegmentStyle.Style.InlineCode(openingDelimiter, closingDelimiter)), MarkdownChangeBuilder.Range.relative(paragraph, textStart, textEnd)).processDelimiter(MarkdownChangeBuilder.Range.relative(paragraph, closingStart, closingEnd), MarkdownChangeBuilder.DelimiterType.CLOSE);
    }

    public void visit(FencedCodeBlock fencedCodeBlock) {
        super.visit(fencedCodeBlock);
        List sourceSpans = fencedCodeBlock.getSourceSpans();
        if (sourceSpans.size() < 3) {
            return;
        }
        if (fencedCodeBlock.getClosingFenceLength() == null) {
            return;
        }
        int firstParagraph = ((SourceSpan)sourceSpans.get(0)).getLineIndex() + 1;
        int lastParagraph = ((SourceSpan)sourceSpans.get(sourceSpans.size() - 1)).getLineIndex() - 1;
        SourceSpan openSpan = (SourceSpan)sourceSpans.get(0);
        this.changeBuilder.processDelimiter(MarkdownChangeBuilder.Range.of(openSpan), MarkdownChangeBuilder.DelimiterType.NONE).addCodeDelimiter(openSpan.getLineIndex());
        Object info = fencedCodeBlock.getInfo();
        int spaceBeforeInfo = ((SourceSpan)sourceSpans.get(0)).getLength();
        spaceBeforeInfo -= fencedCodeBlock.getOpeningFenceLength().intValue();
        spaceBeforeInfo -= ((String)info).length();
        info = " ".repeat(spaceBeforeInfo) + (String)info;
        ParagraphStyle.Code code = new ParagraphStyle.Code(fencedCodeBlock.getFenceCharacter(), fencedCodeBlock.getOpeningFenceLength(), fencedCodeBlock.getClosingFenceLength(), (String)info);
        for (int paragraph = firstParagraph; paragraph <= lastParagraph; ++paragraph) {
            this.changeBuilder.addParagraphBlock(paragraph, code);
            MarkdownVisitor.getSourceSpan(sourceSpans, paragraph).forEach(span -> this.changeBuilder.addCodeBlockStyle(MarkdownChangeBuilder.Range.of(span)));
        }
        SourceSpan closeSpan = (SourceSpan)sourceSpans.get(sourceSpans.size() - 1);
        this.changeBuilder.processDelimiter(MarkdownChangeBuilder.Range.of(closeSpan), MarkdownChangeBuilder.DelimiterType.NONE).addCodeDelimiter(closeSpan.getLineIndex());
    }

    public void visit(BlockQuote blockQuote) {
        super.visit(blockQuote);
        List sourceSpans = blockQuote.getSourceSpans();
        for (SourceSpan sourceSpan : sourceSpans) {
            int paragraph = sourceSpan.getLineIndex();
            String text = this.changeBuilder.getParagraphText(paragraph);
            if (sourceSpan.getLength() < 0) {
                this.changeBuilder.addParagraphBlock(paragraph, new ParagraphStyle.Quote(false, 0, 0));
                continue;
            }
            int idx = text.indexOf(">", sourceSpan.getColumnIndex());
            if (idx == -1) {
                this.changeBuilder.addParagraphBlock(paragraph, new ParagraphStyle.Quote(false, 0, 0));
                continue;
            }
            int spaceBefore = idx - sourceSpan.getColumnIndex();
            int spaceAfter = idx + 1 < text.length() && Character.isWhitespace(text.charAt(idx + 1)) ? 1 : 0;
            this.changeBuilder.processDelimiter(MarkdownChangeBuilder.Range.relative(paragraph, sourceSpan.getColumnIndex(), idx + 1 + spaceAfter), MarkdownChangeBuilder.DelimiterType.NONE);
            this.changeBuilder.addParagraphBlock(paragraph, new ParagraphStyle.Quote(true, spaceBefore, spaceAfter));
        }
    }

    public static Optional<String> detectFirstInteger(String text) {
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return Optional.of(matcher.group());
        }
        return Optional.empty();
    }

    public void visitListBlock(ListBlock listBlock, Function<ListItemInfo, ParagraphStyle.BlockStyle> makeBlockStyle) {
        List<Node> children = MarkdownVisitor.getChildren((Node)listBlock);
        ParagraphStyle.BlockStyle lastBlockStyle = null;
        int lastLine = -1;
        for (Node child : children) {
            int last;
            ParagraphStyle.BlockStyle blockStyle;
            ListItem item;
            List sourceSpans;
            if (!(child instanceof ListItem) || (sourceSpans = (item = (ListItem)child).getSourceSpans()).isEmpty()) continue;
            SourceSpan sourceSpan = (SourceSpan)sourceSpans.get(0);
            int first = sourceSpan.getLineIndex();
            if (lastBlockStyle != null && lastLine != -1 && lastLine < first - 1) {
                for (int p = lastLine + 1; p < first; ++p) {
                    this.changeBuilder.addParagraphBlock(p, lastBlockStyle);
                }
            }
            String paragraphText = this.changeBuilder.getParagraphText(first);
            Optional<String> originalIndex = MarkdownVisitor.detectFirstInteger(paragraphText.substring(sourceSpan.getColumnIndex()));
            ListItemInfo listItemInfo = new ListItemInfo(originalIndex, item.getMarkerIndent(), item.getContentIndent());
            lastBlockStyle = blockStyle = makeBlockStyle.apply(listItemInfo);
            lastLine = last = ((SourceSpan)sourceSpans.get(sourceSpans.size() - 1)).getLineIndex();
            for (int p = first; p <= last; ++p) {
                this.changeBuilder.addParagraphBlock(p, blockStyle);
            }
        }
    }

    public void visit(OrderedList orderedList) {
        super.visit(orderedList);
        this.visitListBlock((ListBlock)orderedList, info -> new ParagraphStyle.Ordinal(orderedList.getMarkerStartNumber(), info.index, Optional.ofNullable(orderedList.getMarkerDelimiter()), info.markerIndent, Optional.of(info.contentIndent)));
    }

    public void visit(BulletList bulletList) {
        super.visit(bulletList);
        this.visitListBlock((ListBlock)bulletList, info -> new ParagraphStyle.Bullet(Optional.ofNullable(bulletList.getMarker()), info.markerIndent, Optional.of(info.contentIndent)));
    }

    public void visit(ListItem listItem) {
        super.visit(listItem);
        List sourceSpans = listItem.getSourceSpans();
        for (SourceSpan sourceSpan : sourceSpans) {
            int paragraph = sourceSpan.getLineIndex();
            List<SourceSpan> childSourceSpan = MarkdownVisitor.getChildSourceSpan((Node)listItem, paragraph);
            int start = sourceSpan.getColumnIndex();
            int end = sourceSpan.getColumnIndex() + sourceSpan.getLength();
            for (SourceSpan span : childSourceSpan) {
                end = Math.min(end, span.getColumnIndex());
            }
            end = Math.max(end, start);
            this.changeBuilder.processDelimiter(MarkdownChangeBuilder.Range.relative(paragraph, start, end), MarkdownChangeBuilder.DelimiterType.NONE);
        }
    }

    private void visitLink(int paragraph, int idx, String s) {
        for (Span span : linkExtractor.extractSpans((CharSequence)s)) {
            if (!(span instanceof LinkSpan)) continue;
            String url = s.substring(span.getBeginIndex(), span.getEndIndex());
            int start = idx + span.getBeginIndex();
            int end = idx + span.getEndIndex();
            MarkdownChangeBuilder.Range range = MarkdownChangeBuilder.Range.relative(paragraph, start, end);
            this.changeBuilder.addUrl(range, url);
        }
    }

    private boolean enableLinkDetection() {
        if (this.configuration.enableLinkDetection()) {
            return true;
        }
        return this.configuration.applyStyle();
    }

    public void visit(Text text) {
        super.visit(text);
        if (!this.enableLinkDetection()) {
            return;
        }
        List sourceSpans = text.getSourceSpans();
        if (sourceSpans.isEmpty()) {
            return;
        }
        SourceSpan sourceSpan = (SourceSpan)sourceSpans.get(0);
        String literal = text.getLiteral();
        this.visitLink(sourceSpan.getLineIndex(), sourceSpan.getColumnIndex(), literal);
    }

    public void visit(Link link) {
        super.visit(link);
        if (!this.enableLinkDetection()) {
            return;
        }
        List sourceSpans = link.getSourceSpans();
        if (sourceSpans.isEmpty()) {
            return;
        }
        SourceSpan sourceSpan = (SourceSpan)sourceSpans.get(0);
        String destination = link.getDestination();
        Optional<IndexRange> textIndexRange = MarkdownVisitor.firstTextIndexRange((Node)link);
        if (textIndexRange.isEmpty()) {
            return;
        }
        IndexRange range = textIndexRange.get();
        String paragraphText = this.changeBuilder.getParagraphText(sourceSpan.getLineIndex());
        int indexOfDestination = paragraphText.indexOf(destination, range.getStart());
        this.visitLink(sourceSpan.getLineIndex(), indexOfDestination, destination);
    }

    private static List<Node> getChildren(Node node) {
        ArrayList<Node> children = new ArrayList<Node>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
            children.add(child);
        }
        return children;
    }

    private static List<SourceSpan> getSourceSpan(List<SourceSpan> sourceSpans, int line) {
        ArrayList<SourceSpan> result = new ArrayList<SourceSpan>();
        for (SourceSpan sourceSpan : sourceSpans) {
            if (sourceSpan.getLineIndex() != line) continue;
            result.add(sourceSpan);
        }
        return result;
    }

    private static List<SourceSpan> getChildSourceSpan(Node node, int line) {
        ArrayList<SourceSpan> result = new ArrayList<SourceSpan>();
        List<Node> children = MarkdownVisitor.getChildren(node);
        for (Node child : children) {
            List sourceSpans = child.getSourceSpans();
            result.addAll(MarkdownVisitor.getSourceSpan(sourceSpans, line));
        }
        return result;
    }

    private static Optional<IndexRange> firstTextIndexRange(Node node) {
        if (node == null) {
            return Optional.empty();
        }
        if (node instanceof Text) {
            Text text = (Text)node;
            List sourceSpans = text.getSourceSpans();
            if (sourceSpans.isEmpty()) {
                return Optional.empty();
            }
            SourceSpan sourceSpan = (SourceSpan)sourceSpans.get(0);
            return Optional.of(new IndexRange(sourceSpan.getColumnIndex(), sourceSpan.getColumnIndex() + sourceSpan.getLength()));
        }
        return MarkdownVisitor.firstTextIndexRange(node.getFirstChild());
    }

    protected void visitChildren(Node parent) {
        super.visitChildren(parent);
    }

    public record ListItemInfo(Optional<String> index, int markerIndent, int contentIndent) {
    }
}

