/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx.utils;

import io.olvid.windows.messenger.fx.misc.CollectionUtils;
import io.olvid.windows.messenger.fx.misc.richtextfx.EditableStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.ParagraphStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.EditableArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;

public interface ActionableArea
extends EditableArea {
    public static void configure(EditableStyledArea area) {
        InputMap[] inputMapArray = new InputMap[5];
        inputMapArray[0] = InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.ENTER, (KeyCombination.Modifier[])new KeyCombination.Modifier[0]), area::handleEnter);
        inputMapArray[1] = InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.ENTER, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), area::handleShiftEnter);
        inputMapArray[2] = InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.BACK_SPACE, (KeyCombination.Modifier[])new KeyCombination.Modifier[0]), area::handleBackSpace);
        inputMapArray[3] = InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.TAB, (KeyCombination.Modifier[])new KeyCombination.Modifier[0]), area::handleTab);
        inputMapArray[4] = InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.TAB, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN}), area::handleShiftTab);
        Nodes.addInputMap((Node)area, (InputMap)InputMap.sequence((InputMap[])inputMapArray));
    }

    default public void handleEnter(KeyEvent ignore) {
        this.getConfiguration().handleEnter();
    }

    default public void handleShiftEnter(KeyEvent ignore) {
        this.replaceSelection(System.lineSeparator());
    }

    default public boolean processBackSpace() {
        IndexRange selection = this.getSelection();
        if (selection.getLength() != 0) {
            return false;
        }
        int start = selection.getStart();
        TwoDimensional.Position position = this.offsetToPosition(start, TwoDimensional.Bias.Backward);
        if (position.getMinor() != 0) {
            return false;
        }
        int p = position.getMajor();
        Paragraph paragraph = this.getParagraph(p);
        ParagraphStyle paragraphStyle = (ParagraphStyle)paragraph.getParagraphStyle();
        if (paragraphStyle.blocks.isEmpty()) {
            return false;
        }
        if (paragraphStyle.isCode()) {
            this.setParagraphStyleAndUpdate(position.getMajor(), paragraphStyle.removeLastBlock());
            return true;
        }
        if (p == 0) {
            this.setParagraphStyleAndUpdate(p, paragraphStyle.removeLastBlock());
            return true;
        }
        ParagraphStyle previousStyle = (ParagraphStyle)this.getParagraph(p - 1).getParagraphStyle();
        List<ParagraphStyle.BlockStyle> previousBlocks = previousStyle.blocks;
        if (CollectionUtils.equals(paragraphStyle.blocks, previousBlocks, (b1, b2) -> b1 == b2)) {
            return false;
        }
        this.setParagraphStyleAndUpdate(p, ParagraphStyle.of(this, previousBlocks, previousStyle.heading, false, previousStyle.textAlignment));
        return true;
    }

    default public void handleBackSpace(KeyEvent ignore) {
        if (this.processBackSpace()) {
            return;
        }
        IndexRange selection = this.getSelection();
        if (selection.getLength() == 0) {
            this.deletePreviousChar();
        } else {
            this.replaceSelection("");
        }
    }

    default public boolean canTab() {
        if (this.getConfiguration().processDelimiter() != RichStyledConfiguration.DelimiterProcessing.TOGGLEABLE) {
            return false;
        }
        IndexRange selection = this.getSelection();
        int start = selection.getStart();
        int end = selection.getEnd();
        TwoDimensional.Position position = this.offsetToPosition(start, TwoDimensional.Bias.Backward);
        int p = position.getMajor();
        if (p == 0) {
            return false;
        }
        TwoDimensional.Position endPosition = this.offsetToPosition(end, TwoDimensional.Bias.Forward);
        if (p != endPosition.getMajor()) {
            return false;
        }
        Paragraph paragraph = this.getParagraph(p);
        List<ParagraphStyle.BlockStyle> blocks = ((ParagraphStyle)paragraph.getParagraphStyle()).blocks;
        if (blocks.isEmpty()) {
            return false;
        }
        if (((ParagraphStyle)paragraph.getParagraphStyle()).isCode()) {
            return false;
        }
        Paragraph previousParagraph = this.getParagraph(p - 1);
        List<ParagraphStyle.BlockStyle> previousBlock = ((ParagraphStyle)previousParagraph.getParagraphStyle()).blocks;
        if (previousBlock.isEmpty()) {
            return false;
        }
        return previousBlock.size() >= blocks.size();
    }

    default public void processTab() {
        IndexRange selection = this.getSelection();
        int start = selection.getStart();
        TwoDimensional.Position position = this.offsetToPosition(start, TwoDimensional.Bias.Backward);
        int p = position.getMajor();
        Paragraph paragraph = this.getParagraph(p);
        Paragraph previousParagraph = this.getParagraph(p - 1);
        List<ParagraphStyle.BlockStyle> previousBlock = ((ParagraphStyle)previousParagraph.getParagraphStyle()).blocks;
        ParagraphStyle paragraphStyle = ((ParagraphStyle)paragraph.getParagraphStyle()).incrIndent(previousBlock);
        this.setParagraphStyleAndUpdate(p, paragraphStyle);
    }

    default public void handleTab(KeyEvent ignore) {
        if (this.canTab()) {
            this.processTab();
        } else {
            this.replaceSelection("\t");
        }
    }

    default public boolean canShiftTab() {
        if (this.getConfiguration().processDelimiter() != RichStyledConfiguration.DelimiterProcessing.TOGGLEABLE) {
            return false;
        }
        IndexRange selection = this.getSelection();
        int start = selection.getStart();
        int end = selection.getEnd();
        TwoDimensional.Position position = this.offsetToPosition(start, TwoDimensional.Bias.Backward);
        int p = position.getMajor();
        if (p == 0) {
            return false;
        }
        TwoDimensional.Position endPosition = this.offsetToPosition(end, TwoDimensional.Bias.Forward);
        if (p != endPosition.getMajor()) {
            return false;
        }
        Paragraph paragraph = this.getParagraph(p);
        List<ParagraphStyle.BlockStyle> blocks = ((ParagraphStyle)paragraph.getParagraphStyle()).blocks;
        if (blocks.isEmpty()) {
            return false;
        }
        return !((ParagraphStyle)paragraph.getParagraphStyle()).isCode();
    }

    default public void processShiftTab() {
        IndexRange selection = this.getSelection();
        int start = selection.getStart();
        TwoDimensional.Position position = this.offsetToPosition(start, TwoDimensional.Bias.Backward);
        Paragraph paragraph = this.getParagraph(position.getMajor());
        ParagraphStyle paragraphStyle = (ParagraphStyle)paragraph.getParagraphStyle();
        this.setParagraphStyleAndUpdate(position.getMajor(), paragraphStyle.decrIndent());
    }

    default public void handleShiftTab(KeyEvent ignore) {
        if (this.canShiftTab()) {
            this.processShiftTab();
        }
    }
}

