/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx.style;

import io.olvid.windows.messenger.fx.misc.EmojiHelper;
import io.olvid.windows.messenger.fx.misc.richtextfx.RichStyledArea;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javafx.scene.Cursor;
import javafx.scene.text.Text;

public record SegmentStyle(List<Style> styles, Optional<String> url) {
    public static final List<Style> empty = List.of();
    private static final SegmentStyle defaultStyle = new SegmentStyle(empty, Optional.empty());

    public static SegmentStyle defaultStyle() {
        return defaultStyle;
    }

    public SegmentStyle addStyle(Optional<Style> style) {
        if (style.isEmpty() || this.contains(style.get().getClass())) {
            return this;
        }
        ArrayList<Style> copy = new ArrayList<Style>(this.styles);
        copy.add(style.get());
        return new SegmentStyle(copy, this.url);
    }

    public SegmentStyle setUrl(Optional<String> url) {
        if (this.url.isEmpty() && url.isPresent()) {
            return new SegmentStyle(this.styles, url);
        }
        return this;
    }

    public SegmentStyle clearUrl() {
        if (this.url.isEmpty()) {
            return this;
        }
        return new SegmentStyle(this.styles, Optional.empty());
    }

    public SegmentStyle removeStyles(Collection<Class<? extends Style>> stylesToRemove) {
        ArrayList<Style> newStyled = new ArrayList<Style>();
        for (Style style : this.styles) {
            if (stylesToRemove.contains(style.getClass())) continue;
            newStyled.add(style);
        }
        if (newStyled.size() == this.styles.size()) {
            return this;
        }
        return new SegmentStyle(newStyled, this.url);
    }

    public boolean containsAny(Set<Class<? extends Style>> styleClasses) {
        for (Style style : this.styles) {
            for (Class<? extends Style> styleClass : styleClasses) {
                if (!styleClass.isInstance(style)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Class<? extends Style> styleClass) {
        return this.containsAny(Set.of(styleClass));
    }

    public boolean hasDelimiters() {
        return this.containsAny(Set.of(Style.OpenDelimiter.class, Style.CloseDelimiter.class, Style.Delimiter.class));
    }

    public boolean hasCode() {
        return this.containsAny(Set.of(Style.InlineCode.class, Style.BlockCode.class));
    }

    public void applyToText(Text text) {
        if (this.hasDelimiters()) {
            text.getStyleClass().add((Object)"delimiter");
        } else if (this.hasCode()) {
            text.getStyleClass().addAll((Object[])new String[]{"code"});
            if (this.contains(Style.InlineCode.class)) {
                text.getStyleClass().add((Object)"inline-code");
            }
        } else {
            text.getStyleClass().add((Object)"text");
        }
        StringBuilder styleBuilder = new StringBuilder();
        if (this.contains(Style.Bold.class)) {
            styleBuilder.append("-fx-font-weight: bold;");
        }
        if (this.contains(Style.Italic.class)) {
            styleBuilder.append("-fx-font-style: italic;");
        }
        if (this.contains(Style.Strikethrough.class)) {
            styleBuilder.append("-fx-strikethrough: true;");
        }
        String style = styleBuilder.toString();
        text.setStyle(style);
        if (this.contains(Style.Underline.class)) {
            text.setUnderline(true);
        }
        if (this.url.isPresent()) {
            text.setCursor(Cursor.HAND);
            text.setOnMouseClicked(click -> {
                try {
                    AppRuntimeHelper.launchBrowser(this.url.get());
                }
                catch (Exception e) {
                    RichStyledArea.logger.error("The browser could not be open.", e);
                }
            });
        }
    }

    public void applyToEmoji(EmojiHelper.EmojiView emojiView) {
    }

    @Override
    public String toString() {
        return "SegmentStyle{styles=" + String.valueOf(this.styles) + ", url=" + String.valueOf(this.url) + "}";
    }

    public static abstract class Style {
        public String delimiter(boolean open) {
            return "";
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return this.getClass().equals(obj.getClass());
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        public static class CloseDelimiter
        extends Style {
        }

        public static class OpenDelimiter
        extends Style {
        }

        public static class Delimiter
        extends Style {
        }

        public static class Underline
        extends Style {
        }

        public static class BlockCode
        extends Style {
        }

        public static class InlineCode
        extends Style {
            public final String openDelimiter;
            public final String closeDelimiter;

            public InlineCode() {
                this("`", "`");
            }

            public InlineCode(String openDelimiter, String closeDelimiter) {
                this.openDelimiter = openDelimiter;
                this.closeDelimiter = closeDelimiter;
            }

            @Override
            public String delimiter(boolean open) {
                if (open) {
                    return this.openDelimiter;
                }
                return this.closeDelimiter;
            }

            @Override
            public String toString() {
                return "InlineCode{openDelimiter='" + this.openDelimiter + "', closeDelimiter='" + this.closeDelimiter + "'}";
            }
        }

        public static class Strikethrough
        extends Style {
            @Override
            public String delimiter(boolean open) {
                return "~~";
            }
        }

        public static class Italic
        extends Style {
            public final String delimiter;

            public Italic(String delimiter) {
                this.delimiter = delimiter;
            }

            public Italic() {
                this("*");
            }

            @Override
            public String delimiter(boolean open) {
                return this.delimiter;
            }
        }

        public static class Bold
        extends Style {
            public final String delimiter;

            public Bold(String delimiter) {
                this.delimiter = delimiter;
            }

            public Bold() {
                this("**");
            }

            @Override
            public String delimiter(boolean open) {
                return this.delimiter;
            }
        }
    }
}

