/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx.style;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.EmojiHelper;
import io.olvid.windows.messenger.fx.misc.richtextfx.RichStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.SegmentStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.BlocksInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.StyleActions;

public class ParagraphStyle {
    public final List<BlockStyle> blocks;
    public final Heading heading;
    public final boolean hasCodeDelimiter;
    public final TextAlignment textAlignment;
    public static final double padding = 8.0;
    private Optional<StyleActions<ParagraphStyle, SegmentStyle>> area;

    private ParagraphStyle(Optional<StyleActions<ParagraphStyle, SegmentStyle>> area, List<BlockStyle> blocks, Heading heading, boolean hasCodeDelimiter, TextAlignment textAlignment) {
        this.blocks = blocks;
        this.area = area;
        this.heading = heading;
        this.hasCodeDelimiter = hasCodeDelimiter;
        this.textAlignment = textAlignment;
    }

    public static ParagraphStyle defaultStyle() {
        return new ParagraphStyle(Optional.empty(), List.of(), Heading.BODY, false, TextAlignment.LEFT);
    }

    public static ParagraphStyle of(StyleActions<ParagraphStyle, SegmentStyle> area, List<BlockStyle> blocks, Heading heading, boolean hasCodeDelimiter, TextAlignment textAlignment) {
        return new ParagraphStyle(Optional.of(area), blocks, heading, hasCodeDelimiter, textAlignment);
    }

    public void setArea(StyleActions<ParagraphStyle, SegmentStyle> area) {
        this.area = Optional.of(area);
    }

    public ParagraphStyle addBlocks(List<BlockStyle> blocks) {
        ArrayList<BlockStyle> newBlocks = new ArrayList<BlockStyle>();
        newBlocks.addAll(blocks);
        newBlocks.addAll(this.blocks);
        return new ParagraphStyle(this.area, newBlocks, this.heading, this.hasCodeDelimiter, this.textAlignment);
    }

    public ParagraphStyle setHeading(Optional<Heading> heading) {
        if (heading.isEmpty()) {
            return this;
        }
        return new ParagraphStyle(this.area, this.blocks, heading.get(), this.hasCodeDelimiter, this.textAlignment);
    }

    public ParagraphStyle setCodeDelimiter(boolean hasCodeDelimiter) {
        return new ParagraphStyle(this.area, this.blocks, this.heading, hasCodeDelimiter, this.textAlignment);
    }

    public ParagraphStyle setTextAlignment(TextAlignment textAlignment) {
        return new ParagraphStyle(this.area, this.blocks, this.heading, this.hasCodeDelimiter, textAlignment);
    }

    public ParagraphStyle next() {
        if (this.area.isPresent() && this.area.get().getInitialParagraphStyle() == this) {
            return this;
        }
        if (this.blocks.isEmpty()) {
            return new ParagraphStyle(this.area, this.blocks, Heading.BODY, this.hasCodeDelimiter, this.textAlignment);
        }
        BlockStyle last = this.blocks.get(this.blocks.size() - 1);
        ArrayList<BlockStyle> blocksStyles = new ArrayList<BlockStyle>(this.blocks.subList(0, this.blocks.size() - 1));
        Optional<BlockStyle> next = last.next();
        if (next.isPresent()) {
            blocksStyles.add(next.get());
        }
        return new ParagraphStyle(this.area, blocksStyles, Heading.BODY, false, this.textAlignment);
    }

    public ParagraphStyle removeLastBlock() {
        if (this.blocks.isEmpty()) {
            return this;
        }
        ArrayList<BlockStyle> bs = new ArrayList<BlockStyle>();
        for (int i = 0; i < this.blocks.size() - 1; ++i) {
            if (i == this.blocks.size() - 2) {
                bs.add(this.blocks.get(i).copy());
                continue;
            }
            bs.add(this.blocks.get(i));
        }
        return new ParagraphStyle(this.area, bs, this.heading, false, this.textAlignment);
    }

    public ParagraphStyle replaceLastBlock(BlockStyle block) {
        if (this.blocks.isEmpty()) {
            return this;
        }
        ArrayList<BlockStyle> bs = new ArrayList<BlockStyle>();
        for (int i = 0; i < this.blocks.size(); ++i) {
            if (i == this.blocks.size() - 1) {
                bs.add(block);
                continue;
            }
            bs.add(this.blocks.get(i));
        }
        return new ParagraphStyle(this.area, bs, this.heading, false, this.textAlignment);
    }

    public boolean isCode() {
        if (this.blocks.isEmpty()) {
            return false;
        }
        return this.blocks.get(this.blocks.size() - 1) instanceof Code;
    }

    public ParagraphStyle incrIndent(List<BlockStyle> previous) {
        if (this.blocks.isEmpty()) {
            return this;
        }
        BlockStyle last = this.blocks.get(this.blocks.size() - 1);
        ArrayList<BlockStyle> bs = new ArrayList<BlockStyle>(previous);
        bs.add(last.copy());
        return new ParagraphStyle(this.area, bs, this.heading, false, this.textAlignment);
    }

    public ParagraphStyle decrIndent() {
        if (this.blocks.isEmpty()) {
            return this;
        }
        if (this.blocks.size() == 1) {
            if (this.area.isEmpty()) {
                return ParagraphStyle.defaultStyle();
            }
            return (ParagraphStyle)this.area.get().getInitialParagraphStyle();
        }
        ArrayList<BlockStyle> bs = new ArrayList<BlockStyle>(this.blocks);
        bs.remove(bs.size() - 2);
        return new ParagraphStyle(this.area, bs, this.heading, false, this.textAlignment);
    }

    public ParagraphStyle copy() {
        if (this.area.isPresent() && this.area.get().getInitialParagraphStyle() == this) {
            return this;
        }
        return new ParagraphStyle(this.area, this.blocks, this.heading, this.hasCodeDelimiter, this.textAlignment);
    }

    public synchronized void applyToParagraph(TextFlow textFlow) {
        StyleActions<ParagraphStyle, SegmentStyle> styleActions;
        if (this.area.isEmpty() || !((styleActions = this.area.get()) instanceof RichStyledArea)) {
            return;
        }
        RichStyledArea richStyledArea = (RichStyledArea)styleActions;
        BlocksInfo blocksInfo = new BlocksInfo(richStyledArea);
        Optional<Integer> index = blocksInfo.findIndex(this);
        if (index.isEmpty()) {
            return;
        }
        BlocksInfo.Values values = new BlocksInfo.Values();
        List<BlocksInfo.Info> blockInfos = blocksInfo.getBlockInfos(index.get());
        Optional<BlocksInfo.CodeInfo> codeInfoOpt = blockInfos.stream().filter(BlocksInfo.CodeInfo.class::isInstance).map(BlocksInfo.CodeInfo.class::cast).findAny();
        switch (richStyledArea.getConfiguration().processDelimiter()) {
            case NONE: 
            case STYLE: {
                break;
            }
            case TOGGLEABLE: 
            case DELETE_AND_RICH_REPLACE: {
                if (!codeInfoOpt.isPresent()) break;
                textFlow.getStyleClass().add((Object)"block-code");
                BlocksInfo.CodeInfo codeInfo = codeInfoOpt.get();
                codeInfo.update(values);
                BorderStroke borderStroke = new BorderStroke((Paint)Color.web((String)"E1E2E9"), BorderStrokeStyle.SOLID, values.toCornerRadii(4.0), values.toBorderWidths(1.0));
                textFlow.setBorder(new Border(new BorderStroke[]{borderStroke}));
                BackgroundFill backgroundFill = new BackgroundFill((Paint)Color.rgb((int)248, (int)248, (int)251), values.toCornerRadii(4.0), null);
                Background background = new Background(new BackgroundFill[]{backgroundFill});
                textFlow.setBackground(background);
            }
        }
        for (Node node : textFlow.getChildren()) {
            if (node instanceof Text) {
                Text text = (Text)node;
                String style = text.getStyle();
                StringBinding size = Bindings.createStringBinding(() -> style + String.format("-fx-font-size: %s;", richStyledArea.fontSizeProperty.get() * this.heading.getScale()), (Observable[])new Observable[]{richStyledArea.fontSizeProperty});
                text.styleProperty().bind((ObservableValue)size);
                continue;
            }
            if (!(node instanceof EmojiHelper.EmojiView)) continue;
            EmojiHelper.EmojiView emojiView = (EmojiHelper.EmojiView)node;
            DoubleBinding size = richStyledArea.fontSizeProperty.multiply(this.heading.getScale());
            emojiView.configure((DoubleExpression)size);
        }
        if (this.heading.level != 0) {
            values.bottom = true;
        }
        if (blocksInfo.addBottomPadding(index.get())) {
            values.bottom = true;
        }
        if (blocksInfo.addTopPadding(index.get())) {
            values.top = true;
        }
        textFlow.setPadding(values.toInsets(8.0));
        textFlow.setTextAlignment(this.textAlignment);
    }

    public String toString() {
        return "ParagraphStyle{blocks=" + String.valueOf(this.blocks) + ", heading=" + String.valueOf(this.heading) + ", hasCodeDelimiter=" + this.hasCodeDelimiter + "}";
    }

    public record Heading(int level, int spacesBefore, int spacesAfter) {
        public static final Heading BODY = new Heading(0, 0, 0);
        public static final int MAX_LEVEL = 3;

        public static Heading of(int level) {
            return new Heading(level, 0, level > 0 ? 1 : 0);
        }

        public static Heading of(int level, int spacesBefore, int spacesAfter) {
            return new Heading(level, spacesBefore, spacesAfter);
        }

        public static List<Heading> values() {
            ArrayList<Heading> values = new ArrayList<Heading>();
            for (int i = 1; i <= 3; ++i) {
                values.add(Heading.of(i));
            }
            values.add(BODY);
            return values;
        }

        public String delimiter() {
            return " ".repeat(this.spacesBefore) + "#".repeat(this.level) + " ".repeat(this.spacesAfter);
        }

        public double getScale() {
            return switch (this.level) {
                case 1 -> 1.5;
                case 2 -> 1.25;
                default -> 1.0;
            };
        }

        public String title() {
            return switch (this.level) {
                case 0 -> ViewControllerHelper.getString("header_body_title");
                case 1 -> ViewControllerHelper.getString("header_h1_title");
                case 2 -> ViewControllerHelper.getString("header_h2_title");
                default -> ViewControllerHelper.getString("header_h3_title");
            };
        }
    }

    public static sealed interface BlockStyle
    permits Quote, Code, Bullet, Ordinal {
        default public String delimiter() {
            return "";
        }

        public Optional<BlockStyle> next();

        public BlockStyle copy();
    }

    public record Code(String fenceCharacter, int openingFenceLength, int closingFenceLength, String info) implements BlockStyle
    {
        public Code() {
            this("`", 3, 3, "");
        }

        public String delimiter(boolean opening) {
            if (opening) {
                return this.fenceCharacter.repeat(this.openingFenceLength) + this.info;
            }
            return this.fenceCharacter.repeat(this.closingFenceLength);
        }

        @Override
        public Optional<BlockStyle> next() {
            return Optional.of(this);
        }

        @Override
        public BlockStyle copy() {
            return new Code(this.fenceCharacter, this.openingFenceLength, this.closingFenceLength, this.info);
        }
    }

    public record Ordinal(int startIndex, Optional<String> originalIndex, Optional<String> markerDelimiter, int markerIndent, Optional<Integer> contentIndent) implements BlockStyle
    {
        public Ordinal() {
            this(1, Optional.empty(), Optional.empty(), 0, Optional.empty());
        }

        @Override
        public String delimiter() {
            StringBuilder builder = new StringBuilder().append(" ".repeat(this.markerIndent)).append(this.originalIndex.orElse("1")).append(this.markerDelimiter.orElse("."));
            if (this.contentIndent.isPresent()) {
                int trailing = this.contentIndent.get() - builder.length();
                if (trailing > 0) {
                    builder.append(" ".repeat(trailing));
                }
            } else {
                builder.append(" ");
            }
            return builder.toString();
        }

        @Override
        public Optional<BlockStyle> next() {
            return Optional.of(new Ordinal(this.startIndex, this.originalIndex, this.markerDelimiter, this.markerIndent, this.contentIndent));
        }

        @Override
        public BlockStyle copy() {
            return new Ordinal(1, Optional.empty(), this.markerDelimiter, 0, Optional.empty());
        }
    }

    public record Bullet(Optional<String> marker, int markerIndent, Optional<Integer> contentIndent) implements BlockStyle
    {
        public Bullet() {
            this(Optional.empty(), 0, Optional.empty());
        }

        @Override
        public String delimiter() {
            StringBuilder builder = new StringBuilder().append(" ".repeat(this.markerIndent)).append(this.marker.orElse("-"));
            if (this.contentIndent.isPresent()) {
                int trailing = this.contentIndent.get() - builder.length();
                if (trailing > 0) {
                    builder.append(" ".repeat(trailing));
                }
            } else {
                builder.append(" ");
            }
            return builder.toString();
        }

        @Override
        public Optional<BlockStyle> next() {
            return Optional.of(this.copy());
        }

        @Override
        public BlockStyle copy() {
            return new Bullet(this.marker, this.markerIndent, this.contentIndent);
        }
    }

    public record Quote(boolean visible, int spaceBefore, int spaceAfter) implements BlockStyle
    {
        public Quote() {
            this(true, 0, 1);
        }

        @Override
        public String delimiter() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" ".repeat(this.spaceBefore));
            if (this.visible) {
                stringBuilder.append(">");
            }
            stringBuilder.append(" ".repeat(this.spaceAfter));
            return stringBuilder.toString();
        }

        @Override
        public Optional<BlockStyle> next() {
            return Optional.of(this.copy());
        }

        @Override
        public BlockStyle copy() {
            return new Quote(this.visible, this.spaceBefore, this.spaceAfter);
        }
    }
}

