/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.ClipboardDelegate;
import io.olvid.windows.messenger.fx.misc.EmojiHelper;
import io.olvid.windows.messenger.fx.misc.richtextfx.AutoSizeStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.ParagraphStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.SegmentStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.MarkdownChangeBuilder;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.MarkdownVisitor;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.ParagraphGraphicFactory;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.StringUtils;
import io.olvid.windows.messenger.misc.Watches;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.DataFormat;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Heading;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ThematicBreak;
import org.commonmark.node.Visitor;
import org.commonmark.parser.IncludeSourceSpans;
import org.commonmark.parser.Parser;
import org.fxmisc.richtext.StyleActions;
import org.fxmisc.richtext.TextExt;
import org.fxmisc.richtext.model.NodeSegmentOpsBase;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.ReadOnlyStyledDocumentBuilder;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.model.TextOps;
import org.fxmisc.richtext.util.UndoUtils;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import org.reactfx.util.Either;

public class RichStyledArea
extends AutoSizeStyledArea<ParagraphStyle, Either<String, CharSequence>, SegmentStyle> {
    public static final AppLogger logger = new AppLogger(RichStyledArea.class);
    public final RichStyledConfiguration configuration;
    private static final Either<String, CharSequence> emptySegment = Either.left((Object)"");
    private static final TextOps<String, SegmentStyle> styledTextOps = SegmentOps.styledTextOps();
    private static final EmojiOps<SegmentStyle> emojisOps = new EmojiOps();
    private static final TextOps<Either<String, CharSequence>, SegmentStyle> segmentOps = TextOps.eitherL(styledTextOps, emojisOps, (l, r) -> Optional.empty());
    private static final StyleablePropertyFactory<RichStyledArea> FACTORY = new StyleablePropertyFactory(RichStyledArea.getClassCssMetaData());
    private static final CssMetaData<RichStyledArea, Number> FONT_SIZE = FACTORY.createSizeCssMetaData("-fx-font-size", s -> s.fontSize, (Number)24);
    private final SimpleStyleableObjectProperty<Number> fontSize = new SimpleStyleableObjectProperty(FONT_SIZE, (Object)this, "font-size");
    public final DoubleExpression fontSizeProperty = DoubleProperty.doubleExpression((ObservableValue)this.fontSize.map(Number::doubleValue));
    private static final CssMetaData<RichStyledArea, Paint> TEXT_FILL = FACTORY.createPaintCssMetaData("-fx-text-fill", s -> s.textFillProperty, (Paint)Color.BLACK);
    public final SimpleStyleableObjectProperty<Paint> textFillProperty = new SimpleStyleableObjectProperty(TEXT_FILL, (Object)this, "text-fill");
    private static final CssMetaData<RichStyledArea, Paint> QUOTE_BAR_FILL = FACTORY.createPaintCssMetaData("-fx-quote-bar-fill", s -> s.quoteBarFillProperty, (Paint)Color.BLACK);
    public final SimpleStyleableObjectProperty<Paint> quoteBarFillProperty = new SimpleStyleableObjectProperty(QUOTE_BAR_FILL, (Object)this, "quote-bar-fill");
    protected final SegmentStyle defaultStyle = new SegmentStyle(SegmentStyle.empty, Optional.empty());
    private static Parser parser = null;
    private static final Set<Class<? extends Block>> fullBlockTypes = new LinkedHashSet<Class>(Arrays.asList(BlockQuote.class, Heading.class, FencedCodeBlock.class, ThematicBreak.class, ListBlock.class));
    protected boolean enableDetection = true;
    private ClipboardDelegate clipboardDelegate = null;

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    public RichStyledArea(RichStyledConfiguration configuration) {
        super(ParagraphStyle.defaultStyle(), (paragraph, style) -> style.applyToParagraph((TextFlow)paragraph), SegmentStyle.defaultStyle(), segmentOps, RichStyledArea::createNode);
        this.configuration = configuration;
        this.getStyleClass().add((Object)"text-area");
        ((ParagraphStyle)this.getInitialParagraphStyle()).setArea((StyleActions<ParagraphStyle, SegmentStyle>)this);
        Nodes.addInputMap((Node)this, (InputMap)InputMap.ignore((EventType)ContextMenuEvent.CONTEXT_MENU_REQUESTED));
        this.setParagraphGraphicFactory(new ParagraphGraphicFactory(this));
        this.setUndoManager(UndoUtils.noOpUndoManager());
    }

    public RichStyledConfiguration getConfiguration() {
        return this.configuration;
    }

    public AppLogger logger() {
        return logger;
    }

    public static synchronized Parser getParser() {
        if (parser == null) {
            Extension strikethroughExtension = new StrikethroughExtension.Builder().requireTwoTildes(true).build();
            parser = new Parser.Builder().enabledBlockTypes(fullBlockTypes).extensions(List.of(strikethroughExtension)).includeSourceSpans(IncludeSourceSpans.BLOCKS_AND_INLINES).build();
        }
        return parser;
    }

    private static Node createNode(StyledSegment<Either<String, CharSequence>, SegmentStyle> seg) {
        SegmentStyle style = (SegmentStyle)seg.getStyle();
        return (Node)((Either)seg.getSegment()).unify(text -> {
            TextExt t = new TextExt(text);
            style.applyToText((Text)t);
            return t;
        }, emoji -> {
            EmojiHelper.EmojiView emojiView = new EmojiHelper.EmojiView(emoji.toString());
            style.applyToEmoji(emojiView);
            return emojiView;
        });
    }

    protected List<Either<String, CharSequence>> makeSegments(String str) {
        ArrayList<Either<String, CharSequence>> segments = new ArrayList<Either<String, CharSequence>>();
        EmojiHelper.split(str, text -> {
            Either seg = Either.left((Object)text);
            segments.add(seg);
        }, emoji -> {
            Either seg = Either.right((Object)emoji);
            segments.add(seg);
        });
        return segments;
    }

    private void addParagraph(ReadOnlyStyledDocumentBuilder<ParagraphStyle, Either<String, CharSequence>, SegmentStyle> builder, String line, ParagraphStyle paragraphStyle, SegmentStyle style) {
        List<Either<String, CharSequence>> segments = line.isEmpty() ? List.of(emptySegment) : this.makeSegments(line);
        int len = segments.stream().map(arg_0 -> segmentOps.length(arg_0)).reduce(0, Integer::sum);
        builder.addParagraph(segments, StyleSpans.singleton((Object)style, (int)len), (Object)paragraphStyle);
    }

    private SegmentStyle getTextStyleForInsertion(int pos) {
        return switch (this.configuration.processDelimiter()) {
            default -> throw new MatchException(null, null);
            case RichStyledConfiguration.DelimiterProcessing.NONE, RichStyledConfiguration.DelimiterProcessing.DELETE_AND_RICH_REPLACE, RichStyledConfiguration.DelimiterProcessing.STYLE -> SegmentStyle.defaultStyle();
            case RichStyledConfiguration.DelimiterProcessing.TOGGLEABLE -> (SegmentStyle)super.getTextStyleForInsertionAt(pos);
        };
    }

    private ParagraphStyle getParagraphStyleForInsertion(int pos) {
        return switch (this.configuration.processDelimiter()) {
            default -> throw new MatchException(null, null);
            case RichStyledConfiguration.DelimiterProcessing.NONE, RichStyledConfiguration.DelimiterProcessing.DELETE_AND_RICH_REPLACE, RichStyledConfiguration.DelimiterProcessing.STYLE -> (ParagraphStyle)this.getInitialParagraphStyle();
            case RichStyledConfiguration.DelimiterProcessing.TOGGLEABLE -> (ParagraphStyle)super.getParagraphStyleForInsertionAt(pos);
        };
    }

    public void clear() {
        if (this.getLength() == 0) {
            return;
        }
        super.clear();
    }

    public void replaceText(String replacement) {
        ViewControllerHelper.checkUIThread();
        if (this.getPlainText().equals(replacement)) {
            return;
        }
        boolean useInitialStyleForInsertion = this.getUseInitialStyleForInsertion();
        this.setUseInitialStyleForInsertion(true);
        for (int p = 0; p < this.getParagraphs().size(); ++p) {
            Paragraph paragraph = this.getParagraph(p);
            if (paragraph.getParagraphStyle() == this.getInitialParagraphStyle()) continue;
            this.setParagraphStyle(p, (ParagraphStyle)this.getInitialParagraphStyle());
        }
        super.replaceText(replacement);
        this.setUseInitialStyleForInsertion(useInitialStyleForInsertion);
    }

    public void replaceText(int start, int end, String text) {
        ViewControllerHelper.checkUIThread();
        if (text == null || text.isEmpty()) {
            super.replaceText(start, end, "");
            return;
        }
        ParagraphStyle paragraphStyle = this.getParagraphStyleForInsertion(start);
        SegmentStyle segmentStyle = this.getTextStyleForInsertion(start);
        ReadOnlyStyledDocumentBuilder builder = new ReadOnlyStyledDocumentBuilder(segmentOps, null);
        Matcher m = StringUtils.LINE_TERMINATOR.matcher(text);
        int cur = 0;
        while (m.find()) {
            String line = text.substring(cur, m.start());
            this.addParagraph((ReadOnlyStyledDocumentBuilder<ParagraphStyle, Either<String, CharSequence>, SegmentStyle>)builder, line, paragraphStyle, segmentStyle);
            paragraphStyle = paragraphStyle.next();
            segmentStyle = SegmentStyle.defaultStyle();
            cur = m.end();
        }
        String last = text.substring(cur);
        this.addParagraph((ReadOnlyStyledDocumentBuilder<ParagraphStyle, Either<String, CharSequence>, SegmentStyle>)builder, last, paragraphStyle, segmentStyle);
        ReadOnlyStyledDocument document = builder.build();
        this.replace(start, end, (StyledDocument<ParagraphStyle, Either<String, CharSequence>, SegmentStyle>)document);
    }

    public void setEnableDetection(boolean enableDetection) {
        this.enableDetection = enableDetection;
    }

    public void replace(int start, int end, StyledDocument<ParagraphStyle, Either<String, CharSequence>, SegmentStyle> replacement) {
        ViewControllerHelper.checkUIThread();
        super.replace(start, end, replacement);
        if (this.configuration.shouldProcessMarkdown() || this.configuration.enableLinkDetection()) {
            this.applyMarkdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyMarkdown() {
        ViewControllerHelper.checkUIThread();
        if (!this.enableDetection) {
            return;
        }
        if (this.getLength() == 0) {
            return;
        }
        String text = this.getPlainText();
        MarkdownChangeBuilder changeBuilder = new MarkdownChangeBuilder(this);
        Watches.Watch watch1 = Watches.getInstance().start("RichStyledArea#visitMarkdown");
        try {
            MarkdownVisitor visitor = new MarkdownVisitor(changeBuilder);
            RichStyledArea.getParser().parse(text).accept((Visitor)visitor);
        }
        finally {
            watch1.stop();
        }
        Watches.Watch watch2 = Watches.getInstance().start("RichStyledArea#commitMarkdown");
        try {
            this.setEnableDetection(false);
            changeBuilder.commit();
            this.setEnableDetection(true);
        }
        catch (Exception e) {
            logger.error("Error while parsing markdown", e);
        }
        finally {
            watch2.stop();
        }
    }

    public String getSelectedText() {
        IndexRange selection = this.getSelection();
        StyledDocument doc = this.subDocument(selection);
        List paragraphs = doc.getParagraphs();
        return this.getText(paragraphs);
    }

    public String getPlainText() {
        return this.getText((List<Paragraph<ParagraphStyle, Either<String, CharSequence>, SegmentStyle>>)this.getParagraphs());
    }

    public StringBinding plainTextProperty() {
        return Bindings.createStringBinding(this::getPlainText, (Observable[])new Observable[]{this.textProperty(), this.lengthProperty()});
    }

    public String getText(List<Paragraph<ParagraphStyle, Either<String, CharSequence>, SegmentStyle>> paragraphs) {
        StringBuilder builder = new StringBuilder();
        Iterator<Paragraph<ParagraphStyle, Either<String, CharSequence>, SegmentStyle>> iterator = paragraphs.iterator();
        while (iterator.hasNext()) {
            Paragraph<ParagraphStyle, Either<String, CharSequence>, SegmentStyle> paragraph = iterator.next();
            for (Either segment : paragraph.getSegments()) {
                builder.append((String)segment.unify(String::toString, CharSequence::toString));
            }
            if (!iterator.hasNext()) continue;
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    public int getAbsolutePlainPosition(int paragraph, int column) {
        int pos = 0;
        for (int p = 0; p < paragraph; ++p) {
            List segments = this.getParagraph(p).getSegments();
            for (Either segment : segments) {
                pos += ((Integer)segment.unify(String::length, CharSequence::length)).intValue();
            }
            pos += System.lineSeparator().length();
        }
        return pos += column;
    }

    public void addStyle(int start, int end, Optional<SegmentStyle.Style> style, Optional<String> url) {
        StyleSpans updatedStyleSpans;
        if (start == end) {
            return;
        }
        StyleSpans styleSpans = this.getStyleSpans(start, end);
        if (styleSpans.equals((Object)(updatedStyleSpans = styleSpans.overlay(styleSpans, (oldStyle, newStyle) -> oldStyle.addStyle(style).setUrl(url))))) {
            return;
        }
        this.setStyleSpans(start, updatedStyleSpans);
    }

    public void removeStyle(int start, int end, Collection<Class<? extends SegmentStyle.Style>> styles, boolean removeUrl) {
        StyleSpans updatedStyleSpans;
        StyleSpans styleSpans = this.getStyleSpans(start, end);
        if (styleSpans.equals((Object)(updatedStyleSpans = styleSpans.overlay(styleSpans, (oldStyle, newStyle) -> {
            SegmentStyle style = oldStyle.removeStyles(styles);
            if (removeUrl) {
                style = style.clearUrl();
            }
            return style;
        })))) {
            return;
        }
        this.setStyleSpans(start, updatedStyleSpans);
    }

    public void removeAllStyles(int start, int end) {
        StyleSpans updatedStyleSpans;
        StyleSpans styleSpans = this.getStyleSpans(start, end);
        if (styleSpans.equals((Object)(updatedStyleSpans = styleSpans.overlay(styleSpans, (oldStyle, newStyle) -> SegmentStyle.defaultStyle())))) {
            return;
        }
        this.setStyleSpans(start, updatedStyleSpans);
    }

    public void setTextAlignment(TextAlignment textAlignment) {
        int size = this.getParagraphs().size();
        for (int p = 0; p < size; ++p) {
            Paragraph paragraph = this.getParagraph(p);
            ParagraphStyle paragraphStyle = (ParagraphStyle)paragraph.getParagraphStyle();
            this.setParagraphStyle(p, paragraphStyle.setTextAlignment(textAlignment));
        }
    }

    public void setClipboardDelegate(ClipboardDelegate clipboardDelegate) {
        this.clipboardDelegate = clipboardDelegate;
    }

    public void paste() {
        String text;
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (this.clipboardDelegate != null) {
            if (clipboard.hasContent(DataFormat.IMAGE)) {
                this.clipboardDelegate.importImage(clipboard.getImage());
            } else if (clipboard.hasContent(DataFormat.FILES)) {
                this.clipboardDelegate.importFiles(clipboard.getFiles());
            }
        }
        if (clipboard.hasString() && (text = clipboard.getString()) != null) {
            this.replaceSelection(text);
        }
    }

    public void recreateParagraphGraphic() {
        for (int p = 0; p < this.getParagraphs().size(); ++p) {
            this.recreateParagraphGraphic(p);
        }
    }

    public static class EmojiOps<S>
    extends NodeSegmentOpsBase<CharSequence, S> {
        public EmojiOps() {
            super((Object)"");
        }

        public int length(CharSequence s) {
            return s.isEmpty() ? 0 : 1;
        }
    }
}

