/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc.richtextfx;

import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.fx.misc.CollectionUtils;
import io.olvid.windows.messenger.fx.misc.richtextfx.RichStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.RichToolBarController;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.ParagraphStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.style.SegmentStyle;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.ActionableArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.BlocksInfo;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.ToggleableArea;
import io.olvid.windows.messenger.misc.StringUtils;
import io.olvid.windows.messenger.misc.cache.ApplicationSettingsDatabaseCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.util.UndoUtils;
import org.reactfx.SuspendableYes;
import org.reactfx.util.Either;

public class EditableStyledArea
extends RichStyledArea
implements ToggleableArea,
ActionableArea {
    private final SuspendableYes suspendUndo = new SuspendableYes();
    public final ObjectProperty<Mode> mode = new SimpleObjectProperty((Object)Mode.PLAIN);
    public RichToolBarController richToolBarController = null;
    private String paintTextCache = "";
    private final boolean debugGetTextWithDelimiter = false;

    public EditableStyledArea(RichStyledConfiguration configuration) {
        super(configuration);
        this.setEditable(true);
        ActionableArea.configure(this);
        this.setUndoManager(UndoUtils.richTextSuspendableUndoManager((GenericStyledArea)this, (SuspendableYes)this.suspendUndo));
        this.mode.set((Object)Mode.of(ApplicationSettingsDatabaseCache.getInstance().get(ApplicationSetting.GlobalAppSettings.RICH_TEXT_MODE)));
    }

    private void doUpdate(Runnable runnable) {
        this.suspendUndo.suspendWhile(runnable);
    }

    @Override
    public void setToolBarController(RichToolBarController controller) {
        this.richToolBarController = controller;
    }

    @Override
    public ObjectProperty<Mode> modeProperty() {
        return this.mode;
    }

    @Override
    public Mode getMode() {
        return (Mode)((Object)this.mode.get());
    }

    public void clearWithoutDetections() {
        this.setEnableDetection(false);
        super.clear();
        this.clearStyles();
        this.getUndoManager().forgetHistory();
        this.updateToolbar();
        this.setEnableDetection(true);
    }

    private StringTriple split(Either<String, CharSequence> segment) {
        int start;
        int end;
        if (segment.isRight()) {
            return new StringTriple("", (CharSequence)segment.getRight(), "");
        }
        String text = (String)segment.getLeft();
        char[] chars = text.toCharArray();
        for (end = chars.length - 1; end > 0 && Character.isWhitespace(chars[end]); --end) {
        }
        for (start = 0; start < end && Character.isWhitespace(chars[start]); ++start) {
        }
        return new StringTriple(text.substring(0, start), text.substring(start, end + 1), text.substring(end + 1));
    }

    private void debug(SegmentStyle.Style style, boolean open) {
    }

    private void debug(StyledSegment<Either<String, CharSequence>, SegmentStyle> styledSegment, List<SegmentStyle.Style> currentStylesQueue) {
    }

    public String getTextWithDelimiter() {
        if (!this.configuration.processDelimiter().isDelete()) {
            return this.getPlainText();
        }
        if (this.getUndoManager().isAtMarkedPosition() && this.paintTextCache != null) {
            return this.paintTextCache;
        }
        StringBuilder builder = new StringBuilder();
        BlocksInfo blocksInfo = new BlocksInfo(this);
        for (int p = 0; p < this.getParagraphs().size(); ++p) {
            LinkedList<SegmentStyle.Style> currentStylesQueue = new LinkedList<SegmentStyle.Style>();
            Paragraph paragraph = this.getParagraph(p);
            List<BlocksInfo.Info> infos = blocksInfo.getBlockInfos(p);
            Optional<BlocksInfo.CodeInfo> codeInfo = infos.stream().filter(BlocksInfo.CodeInfo.class::isInstance).map(BlocksInfo.CodeInfo.class::cast).findAny();
            for (BlocksInfo.Info info : infos) {
                builder.append(info.delimiter());
            }
            if (codeInfo.isPresent() && codeInfo.get().first()) {
                builder.append(codeInfo.get().code().delimiter(true));
                builder.append(System.lineSeparator());
                for (BlocksInfo.Info info : infos) {
                    builder.append(info.hiddenDelimiter());
                }
            } else {
                ParagraphStyle.Heading heading = ((ParagraphStyle)paragraph.getParagraphStyle()).heading;
                if (heading != ParagraphStyle.Heading.BODY) {
                    builder.append(heading.delimiter());
                }
            }
            StringBuilder spaces = new StringBuilder();
            for (StyledSegment styledSegment : paragraph.getStyledSegments()) {
                Either segment = (Either)styledSegment.getSegment();
                SegmentStyle style = (SegmentStyle)styledSegment.getStyle();
                StringTriple triple = this.split((Either<String, CharSequence>)segment);
                boolean inlineCode = style.contains(SegmentStyle.Style.InlineCode.class);
                if (!inlineCode && triple.isEmpty()) {
                    spaces.append((String)segment.unify(String::toString, CharSequence::toString));
                    continue;
                }
                this.debug((StyledSegment<Either<String, CharSequence>, SegmentStyle>)styledSegment, currentStylesQueue);
                HashSet<SegmentStyle.Style> toClose = new HashSet<SegmentStyle.Style>(currentStylesQueue);
                style.styles().forEach(toClose::remove);
                while (CollectionUtils.containsAny(currentStylesQueue, toClose)) {
                    SegmentStyle.Style last = currentStylesQueue.removeLast();
                    this.debug(last, false);
                    builder.append(last.delimiter(false));
                }
                if (!inlineCode) {
                    spaces.append(triple.before);
                }
                ArrayList<SegmentStyle.Style> reversedStyles = new ArrayList<SegmentStyle.Style>(style.styles());
                Collections.reverse(reversedStyles);
                if (!reversedStyles.isEmpty()) {
                    builder.append((CharSequence)spaces);
                    spaces.delete(0, spaces.length());
                }
                for (SegmentStyle.Style s : reversedStyles) {
                    if (currentStylesQueue.contains(s)) continue;
                    this.debug(s, true);
                    currentStylesQueue.add(s);
                    builder.append(s.delimiter(true));
                }
                if (inlineCode) {
                    builder.append(triple.before);
                } else {
                    builder.append((CharSequence)spaces);
                    spaces.delete(0, spaces.length());
                }
                builder.append(triple.text);
                if (inlineCode) {
                    builder.append(triple.after);
                    continue;
                }
                spaces.append(triple.after);
            }
            if (this.configuration.processDelimiter().isDelete()) {
                while (!currentStylesQueue.isEmpty()) {
                    SegmentStyle.Style style = (SegmentStyle.Style)currentStylesQueue.removeLast();
                    this.debug(style, false);
                    builder.append(style.delimiter(false));
                }
                builder.append((CharSequence)spaces);
                spaces.delete(0, spaces.length());
                if (codeInfo.isPresent() && codeInfo.get().last()) {
                    builder.append(System.lineSeparator());
                    for (BlocksInfo.Info info : infos) {
                        builder.append(info.hiddenDelimiter());
                    }
                    builder.append(codeInfo.get().code().delimiter(false));
                }
            }
            if (p >= this.getParagraphs().size() - 1) continue;
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    @Override
    public void replace(int start, int end, StyledDocument<ParagraphStyle, Either<String, CharSequence>, SegmentStyle> replacement) {
        RichStyledConfiguration.DelimiterProcessing delimiterProcessing = this.configuration.processDelimiter();
        switch (delimiterProcessing) {
            case NONE: 
            case DELETE_AND_RICH_REPLACE: {
                break;
            }
            case TOGGLEABLE: {
                this.setTextInsertionStyle(null);
                break;
            }
            case STYLE: {
                this.clearStyles();
            }
        }
        super.replace(start, end, replacement);
        if (this.configuration.processDelimiter() == RichStyledConfiguration.DelimiterProcessing.TOGGLEABLE) {
            this.doUpdate(this::restyleParagraphs);
        }
    }

    @Override
    public void replaceText(int start, int end, String text) {
        RichStyledConfiguration.DelimiterProcessing delimiterProcessing = this.configuration.processDelimiter();
        switch (delimiterProcessing) {
            case NONE: 
            case DELETE_AND_RICH_REPLACE: {
                break;
            }
            case TOGGLEABLE: {
                this.clearLinkStyle();
                break;
            }
            case STYLE: {
                this.clearStyles();
            }
        }
        super.replaceText(start, end, text);
    }

    @Override
    public void clearLinkStyle() {
        this.doUpdate(() -> this.removeStyle(0, this.getLength(), List.of(SegmentStyle.Style.Underline.class), true));
    }

    private void clearStyles() {
        this.doUpdate(() -> {
            this.removeAllStyles(0, this.getLength());
            for (int p = 0; p < this.getParagraphs().size(); ++p) {
                Paragraph paragraph = this.getParagraph(p);
                if (paragraph.getParagraphStyle() == this.getInitialParagraphStyle()) continue;
                this.setParagraphStyle(p, (ParagraphStyle)this.getInitialParagraphStyle());
            }
        });
    }

    @Override
    public void applyMarkdown() {
        this.doUpdate(() -> {
            super.applyMarkdown();
            this.updateToolbar();
        });
    }

    @Override
    public void switchMode() {
        Mode currentMode = (Mode)((Object)this.mode.get());
        switch (currentMode.ordinal()) {
            case 0: {
                this.paintTextCache = this.getPlainText();
                this.mode.set((Object)Mode.PLAIN_TO_RICH);
                this.clearStyles();
                this.applyMarkdown();
                this.mode.set((Object)Mode.RICH);
                this.getUndoManager().mark();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                String text = this.getTextWithDelimiter();
                this.paintTextCache = null;
                this.mode.set((Object)Mode.PLAIN);
                this.replaceText(text);
            }
        }
        this.updateToolbar();
        this.requestFocus();
        this.getUndoManager().forgetHistory();
        ApplicationSettingsDatabaseCache.getInstance().set(ApplicationSetting.GlobalAppSettings.RICH_TEXT_MODE, ((Mode)((Object)this.mode.get())).name());
    }

    public void setText(String text) {
        switch (((Mode)((Object)this.mode.get())).ordinal()) {
            case 0: {
                this.replaceText(text);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.mode.set((Object)Mode.PLAIN_TO_RICH);
                this.replaceText(text);
                this.mode.set((Object)Mode.RICH);
            }
        }
        this.paintTextCache = null;
        this.getUndoManager().forgetHistory();
        this.requestFocus();
        this.updateToolbar();
    }

    protected void restyleParagraphs() {
        this.doUpdate(() -> {
            for (int p = 0; p < this.getParagraphs().size(); ++p) {
                Paragraph paragraph = this.getParagraph(p);
                this.setParagraphStyle(p, ((ParagraphStyle)paragraph.getParagraphStyle()).copy());
            }
        });
    }

    @Override
    public void updateParagraphs() {
        this.restyleParagraphs();
        this.recreateParagraphGraphic();
        this.updateToolbar();
    }

    @Override
    public void setParagraphStyleAndUpdate(int paragraph, ParagraphStyle paragraphStyle) {
        super.setParagraphStyle(paragraph, (Object)paragraphStyle);
        this.updateParagraphs();
    }

    public void updateToolbar() {
        if (this.richToolBarController == null) {
            return;
        }
        this.richToolBarController.update();
    }

    public void undo() {
        super.undo();
        switch (((Mode)((Object)this.mode.get())).ordinal()) {
            case 0: {
                this.clearStyles();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.clearLinkStyle();
            }
        }
        this.applyMarkdown();
    }

    public void redo() {
        super.redo();
        switch (((Mode)((Object)this.mode.get())).ordinal()) {
            case 0: {
                this.clearStyles();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.clearLinkStyle();
            }
        }
        this.applyMarkdown();
    }

    public static enum Mode {
        PLAIN,
        PLAIN_TO_RICH,
        RICH;


        static Mode of(String s) {
            if (s == null) {
                return PLAIN;
            }
            return switch (s) {
                case "PLAIN" -> PLAIN;
                case "RICH" -> RICH;
                default -> {
                    RichStyledArea.logger.error("Found invalid rich text mode in settings");
                    yield PLAIN;
                }
            };
        }
    }

    record StringTriple(String before, CharSequence text, String after) {
        boolean isEmpty() {
            return StringUtils.isEmpty(this.before) && StringUtils.isEmpty(String.valueOf(this.text)) && StringUtils.isEmpty(this.after);
        }
    }
}

