/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc;

import io.olvid.windows.messenger.logger.AppLogger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executor;
import javafx.animation.AnimationTimer;
import org.jetbrains.annotations.NotNull;

public class UIUpdater
implements Executor {
    final Queue<Runnable> updateTasks = new LinkedList<Runnable>();
    final AnimationTimer animationTimer = new AnimationTimer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(long now) {
            ArrayList<Runnable> tmp;
            AppLogger.t("UIUpdater::handle");
            Queue<Runnable> queue = UIUpdater.this.updateTasks;
            synchronized (queue) {
                tmp = new ArrayList<Runnable>(UIUpdater.this.updateTasks);
                UIUpdater.this.updateTasks.clear();
            }
            for (Runnable task : tmp) {
                try {
                    task.run();
                }
                catch (Exception e) {
                    AppLogger.e("Something went wrong while performing UI update....", e);
                }
            }
            queue = UIUpdater.this.updateTasks;
            synchronized (queue) {
                if (UIUpdater.this.updateTasks.isEmpty()) {
                    this.stop();
                }
            }
            AppLogger.t("UIUpdater::end");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable task) {
        Queue<Runnable> queue = this.updateTasks;
        synchronized (queue) {
            this.updateTasks.add(task);
            this.animationTimer.start();
        }
    }

    @Override
    public void execute(@NotNull Runnable command) {
        this.addTask(command);
    }
}

