/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc;

import io.olvid.windows.messenger.fx.misc.textflow.EmojiTextFlow;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.Watches;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public abstract class TitleAndSubtitle
extends BorderPane {
    public final VBox centerVBox = new VBox();
    public final VBox rightVBox = new VBox();
    public final Label title;
    public final Either<EmojiTextFlow, Label> subtitle;

    public TitleAndSubtitle() {
        this.centerVBox.setId("CenterVBox");
        this.title = new Label();
        this.title.getStyleClass().add((Object)"h2");
        this.title.prefHeightProperty().bind((ObservableValue)this.title.maxHeightProperty());
        this.title.maxHeightProperty().bind((ObservableValue)new SimpleLongProperty(25L));
        Watches.Watch watch = Watches.getInstance().start(((Object)((Object)this)).getClass().getSimpleName() + "#makeSubtitle");
        this.subtitle = this.makeSubtitle();
        watch.stop();
        this.centerVBox.setAlignment(Pos.CENTER_LEFT);
        this.setCenter((Node)this.centerVBox);
        this.centerVBox.getChildren().add((Object)this.title);
        if (this.subtitle.isLeft()) {
            EmojiTextFlow emojiTextFlow = this.subtitle.getLeft();
            emojiTextFlow.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
            emojiTextFlow.setMouseTransparent(true);
            this.centerVBox.getChildren().add((Object)emojiTextFlow);
        } else {
            Label label = this.subtitle.getRight();
            label.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
            label.setMouseTransparent(true);
            this.centerVBox.getChildren().add((Object)label);
        }
        this.getSubtitleStyleClass().add((Object)"body-2");
        this.subtitleManagedProperty().bind((ObservableValue)this.subtitleVisibleProperty());
        this.rightVBox.setId("rightVBox");
        this.rightVBox.setAlignment(Pos.CENTER_RIGHT);
        BorderPane.setAlignment((Node)this.rightVBox, (Pos)Pos.CENTER_RIGHT);
        this.setRight((Node)this.rightVBox);
    }

    protected Either<EmojiTextFlow, Label> makeSubtitle() {
        return Either.left(new EmojiTextFlow());
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public void setSubtitle(String subtitle) {
        if (this.subtitle.isLeft()) {
            this.subtitle.getLeft().replaceText(subtitle);
        } else {
            this.subtitle.getRight().setText(subtitle);
        }
    }

    public void setSubtitle(Optional<String> subtitle) {
        this.setSubtitle(subtitle.orElse(""));
    }

    public ObservableList<String> getSubtitleStyleClass() {
        if (this.subtitle.isLeft()) {
            return this.subtitle.getLeft().getStyleClass();
        }
        return this.subtitle.getRight().getStyleClass();
    }

    public void getSubtitleVisible(boolean value) {
        if (this.subtitle.isLeft()) {
            this.subtitle.getLeft().setVisible(value);
        } else {
            this.subtitle.getRight().setVisible(value);
        }
    }

    public void clearSubtitle() {
        if (this.subtitle.isLeft()) {
            this.subtitle.getLeft().clear();
        } else {
            this.subtitle.getRight().setText("");
        }
    }

    public BooleanProperty subtitleManagedProperty() {
        if (this.subtitle.isLeft()) {
            return this.subtitle.getLeft().managedProperty();
        }
        return this.subtitle.getRight().managedProperty();
    }

    public BooleanProperty subtitleVisibleProperty() {
        if (this.subtitle.isLeft()) {
            return this.subtitle.getLeft().visibleProperty();
        }
        return this.subtitle.getRight().visibleProperty();
    }

    public ReadOnlyDoubleProperty subtitleHeightProperty() {
        if (this.subtitle.isLeft()) {
            return this.subtitle.getLeft().heightProperty();
        }
        return this.subtitle.getRight().heightProperty();
    }

    public DoubleProperty subtitleMaxWidthProperty() {
        if (this.subtitle.isLeft()) {
            return this.subtitle.getLeft().maxWidthProperty();
        }
        return this.subtitle.getRight().maxWidthProperty();
    }

    public void setSubtitlePrefWidth(double value) {
        if (this.subtitle.isLeft()) {
            this.subtitle.getLeft().setPrefWidth(value);
        } else {
            this.subtitle.getRight().setPrefWidth(value);
        }
    }

    public void setSubtitleMaxWidth(double value) {
        if (this.subtitle.isLeft()) {
            this.subtitle.getLeft().setMaxWidth(value);
        } else {
            this.subtitle.getRight().setMaxWidth(value);
        }
    }
}

