/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public final class OptionalUtils {
    private OptionalUtils() {
    }

    public static Optional<Long> longMin(Optional<Long> left, Optional<Long> right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        return Optional.of(Math.min(left.get(), right.get()));
    }

    public static Optional<Double> doubleMin(Optional<Double> left, Optional<Double> right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        return Optional.of(Math.min(left.get(), right.get()));
    }

    public static Optional<Double> doubleMax(Optional<Double> left, Optional<Double> right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        return Optional.of(Math.max(left.get(), right.get()));
    }

    public static Optional<String> join(String separator, List<Optional<String>> elems) {
        List<String> strings = elems.stream().filter(Optional::isPresent).map(Optional::get).toList();
        if (strings.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)separator, strings));
    }

    public static Optional<String> noneIfEmpty(String s) {
        if (s == null || s.isEmpty() || s.trim().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(s);
    }

    public static boolean equals(Optional<byte[]> left, Optional<byte[]> right) {
        if (left.isEmpty() && right.isEmpty()) {
            return true;
        }
        if (left.isPresent() && right.isPresent()) {
            return Arrays.equals(left.get(), right.get());
        }
        return false;
    }

    public static final class OptionalComparator<T>
    implements Comparator<Optional<T>> {
        private final Comparator<T> comparator;
        private final EmptyOrder emptyOrder;

        private OptionalComparator(Comparator<T> comparator, EmptyOrder emptyOrder) {
            this.comparator = comparator;
            this.emptyOrder = emptyOrder;
        }

        public static <T> OptionalComparator<T> of(Comparator<T> comparator, EmptyOrder emptyOrder) {
            return new OptionalComparator<T>(comparator, emptyOrder);
        }

        public static <T extends Comparable<T>> OptionalComparator<T> of(EmptyOrder emptyOrder) {
            return new OptionalComparator<T>(Comparable::compareTo, emptyOrder);
        }

        public static <T, U extends Comparable<U>> Comparator<T> of(Function<T, Optional<U>> keyExtractor, EmptyOrder emptyOrder) {
            OptionalComparator uComparator = OptionalComparator.of(emptyOrder);
            return (o1, o2) -> uComparator.compare((Optional)keyExtractor.apply(o1), (Optional)keyExtractor.apply(o2));
        }

        @Override
        public int compare(Optional<T> obj1, Optional<T> obj2) {
            if (obj1.isPresent() && obj2.isPresent()) {
                return this.comparator.compare(obj1.get(), obj2.get());
            }
            if (obj1.isPresent()) {
                return this.emptyOrder.order;
            }
            if (obj2.isPresent()) {
                return -this.emptyOrder.order;
            }
            return 0;
        }

        public static enum EmptyOrder {
            EMPTY_FIRST(-1),
            EMPTY_LAST(1);

            final int order;

            private EmptyOrder(int order) {
                this.order = order;
            }
        }
    }
}

