/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;

public class OpenGraph {
    private String siteName;
    private String title;
    private String description;
    private String url;
    private String type;
    private String imageUrl;
    private byte[] imageBytes;

    public OpenGraph() {
    }

    public OpenGraph(String title, String description, String url, String imageUrl, byte[] imageBytes) {
        this.title = title;
        this.description = description;
        this.url = url;
        this.imageUrl = imageUrl;
        this.imageBytes = imageBytes;
    }

    public static OpenGraph emptyOpenGraph() {
        return new OpenGraph(null, null, null, null, null);
    }

    public static OpenGraph of(Encoded encoded) {
        OpenGraph openGraph = new OpenGraph();
        try {
            Encoded encodedImage;
            Encoded encodedSite;
            Encoded encodedDescription;
            HashMap dictionary = encoded.decodeDictionary();
            Encoded encodedTitle = (Encoded)dictionary.get(new DictionaryKey("title"));
            if (encodedTitle != null) {
                openGraph.setTitle(encodedTitle.decodeString());
            }
            if ((encodedDescription = (Encoded)dictionary.get(new DictionaryKey("desc"))) != null) {
                openGraph.setDescription(encodedDescription.decodeString());
            }
            if ((encodedSite = (Encoded)dictionary.get(new DictionaryKey("url"))) != null) {
                openGraph.setUrl(encodedSite.decodeString());
            }
            if ((encodedImage = (Encoded)dictionary.get(new DictionaryKey("image"))) != null) {
                openGraph.setImageBytes(encodedImage.decodeBytes());
            }
        }
        catch (DecodingException decodingException) {
            AppLogger.w("Unable to decode OpenGraph");
        }
        return openGraph;
    }

    public boolean isEmpty() {
        return !(this.title != null && !this.title.isEmpty() || this.description != null && !this.description.isEmpty() || this.imageBytes != null);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public void setImageBytes(byte[] imageBytes) {
        this.imageBytes = imageBytes;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenGraph openGraph = (OpenGraph)o;
        return Objects.equals(this.siteName, openGraph.siteName) && Objects.equals(this.title, openGraph.title) && Objects.equals(this.description, openGraph.description) && Objects.equals(this.url, openGraph.url) && Objects.equals(this.type, openGraph.type) && Objects.equals(this.imageUrl, openGraph.imageUrl) && Arrays.equals(this.imageBytes, openGraph.imageBytes);
    }

    public int hashCode() {
        int result = Objects.hash(this.siteName, this.title, this.description, this.url, this.type, this.imageUrl);
        result = 31 * result + Arrays.hashCode(this.imageBytes);
        return result;
    }

    public String toString() {
        return "OpenGraph{siteName='" + this.siteName + "', title='" + this.title + "', description='" + this.description + "', url='" + this.url + "', type='" + this.type + "', image='" + this.imageUrl + "', imageBytes length: " + (this.imageBytes == null ? 0 : this.imageBytes.length) + "}";
    }
}

