/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.AbstractTreeIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.SelectionPath;

public final class NodeUtils {
    private NodeUtils() {
    }

    public static <T> Optional<T> getFirstParentOfType(Node node, Class<T> type) {
        if (node == null) {
            return Optional.empty();
        }
        Parent parent = node.getParent();
        if (parent == null) {
            return Optional.empty();
        }
        if (type.isAssignableFrom(parent.getClass())) {
            return Optional.of(type.cast(parent));
        }
        return NodeUtils.getFirstParentOfType((Node)parent, type);
    }

    public static Optional<Node> getFirstParentById(Node node, String id) {
        if (node == null) {
            return Optional.empty();
        }
        if (Objects.equals(node.getId(), id)) {
            return Optional.of(node);
        }
        return NodeUtils.getFirstParentById((Node)node.getParent(), id);
    }

    private static String text(String s) {
        if (s == null) {
            return "null";
        }
        return s.replaceAll("\\R", " ");
    }

    public static boolean printNodeInfo(Node node, int indent) {
        boolean printChildren = node.isVisible();
        StringBuilder builder = new StringBuilder();
        if (node.isManaged()) {
            builder.append("M");
        } else {
            builder.append("-");
        }
        if (node.isVisible()) {
            builder.append("V");
        } else {
            builder.append("-");
        }
        builder.append("  ".repeat(indent + 1));
        builder.append(node.getClass().getSimpleName());
        if (node.getId() != null) {
            builder.append(":").append(node.getId());
        }
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            builder.append(String.format("[%s]", parent.getChildrenUnmodifiable().size()));
        }
        builder.append(String.format(" [x:%s y:%s]", node.getLayoutX(), node.getLayoutY()));
        if (node instanceof Region) {
            Insets margin;
            Region region = (Region)node;
            Insets insets = region.getInsets();
            if (insets != null && !Insets.EMPTY.equals((Object)insets)) {
                builder.append(String.format(" [i:%s/%s/%s/%s]", insets.getTop(), insets.getRight(), insets.getBottom(), insets.getLeft()));
            }
            if ((margin = VBox.getMargin((Node)node)) != null && !Insets.EMPTY.equals((Object)margin)) {
                builder.append(String.format(" [m:%s/%s/%s/%s]", margin.getTop(), margin.getRight(), margin.getBottom(), margin.getLeft()));
            }
            builder.append(String.format(" [w:%s %s/%s/%s h:%s %s/%s/%s]", region.getWidth(), region.getMinWidth(), region.getPrefWidth(), region.getMaxWidth(), region.getHeight(), region.getMinHeight(), region.getPrefHeight(), region.getMaxHeight()));
            if (!region.getStyleClass().isEmpty()) {
                builder.append(" style:").append(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)region.getStyleClass()));
            }
        }
        if (node instanceof VBox) {
            VBox vBox = (VBox)node;
            builder.append(String.format(" [%s/%s]", vBox.getAlignment(), vBox.getSpacing()));
        }
        if (node instanceof HBox) {
            HBox hBox = (HBox)node;
            builder.append(String.format(" [%s/%s]", hBox.getAlignment(), hBox.getSpacing()));
        }
        if (node instanceof Label) {
            Label label = (Label)node;
            builder.append(" text:").append(NodeUtils.text(label.getText()));
            printChildren = false;
        }
        if (node instanceof Text) {
            Text text = (Text)node;
            builder.append(" text:").append(text.toString().replaceAll("\n", "|n"));
            builder.append(" style:").append(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)text.getStyleClass()));
            builder.append(" bounds:").append(text.getLayoutBounds());
        }
        if (node instanceof SvgSizeable) {
            SvgSizeable svgSizeable = (SvgSizeable)node;
            builder.append(' ').append(svgSizeable.getStyleClass());
            builder.append(String.format(" [w:%s h:%s]", svgSizeable.getWidth(), svgSizeable.getHeight()));
            printChildren = false;
        }
        if (node instanceof GenericStyledArea) {
            GenericStyledArea styledArea = (GenericStyledArea)node;
            builder.append(' ').append(styledArea.getParagraphs());
        }
        if (node instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)node;
            builder.append(String.format(" [w:%s h:%s]", rectangle.getWidth(), rectangle.getHeight()));
        }
        if (node instanceof TextFlow) {
            printChildren = true;
        }
        if (node instanceof ImageView) {
            ImageView i = (ImageView)node;
            builder.append(String.format(" [w:%s h:%s]", i.getFitWidth(), i.getFitHeight()));
        }
        if (node instanceof SelectionPath) {
            SelectionPath selectionPath = (SelectionPath)node;
            builder.append(" ").append(selectionPath.getStyleClass());
        }
        AppLogger.t(builder.toString());
        System.out.println(builder.toString());
        return printChildren;
    }

    private static void printNodesHierarchy(List<Node> nodes, int indent) {
        for (Node node : nodes) {
            NodeUtils.printNodeHierarchy(node, indent);
        }
    }

    private static void printNodeHierarchy(Node node, int indent) {
        boolean printChildren = NodeUtils.printNodeInfo(node, indent);
        if (printChildren && node instanceof Parent) {
            Parent parent = (Parent)node;
            NodeUtils.printNodesHierarchy((List<Node>)parent.getChildrenUnmodifiable(), indent + 1);
        }
    }

    public static void colorNodeHierarchy(Node node) {
        NodeUtils.colorNodeHierachy(node, 0, 0.3);
    }

    private static void colorNodeHierachy(Node node, int hue, double brightness) {
        String color = Color.hsb((double)hue, (double)1.0, (double)brightness).toString().substring(2);
        node.setStyle(String.format("-fx-background-color: #%s; -fx-fill-color: #%s;", color, color));
        hue += 100;
        brightness = brightness * 0.8 + 0.2;
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            for (Node child : parent.getChildrenUnmodifiable()) {
                NodeUtils.colorNodeHierachy(child, hue, brightness);
                hue += 20;
            }
        }
    }

    public static void printNodeHierarchy(Node node) {
        NodeUtils.printNodeHierarchy(node, 0);
    }

    public static final class NodeIterator
    extends AbstractTreeIterator<Node> {
        public NodeIterator(Node root) {
            super(root);
        }

        @Override
        protected Iterator<Node> getChildren(Node element) {
            if (element instanceof Parent) {
                Parent parent = (Parent)element;
                return parent.getChildrenUnmodifiable().iterator();
            }
            return Collections.emptyIterator();
        }
    }
}

