/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc;

import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;

public class MessageStatusView
extends StackPane {
    private final String sizeClass;
    private final double translate;
    private final SvgSizeable icon1 = new SvgSizeable();
    private final SvgSizeable icon2 = new SvgSizeable();
    private final SvgSizeable icon3 = new SvgSizeable();

    public MessageStatusView(String sizeClass, double translate) {
        this.sizeClass = sizeClass;
        this.translate = translate;
        this.getChildren().addAll((Object[])new Node[]{this.icon1, this.icon2, this.icon3});
        this.icon3.setTranslateX(-translate);
    }

    private String icon1(Icon icon) {
        return switch (icon.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> throw new IllegalStateException();
            case 1 -> "svg-hare";
            case 2 -> "svg-checked";
            case 3 -> "svg-sent-from-other-device";
            case 4, 5 -> "svg-circle";
            case 6, 7, 8 -> "svg-filled-circle";
            case 9 -> "svg-trash1";
            case 10 -> "svg-edit";
            case 11 -> "svg-clock";
            case 12 -> "svg-timer-2";
            case 13 -> "svg-download";
        };
    }

    private Size size1(Icon icon) {
        return switch (icon.ordinal()) {
            case 0 -> throw new IllegalStateException();
            case 1 -> Size.WIDE;
            case 3 -> Size.XSMALL;
            case 10 -> Size.XXXSMALL;
            default -> Size.NORMAL;
        };
    }

    private Optional<String> icon2(Icon icon) {
        return switch (icon.ordinal()) {
            case 0 -> throw new IllegalStateException();
            case 4, 5, 6, 7, 8 -> Optional.of("svg-inner-checked");
            default -> Optional.empty();
        };
    }

    private Size size2(Icon icon) {
        return switch (icon.ordinal()) {
            case 0 -> throw new IllegalStateException();
            case 1 -> Size.WIDE;
            default -> Size.NORMAL;
        };
    }

    private Color color2(Icon icon) {
        return switch (icon.ordinal()) {
            case 0 -> throw new IllegalStateException();
            case 4, 5 -> Color.GREY;
            default -> Color.WHITE;
        };
    }

    private Optional<String> icon3(Icon icon) {
        return switch (icon.ordinal()) {
            case 0 -> throw new IllegalStateException();
            case 5, 7 -> Optional.of("svg-circle-checked-secondary");
            case 8 -> Optional.of("svg-fill-checked-secondary");
            default -> Optional.empty();
        };
    }

    public void update(Icon status) {
        if (status == Icon.NONE) {
            ViewControllerHelper.hideNode((Node)this.icon1);
            ViewControllerHelper.hideNode((Node)this.icon2);
            ViewControllerHelper.hideNode((Node)this.icon3);
            return;
        }
        this.icon1.getStyleClass().setAll((Object[])new String[]{this.icon1(status), "icon-grey", this.size1(status).get(this.sizeClass)});
        ViewControllerHelper.showNode((Node)this.icon1);
        Optional<String> s2 = this.icon2(status);
        if (s2.isPresent()) {
            this.icon2.getStyleClass().setAll((Object[])new String[]{s2.get(), this.color2(status).get(), this.size2(status).get(this.sizeClass)});
            ViewControllerHelper.showNode((Node)this.icon2);
        } else {
            ViewControllerHelper.hideNode((Node)this.icon2);
        }
        Optional<String> s3 = this.icon3(status);
        if (s3.isPresent()) {
            this.icon1.setTranslateX(this.translate);
            this.icon2.setTranslateX(this.translate);
            this.icon3.getStyleClass().setAll((Object[])new String[]{s3.get(), "icon-grey", this.sizeClass + "-wide"});
            ViewControllerHelper.showNode((Node)this.icon3);
        } else {
            this.icon1.setTranslateX(0.0);
            this.icon2.setTranslateX(0.0);
            ViewControllerHelper.hideNode((Node)this.icon3);
        }
    }

    public void update(OutboundMessageGenerated.Status status) {
        this.update(MessageStatusView.getIcon(status));
    }

    public static Icon getIcon(OutboundMessageGenerated.Status status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case OutboundMessageGenerated.Status.FAILED, OutboundMessageGenerated.Status.UNDELIVERED, OutboundMessageGenerated.Status.NO_CONTACT_RECIPIENTS, OutboundMessageGenerated.Status.DRAFT -> Icon.NONE;
            case OutboundMessageGenerated.Status.UNPROCESSED, OutboundMessageGenerated.Status.PROCESSING -> Icon.PROCESSING;
            case OutboundMessageGenerated.Status.SENT -> Icon.SENT;
            case OutboundMessageGenerated.Status.DELIVERED, OutboundMessageGenerated.Status.PARTIALLY_DELIVERED_NOT_READ -> Icon.DELIVERED_TO_ONE;
            case OutboundMessageGenerated.Status.DELIVERED_AND_READ, OutboundMessageGenerated.Status.PARTIALLY_DELIVERED_PARTIALLY_READ -> Icon.READ_BY_ONE;
            case OutboundMessageGenerated.Status.FULLY_DELIVERED_NOT_READ -> Icon.DELIVERED_TO_ALL;
            case OutboundMessageGenerated.Status.FULLY_DELIVERED_PARTIALLY_READ -> Icon.READ_PARTIALLY;
            case OutboundMessageGenerated.Status.FULLY_DELIVERED_FULLY_READ -> Icon.READ_BY_ALL;
        };
    }

    public static String getDescription(OutboundMessageGenerated.Status status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case OutboundMessageGenerated.Status.FAILED, OutboundMessageGenerated.Status.UNDELIVERED, OutboundMessageGenerated.Status.NO_CONTACT_RECIPIENTS, OutboundMessageGenerated.Status.DRAFT, OutboundMessageGenerated.Status.UNPROCESSED -> null;
            case OutboundMessageGenerated.Status.PROCESSING -> ViewControllerHelper.getString("processing");
            case OutboundMessageGenerated.Status.SENT -> ViewControllerHelper.getString("sent");
            case OutboundMessageGenerated.Status.DELIVERED -> ViewControllerHelper.getString("delivered");
            case OutboundMessageGenerated.Status.PARTIALLY_DELIVERED_NOT_READ -> ViewControllerHelper.getString("partially_delivered_not_read");
            case OutboundMessageGenerated.Status.DELIVERED_AND_READ -> ViewControllerHelper.getString("delivered_and_read");
            case OutboundMessageGenerated.Status.PARTIALLY_DELIVERED_PARTIALLY_READ -> ViewControllerHelper.getString("partially_delivered_partially_read");
            case OutboundMessageGenerated.Status.FULLY_DELIVERED_NOT_READ -> ViewControllerHelper.getString("fully_delivered_not_read");
            case OutboundMessageGenerated.Status.FULLY_DELIVERED_PARTIALLY_READ -> ViewControllerHelper.getString("fully_delivered_partially_read");
            case OutboundMessageGenerated.Status.FULLY_DELIVERED_FULLY_READ -> ViewControllerHelper.getString("fully_delivered_fully_read");
        };
    }

    public static enum Icon {
        NONE,
        PROCESSING,
        SENT,
        SENT_FROM_OTHER_DEVICE,
        DELIVERED_TO_ONE,
        DELIVERED_TO_ALL,
        READ_BY_ONE,
        READ_PARTIALLY,
        READ_BY_ALL,
        DELETED,
        EDITED,
        WIPED,
        PENDING,
        DOWNLOADABLE;

    }

    private static enum Size {
        NORMAL,
        WIDE,
        XSMALL,
        XXXSMALL;


        String get(String sizeClass) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> sizeClass;
                case 1 -> "icon-wide";
                case 2 -> "icon-xsmall";
                case 3 -> "icon-xxxsmall";
            };
        }
    }

    private static enum Color {
        WHITE,
        GREY;


        String get() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "icon-white";
                case 1 -> "icon-grey";
            };
        }
    }
}

