/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.misc;

import io.olvid.engine.Logger;
import io.olvid.windows.messenger.misc.GeneratedNotoEmojisConverter;
import io.olvid.windows.messenger.misc.Watches;
import io.olvid.windows.messenger.misc.cache.LruCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public final class EmojiHelper
extends GeneratedNotoEmojisConverter {
    public static final CharTree emojiTree = new CharTree();
    private static LruCache<EmojiKey, Image> emojiCache = new LruCache(50L);

    public static String getEmojiFileName(String emoji, EmojiSize size) {
        String filename = (String)emojiNotoConverter.get(emoji);
        if (filename == null) {
            return null;
        }
        return String.format("/images/noto-emoji/%d/%s", size.size, filename);
    }

    public static EmojiInfo getNextEmoji(CharSequence text, int start) {
        for (int i = start; i < text.length(); ++i) {
            CharSequence chars = text.subSequence(i, text.length());
            String emojiMatched = emojiTree.match(chars);
            if (emojiMatched == null || emojiMatched.isEmpty()) continue;
            return new EmojiInfo(emojiMatched, i);
        }
        return null;
    }

    public static void split(String s, Consumer<String> processText, Consumer<String> processEmoji) {
        if (s == null || s.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < s.length()) {
            EmojiInfo next = EmojiHelper.getNextEmoji(s, i);
            int endOfText = next == null ? s.length() : next.start();
            String text = s.substring(i, endOfText);
            if (!text.isEmpty()) {
                processText.accept(text);
            }
            if (next == null) break;
            String emoji = next.emoji();
            processEmoji.accept(emoji);
            i = next.end();
        }
    }

    public static String emojiAsHex(String emoji) {
        StringBuilder hex = new StringBuilder();
        for (int i = 0; i < emoji.length(); ++i) {
            char c = emoji.charAt(i);
            hex.append(String.format("0x%04x ", c));
        }
        return hex.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Image getImage(String emoji, double size) {
        EmojiKey key = new EmojiKey(emoji, EmojiSize.getSize(size));
        Image image3 = emojiCache.get(key);
        if (image3 != null) {
            return image3;
        }
        EmojiSize emojiSize = EmojiSize.getSize(size);
        String name = EmojiHelper.getEmojiFileName(emoji, emojiSize);
        if (name == null) {
            Logger.w((String)String.format("Cannot found emoji file for %s (%s)", emoji, EmojiHelper.emojiAsHex(emoji)));
            return null;
        }
        try (InputStream is = EmojiHelper.class.getResourceAsStream(name);){
            if (is == null) {
                Logger.w((String)("Cannot found resource for " + name));
                Image image2 = null;
                return image2;
            }
            Image val = new Image(is);
            emojiCache.put(key, val);
            Image image = val;
            return image;
        }
        catch (IOException e) {
            Logger.e((String)("Cannot read resource for " + name), (Exception)e);
            return null;
        }
    }

    static {
        for (String emoji : emojiNotoConverter.keySet()) {
            emojiTree.put(emoji);
        }
    }

    public static enum EmojiSize {
        _32(32),
        _72(72),
        _128(128);

        public final int size;

        private EmojiSize(int size) {
            this.size = size;
        }

        static EmojiSize getSize(double size) {
            double expectedSize = size * 2.0;
            for (EmojiSize emojiSize : EmojiSize.values()) {
                if (!((double)emojiSize.size >= expectedSize)) continue;
                return emojiSize;
            }
            return _128;
        }
    }

    public static class CharTree {
        public final Map<Character, CharTree> children = new HashMap<Character, CharTree>();
        public String value = null;

        public void put(CharSequence path) {
            this.putImpl(path, path);
        }

        private void putImpl(CharSequence path, CharSequence value) {
            boolean isLast;
            if (path.isEmpty()) {
                return;
            }
            char head = path.charAt(0);
            CharTree subtree = this.children.get(Character.valueOf(head));
            if (subtree == null) {
                subtree = new CharTree();
                this.children.put(Character.valueOf(head), subtree);
            }
            boolean bl = isLast = path.length() == 1;
            if (isLast) {
                subtree.value = String.valueOf(value);
            } else {
                CharSequence tail = path.subSequence(1, path.length());
                subtree.putImpl(tail, value);
            }
        }

        public CharTree get(CharSequence text) {
            if (text.isEmpty()) {
                return this;
            }
            char head = text.charAt(0);
            CharTree subtree = this.children.get(Character.valueOf(head));
            if (subtree == null) {
                return this;
            }
            CharSequence tail = text.subSequence(1, text.length());
            return subtree.get(tail);
        }

        public String match(CharSequence text) {
            CharTree tree = this.get(text);
            if (tree == null) {
                return null;
            }
            return tree.value;
        }
    }

    public record EmojiInfo(String emoji, int start) {
        public int length() {
            return this.emoji.length();
        }

        public int end() {
            return this.start + this.emoji.length();
        }
    }

    record EmojiKey(String emoji, EmojiSize size) {
    }

    public static final class EmojiView
    extends StackPane {
        private final ImageView imageView = new ImageView();
        private final String emoji;
        private DoubleExpression size;

        public EmojiView(String emoji) {
            this.emoji = emoji;
            this.getChildren().add((Object)this.imageView);
            this.setAlignment(Pos.CENTER);
        }

        public String getEmoji() {
            return this.emoji;
        }

        public void configure(DoubleExpression size) {
            this.size = size;
            this.imageView.fitHeightProperty().bind((ObservableValue)size);
            this.imageView.fitWidthProperty().bind((ObservableValue)size);
            this.imageView.imageProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
                if (size.getValue() == null) {
                    return null;
                }
                Watches.Watch watch = Watches.getInstance().start("EmojiView::getImage");
                Image image = EmojiHelper.getImage(this.emoji, size.getValue());
                watch.stop();
                return image;
            }, (Observable[])new Observable[]{size}));
        }

        public double getBaselineOffset() {
            double baselineOffset = super.getBaselineOffset();
            Parent parent = this.getParent();
            if (!(parent instanceof TextFlow)) {
                return baselineOffset;
            }
            TextFlow textFlow = (TextFlow)parent;
            Optional<Node> otherText = textFlow.getChildren().stream().filter(Text.class::isInstance).findAny();
            if (otherText.isEmpty()) {
                return baselineOffset;
            }
            if (this.size != null && textFlow.getHeight() > this.size.getValue()) {
                double v = baselineOffset - this.size.getValue() / 5.0;
                return v;
            }
            return baselineOffset;
        }
    }
}

