/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.main_layer.left_panel;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.fx.contacts.ContactsTabController;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.custom_components.custom_context_menu.ContextMenuFactory;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionTabController;
import io.olvid.windows.messenger.fx.framework.animation.AnimationConfiguration;
import io.olvid.windows.messenger.fx.framework.animation.AnimationUtils;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.framework.view_controller.ViewControllerManager;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.groups.GroupTabController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.main_layer.left_panel.NavBarModel;
import io.olvid.windows.messenger.fx.main_stack.main_layer.left_panel.tabs_management.BaseNavBarTab;
import io.olvid.windows.messenger.fx.main_stack.main_layer.left_panel.tabs_management.NavBarTab;
import io.olvid.windows.messenger.fx.owned_identities.OwnedIdentityCardController;
import io.olvid.windows.messenger.fx.settings.SettingsModalController;
import io.olvid.windows.messenger.fx.settings.misc.MuteDuration;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.state_pattern.SimpleContext;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class LeftPanelController
extends BaseViewController {
    public static final double ANIMATION_DURATION = 150.0;
    public static final Color GREY = Color.rgb((int)139, (int)141, (int)151, (double)1.0);
    public static final Color BLACK = Color.BLACK;
    public static final String NAV_BUTTON_SELECTED_CLASS = "nav-button-selected";
    private final SimpleContext<NavBarTab> tabSelectionContext = new SimpleContext();
    LiveDataListener<NavBarTab> navBarTabChangeHandler = this::navBarTabChangeHandler;
    LiveDataListener<AppRuntimeHelper.AppVersionInfo> appVersionInfoListener = this::appVersionInfoLiveDataListener;
    final BooleanProperty updateNeeded = new SimpleBooleanProperty(false);
    private final ViewControllerManager<String> viewManager = new ViewControllerManager(ViewControllerManager.ManagementMode.LAZY);
    private Button settingTabButton;
    SvgSizeable settingIcon = new SvgSizeable();
    @FXML
    VBox tab_icon_container;
    @FXML
    ToggleButton profile_toggle;
    @FXML
    StackPane tab_container;
    @FXML
    private Region root;
    private Button mute = new Button();
    private IdentityBubble ownedIdentityBubble;
    private final LiveDataListener<Optional<OwnedIdentityInfo>> ownedIdentityLiveDataListener = this::onChange;
    private Rectangle iconBackground;
    private final NavBarModel navBarModel = new NavBarModel(this.ownedIdentityLiveDataListener);
    private TranslateTransition navBarButtonTransition;

    public LeftPanelController() {
        this.mute.getStyleClass().add((Object)"nav-button");
        SvgSizeable muteIcon = new SvgSizeable();
        muteIcon.getStyleClass().addAll((Object[])new String[]{"svg-bell-off", "icon-large", "icon-grey"});
        this.mute.setGraphic((Node)muteIcon);
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        AppLogger.d("LeftPanelController::initialize()");
        super.initialize(location, resources);
        this.initBubble();
        this.initializeNavBarTab();
        this.root.minWidthProperty().set(400.0);
        this.root.maxWidthProperty().set(568.0);
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        LiveData<Optional> muteLiveData = LiveDataFactory.buildDbLiveDataItemField(() -> DbManager.getInstance().getApplicationSettingsDao().getAppConfigSettingItem(ApplicationSetting.GlobalAppSettings.MUTE_NOTIFICATION_TIMESTAMP), List.of(ApplicationSetting.class));
        muteLiveData.addListener((newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(() -> {
            if (newValue.isEmpty()) {
                ViewControllerHelper.hideNode((Node)this.mute);
                return;
            }
            ViewControllerHelper.showNode((Node)this.mute);
        }));
        this.mute.setOnContextMenuRequested(event -> ContextMenuFactory.loadContextMenuWithScreenCoordinates(event.getScreenX(), event.getScreenY(), List.of(MuteDuration.NONE.getFxMenuItem())));
        AppRuntimeHelper.appVersionInfo.addListener(this.appVersionInfoListener);
    }

    @Override
    public void onLayoutDetached() {
        AppRuntimeHelper.appVersionInfo.removeListener(this.appVersionInfoListener);
    }

    private void initializeNavBarTab() {
        BaseNavBarTab[] navBarTabList = this.initTab();
        this.initTransitionAnimation();
        this.tabSelectionContext.getCurrentStateLiveData().addListener(this.navBarTabChangeHandler);
        HashMap controllerFactories = new HashMap(2);
        Arrays.stream(navBarTabList).forEach(tab -> {
            tab.getNavBarButton().setOnAction(event -> this.tabSelectionContext.pushState((NavBarTab)tab));
            controllerFactories.put(tab.getClass().getName(), () -> tab);
            this.tab_icon_container.getChildren().add((Object)tab.getNavBarButton());
        });
        Region spacer = new Region();
        VBox.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.tab_icon_container.getChildren().add((Object)spacer);
        this.tab_icon_container.getChildren().add((Object)this.mute);
        this.initSettingTab();
        this.viewManager.registerChildrenControllers(controllerFactories);
        this.tabSelectionContext.pushState(navBarTabList[0]);
        Arrays.stream(navBarTabList).forEach(it -> it.getNavBarButtonIcon().setPaint((Paint)GREY));
    }

    private void appVersionInfoLiveDataListener(AppRuntimeHelper.AppVersionInfo newVal, AppRuntimeHelper.AppVersionInfo oldVal) {
        if (newVal == null) {
            return;
        }
        if (AppRuntimeHelper.notifyNewVersion && newVal.updateNeeded()) {
            this.updateNeeded.set(true);
        }
    }

    private void initSettingTab() {
        this.settingTabButton = new Button();
        this.settingTabButton.getStyleClass().addAll((Object[])new String[]{"setting-nav-button"});
        StackPane stackPane = new StackPane();
        Circle redCircle = new Circle(5.0);
        redCircle.getStyleClass().add((Object)"red-circle");
        redCircle.visibleProperty().bind((ObservableValue)this.updateNeeded);
        redCircle.setTranslateX(10.0);
        redCircle.setTranslateY(-7.0);
        stackPane.getChildren().addAll((Object[])new Node[]{this.settingIcon, redCircle});
        this.settingIcon.getStyleClass().add((Object)"svg-settings1");
        this.settingIcon.setPaint((Paint)GREY);
        this.settingTabButton.setGraphic((Node)stackPane);
        this.settingTabButton.setOnMouseClicked(event -> NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new SettingsModalController(), true)));
        this.tab_icon_container.getChildren().add((Object)this.settingTabButton);
    }

    private void navBarTabChangeHandler(NavBarTab newNavBarTab, NavBarTab navBarTab) {
        ViewControllerHelper.smartUIUpdate(() -> {
            if (newNavBarTab != null) {
                newNavBarTab.getNavBarButton().getStyleClass().add((Object)NAV_BUTTON_SELECTED_CLASS);
            }
            if (navBarTab != null) {
                navBarTab.getNavBarButton().getStyleClass().remove((Object)NAV_BUTTON_SELECTED_CLASS);
            }
            AppLogger.d("Switch from tab %s to tab %s".formatted(navBarTab, newNavBarTab));
            this.switchTab(newNavBarTab);
            this.switchTabButtonBackground(newNavBarTab, navBarTab);
        });
    }

    private void initTransitionAnimation() {
        this.iconBackground = new Rectangle(64.0, 64.0);
        this.iconBackground.setArcHeight(32.0);
        this.iconBackground.setArcWidth(32.0);
        this.iconBackground.setFill((Paint)Color.WHITE);
        this.iconBackground.setManaged(false);
        this.navBarButtonTransition = new TranslateTransition(Duration.millis((double)150.0), (Node)this.iconBackground);
    }

    private void switchTabButtonBackground(NavBarTab newValue, NavBarTab oldValue) {
        if (!this.tab_icon_container.getChildren().contains((Object)this.iconBackground) && newValue != null) {
            Button newButton = newValue.getNavBarButton();
            this.iconBackground.widthProperty().bind((ObservableValue)newButton.widthProperty());
            this.iconBackground.heightProperty().bind((ObservableValue)newButton.heightProperty());
            Bounds oldPos = newButton.getBoundsInParent();
            this.tab_icon_container.getChildren().add(0, (Object)this.iconBackground);
            this.iconBackground.setTranslateX(oldPos.getMinX());
            this.iconBackground.setTranslateY(oldPos.getMinY());
            newValue.getNavBarButtonIcon().setPaint((Paint)BLACK);
        }
        if (oldValue != null && newValue != null && oldValue != newValue) {
            this.navBarButtonTransition.setFromY(this.iconBackground.getTranslateY());
            this.navBarButtonTransition.setFromX(this.iconBackground.getTranslateX());
            this.navBarButtonTransition.setInterpolator(Interpolator.EASE_BOTH);
            Bounds newPos = newValue.getNavBarButton().getBoundsInParent();
            this.navBarButtonTransition.setToX(newPos.getMinX());
            this.navBarButtonTransition.setToY(newPos.getMinY());
            AnimationUtils.PaneColorTransition newButtonColor = new AnimationUtils.PaneColorTransition(newValue.getNavBarButtonIcon(), GREY, BLACK, 150.0);
            AnimationUtils.PaneColorTransition oldButtonColor = new AnimationUtils.PaneColorTransition(oldValue.getNavBarButtonIcon(), BLACK, GREY, 150.0);
            ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{this.navBarButtonTransition, newButtonColor, oldButtonColor});
            parallelTransition.play();
        }
    }

    private void switchTab(NavBarTab navBarTab) {
        if (navBarTab == null) {
            return;
        }
        this.viewManager.replaceView(navBarTab.getClass().getName(), (Pane)this.tab_container, AnimationConfiguration.AnimationEnumType.FADE_IN, null);
    }

    public BaseNavBarTab[] initTab() {
        DiscussionTabController discussion = new DiscussionTabController();
        ContactsTabController contact = new ContactsTabController();
        GroupTabController group = new GroupTabController();
        return new BaseNavBarTab[]{discussion, contact, group};
    }

    private void initBubble() {
        this.ownedIdentityBubble = new IdentityBubble(25.0);
        this.ownedIdentityBubble.setOnMouseClicked(this::onOwnedIdentityClicked);
        this.profile_toggle.setGraphic((Node)this.ownedIdentityBubble);
        VBox.setMargin((Node)this.profile_toggle, (Insets)new Insets(0.0, 0.0, 0.0, 4.0));
    }

    private void onOwnedIdentityClicked(MouseEvent mouseEvent) {
        OwnedIdentityCardController ownedIdentityCardController = new OwnedIdentityCardController();
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(ownedIdentityCardController, true));
    }

    private void onChange(Optional<OwnedIdentityInfo> newValue, Optional<OwnedIdentityInfo> oldValue) {
        if (DiffUtils.areContentTheSame(newValue, oldValue)) {
            return;
        }
        if (newValue.isPresent()) {
            ViewControllerHelper.smartUIUpdate(() -> BubbleUtils.setBubbleData((OwnedIdentityInfo)newValue.get(), this.ownedIdentityBubble));
        }
    }
}

