/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync;

import io.olvid.engine.encoder.Encoded;
import io.olvid.windows.messenger.engine.api.TransferApi;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlowModel;
import io.olvid.windows.messenger.fx.modal.confirmation.keycloak.KeycloakAuthenticationConfirmationModalModel;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.protocol.TransferRestrictedAuthenticationProtocol;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.UUID;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class RestrictedTransferAuthenticationRequiredModel
implements NotificationListener<TransferRestrictedAuthenticationProtocol.KeycloakTransfertRestrictedAuthenticationNotification> {
    private final AppLogger logger = new AppLogger(KeycloakAuthenticationConfirmationModalModel.class);
    public final BooleanProperty loading = new SimpleBooleanProperty(false);
    public final StringProperty errorLabel = new SimpleStringProperty();
    public final BooleanProperty success = new SimpleBooleanProperty(false);
    public final BooleanProperty failed = new SimpleBooleanProperty(false);
    public final BooleanProperty showManualRedirectInput = new SimpleBooleanProperty(false);
    public final StringProperty redirectInput = new SimpleStringProperty();
    final IdentityManagementFlowModel identityManagementFlowModel;
    public boolean isRetry = false;

    public RestrictedTransferAuthenticationRequiredModel(IdentityManagementFlowModel identityManagementFlowModel) {
        this.logger.info("KeycloakAuthenticationConfirmationModalModel::new");
        this.identityManagementFlowModel = identityManagementFlowModel;
    }

    @Override
    public void onReceived(TransferRestrictedAuthenticationProtocol.KeycloakTransfertRestrictedAuthenticationNotification keycloakTransfertRestrictedAuthenticationNotification) {
        this.logger.debug("RestrictedTransferAuthenticationRequiredModel::onReceived received enrollement notification : %s", keycloakTransfertRestrictedAuthenticationNotification.getNotificationType());
        ViewControllerHelper.smartUIUpdate(() -> {
            TransferRestrictedAuthenticationProtocol.KeycloakTransfertRestrictedAuthenticationNotification keycloakTransfertRestrictedAuthenticationNotification2 = keycloakTransfertRestrictedAuthenticationNotification;
            Objects.requireNonNull(keycloakTransfertRestrictedAuthenticationNotification2);
            TransferRestrictedAuthenticationProtocol.KeycloakTransfertRestrictedAuthenticationNotification selector0$temp = keycloakTransfertRestrictedAuthenticationNotification2;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TransferRestrictedAuthenticationProtocol.BuildingAuthenticationUrl.class, TransferRestrictedAuthenticationProtocol.WaitingForTransferUserAuthentication.class, TransferRestrictedAuthenticationProtocol.VerifyingAuthenticationProofForTransfer.class, TransferRestrictedAuthenticationProtocol.TransferAuthenticationFailure.class, TransferRestrictedAuthenticationProtocol.TransferAuthenticationSuccess.class}, (Object)selector0$temp, index$1)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    TransferRestrictedAuthenticationProtocol.BuildingAuthenticationUrl buildingAuthenticationUrl = (TransferRestrictedAuthenticationProtocol.BuildingAuthenticationUrl)selector0$temp;
                    this.identityManagementFlowModel.setSubText(ViewControllerHelper.getString("discovering_keycloak_server"));
                    break;
                }
                case 1: {
                    TransferRestrictedAuthenticationProtocol.WaitingForTransferUserAuthentication waitingForTransferUserAuthentication = (TransferRestrictedAuthenticationProtocol.WaitingForTransferUserAuthentication)selector0$temp;
                    this.errorLabel.set(null);
                    this.failed.set(false);
                    this.identityManagementFlowModel.setSubText("waiting_for_user_authentication_label");
                    try {
                        AppRuntimeHelper.launchBrowser(waitingForTransferUserAuthentication.authRequest());
                    }
                    catch (IOException e) {
                        this.errorLabel.set((Object)ViewControllerHelper.getString("open_browser_failed_label"));
                    }
                    break;
                }
                case 2: {
                    TransferRestrictedAuthenticationProtocol.VerifyingAuthenticationProofForTransfer verifyingAuthenticationProofForTransfer = (TransferRestrictedAuthenticationProtocol.VerifyingAuthenticationProofForTransfer)selector0$temp;
                    this.errorLabel.set(null);
                    this.identityManagementFlowModel.setSubText("verifying_authentication_proof_label");
                    break;
                }
                case 3: {
                    TransferRestrictedAuthenticationProtocol.TransferAuthenticationFailure transferAuthenticationFailure = (TransferRestrictedAuthenticationProtocol.TransferAuthenticationFailure)selector0$temp;
                    this.failed.set(true);
                    this.loading.set(false);
                    this.redirectInput.set(null);
                    this.showManualRedirectInput.set(false);
                    switch (transferAuthenticationFailure.rfcError()) {
                        case RFC_INTERNAL_ERROR: 
                        case RFC_INVALID_AUTH_STATE: 
                        case RFC_AUTHENTICATION_REQUIRED: 
                        case RFC_INVALID_DETAILS_SIGNATURE: 
                        case RFC_IDENTITY_NOT_MANAGED: {
                            this.errorLabel.setValue(ViewControllerHelper.getString("keycloak_identity_internal_error_label"));
                            break;
                        }
                        case RFC_NETWORK_ERROR: {
                            this.errorLabel.setValue(ViewControllerHelper.getString("keycloak_network_error_label"));
                            break;
                        }
                        case RFC_BAD_RESPONSE: 
                        case RFC_SERVER_ERROR: {
                            this.errorLabel.setValue(ViewControllerHelper.getString("keycloak_bad_response_label"));
                            break;
                        }
                        case RFC_IDENTITY_ALREADY_UPLOADED: {
                            this.errorLabel.setValue(ViewControllerHelper.getString("on_boarding_flow_keycloak_already_uploaded"));
                            break;
                        }
                        case RFC_IDENTITY_REVOKED: {
                            this.errorLabel.setValue(ViewControllerHelper.getString("keycloak_binding_error_identity_revoked_text_label"));
                            break;
                        }
                        case RFC_BAD_REDIRECT_URL: {
                            this.errorLabel.setValue(ViewControllerHelper.getString("keycloak_authentication_failed_bad_redirect"));
                            break;
                        }
                        case RFC_INTTERUPTED: {
                            this.logger.debug("RestrictedTransferAuthenticationRequiredModel::onReceived protocol interrupted (prolly by user)");
                        }
                    }
                    break;
                }
                case 4: {
                    TransferRestrictedAuthenticationProtocol.TransferAuthenticationSuccess transferAuthenticationSuccess = (TransferRestrictedAuthenticationProtocol.TransferAuthenticationSuccess)selector0$temp;
                    this.errorLabel.set(null);
                    this.success.set(true);
                }
            }
        });
    }

    public void startProtocol() {
        this.loading.set(true);
        if (this.isRetry) {
            KeycloakManager.getInstance().stopTransferAuthenticationProtocol();
        }
        ViewControllerHelper.smartUIUpdate(() -> this.loading.set(true));
        KeycloakManager.getInstance().startTransferAuthenticationProtocol((String)this.identityManagementFlowModel.identitySyncModel.keycloakServerUrl.get(), (String)this.identityManagementFlowModel.identitySyncModel.keycloakClientId.get(), (String)this.identityManagementFlowModel.identitySyncModel.keycloakClientSecret.get(), (String)this.identityManagementFlowModel.identitySyncModel.sas.get(), (String)this.identityManagementFlowModel.identitySyncModel.sessionNumber.get(), BytesKey.of((byte[])this.identityManagementFlowModel.identitySyncModel.bytesOwnedIdentity.get()), (TransferApi.Step)this.identityManagementFlowModel.identitySyncModel.step.get(), (UUID)this.identityManagementFlowModel.identitySyncModel.dialogUUID.get(), (Encoded)this.identityManagementFlowModel.identitySyncModel.encodedElements.get(), this);
        this.isRetry = true;
    }
}

