/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync;

import io.olvid.windows.messenger.database.tables.OwnedDevice;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Objects;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;

public class RenameDeviceController
extends BaseModalController {
    private static final double BUTTON_HEIGHT = 55.0;
    private static final double DIALOG_MAX_WIDTH = 500.0;
    private static final double DIALOG_MAX_HEIGHT = 200.0;
    private static final double GAP = 16.0;
    private static final Insets HEADER_PAD = new Insets(8.0, 12.0, 8.0, 12.0);
    private static final Insets FORM_PAD = new Insets(8.0, 12.0, 0.0, 12.0);
    private static final Insets CTX_PAD = new Insets(0.0, 12.0, 12.0, 12.0);
    private static final Insets BUTTONS_PAD = new Insets(12.0, 24.0, 12.0, 24.0);
    private final OwnedIdentityInfo ownedIdentityInfo;
    private final OwnedDevice ownedDevice;
    private final StackPane root = new StackPane();
    private final TextField nameField = new TextField();
    private final Button validateButton = new Button("save");
    private final Button cancelButton = new Button("cancel");

    public RenameDeviceController(OwnedIdentityInfo ownedIdentityInfo, OwnedDevice ownedDevice, String deviceName) {
        Objects.requireNonNull(ownedIdentityInfo);
        Objects.requireNonNull(ownedDevice);
        this.ownedIdentityInfo = ownedIdentityInfo;
        this.ownedDevice = ownedDevice;
        this.setSize(ModalConfiguration.ModalSize.SELF_SIZE);
        HBox header = this.buildHeader();
        HBox form = this.buildForm();
        HBox buttons = this.buildButtons();
        VBox contextContainer = new VBox(16.0, new Node[]{form, buttons});
        contextContainer.setPadding(CTX_PAD);
        VBox containerAll = new VBox(16.0, new Node[]{header, contextContainer});
        containerAll.setFillWidth(true);
        this.root.getChildren().add((Object)containerAll);
        this.root.getStyleClass().addAll((Object[])new String[]{"modal-contextual-background"});
        this.root.getStylesheets().add((Object)"fx/modal/modal.css");
        this.root.setMaxWidth(500.0);
        this.root.setMaxHeight(200.0);
        this.validateButton.setDefaultButton(true);
        this.cancelButton.setCancelButton(true);
        this.nameField.requestFocus();
        this.nameField.setText(deviceName);
    }

    private HBox buildHeader() {
        Label title = new Label(ViewControllerHelper.getString("rename_device_title"));
        title.getStyleClass().add((Object)"h1");
        title.setAlignment(Pos.CENTER);
        title.setTextAlignment(TextAlignment.CENTER);
        title.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)title, (Priority)Priority.ALWAYS);
        HBox header = new HBox(new Node[]{title});
        header.setPadding(HEADER_PAD);
        return header;
    }

    private HBox buildForm() {
        VBox fieldBox = this.createField("input_device_name", this.nameField, "input_prompt_device_name", null);
        this.nameField.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)fieldBox, (Priority)Priority.ALWAYS);
        HBox form = new HBox(12.0, new Node[]{fieldBox});
        form.setPadding(FORM_PAD);
        return form;
    }

    private HBox buildButtons() {
        this.cancelButton.setText(ViewControllerHelper.getString("cancel"));
        this.cancelButton.getStyleClass().add((Object)"secondary-button");
        this.cancelButton.setPrefHeight(55.0);
        this.cancelButton.setMinHeight(55.0);
        this.cancelButton.setMaxHeight(55.0);
        this.validateButton.setText(ViewControllerHelper.getString("button_confirm_rename_device"));
        this.validateButton.getStyleClass().add((Object)"primary-button");
        this.validateButton.setPrefHeight(55.0);
        this.validateButton.setMinHeight(55.0);
        this.validateButton.setMaxHeight(55.0);
        this.cancelButton.setOnAction(e -> this.closeModalDelegate.run());
        this.validateButton.setOnAction(e -> {
            this.closeModalDelegate.run();
            Api.getDeviceApi().renameOwnedDevice(this.ownedIdentityInfo.bytesOwnedIdentity(), this.ownedDevice.getBytesDeviceUid(), this.nameField.getText());
        });
        Region sep = new Region();
        HBox.setHgrow((Node)sep, (Priority)Priority.ALWAYS);
        HBox buttons = new HBox(12.0, new Node[]{this.cancelButton, sep, this.validateButton});
        buttons.getStyleClass().add((Object)"button-container");
        buttons.setPadding(BUTTONS_PAD);
        return buttons;
    }

    private VBox createField(String labelText, TextField field, String promptKey, Label mandatoryMessage) {
        Label label = new Label(ViewControllerHelper.getString(labelText));
        if (promptKey != null) {
            field.setPromptText(ViewControllerHelper.getString(promptKey));
        }
        field.getStyleClass().add((Object)"text-field-header-label");
        VBox box = new VBox(2.0);
        if (mandatoryMessage != null) {
            Label star = new Label("*");
            star.getStyleClass().add((Object)"label-asterisk");
            HBox header = new HBox(6.0, new Node[]{label, star});
            header.setPrefWidth(400.0);
            box.getChildren().addAll((Object[])new Node[]{header, field});
            mandatoryMessage.getStyleClass().add((Object)"error-text");
            mandatoryMessage.setVisible(false);
            mandatoryMessage.setManaged(false);
            box.getChildren().add((Object)mandatoryMessage);
        } else {
            box.getChildren().addAll((Object[])new Node[]{label, field});
        }
        return box;
    }

    @Override
    public Region getLayout() {
        AppLogger.d("get layout");
        return this.root;
    }
}

