/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync;

import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.IdentitySyncModel;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.misc.DeviceUtils;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

@FXMLView(path="fx/main_stack/identity_management_layer/sync/choose_device_name.fxml")
public class ChooseDeviceNameController
extends BaseModalController {
    public static final DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("on_boarding_flow_sync_target_choose_name_title", null, "on_boarding_flow_sync_target_choose_name_subText", null, null);
    @FXML
    private VBox choose_device_name_vbox;
    @FXML
    private TextField device_name;
    @FXML
    private Button choose_device_name_button;
    private final IdentitySyncModel model;

    public ChooseDeviceNameController(IdentitySyncModel identitySyncModel) {
        this.model = identitySyncModel;
        this.loadFxml();
        this.device_name.setPromptText(DeviceUtils.getSystemDeviceName());
        this.choose_device_name_button.setOnAction(this::validateDeviceName);
    }

    private void validateDeviceName(ActionEvent event) {
        String name = this.device_name.getText();
        this.model.deviceName.set((Object)this.device_name.getText());
        if (name == null || name.isEmpty() || name.trim().isEmpty()) {
            name = this.device_name.getPromptText();
        }
        Api.getTransferApi().initiateOwnedIdentityTransferProtocolOnTargetDevice(name);
    }

    @Override
    public Region getLayout() {
        return this.choose_device_name_vbox;
    }

    @Override
    public void onLayoutAttached() {
        this.device_name.setText(this.model.deviceName.getValue());
    }
}

