/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.OwnedDevice;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.BuilderInterface;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.IdentitySyncModel;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.owned_identities.DeviceInfo;
import io.olvid.windows.messenger.fx.owned_identities.DeviceInfoCell;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

@FXMLView(path="fx/main_stack/identity_management_layer/sync/active_device_selection.fxml")
public class ActiveDeviceSelectionController
extends BaseModalController {
    @FXML
    private VBox active_device_selection_vbox;
    @FXML
    protected Button active_device_selection_button;
    @FXML
    private StackPane list_place_holder;
    public static final DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("onboarding_transfer_devices_title", null, "onboarding_transfer_devices_subtitle", null, null);
    LiveData<List<DeviceInfo>> ownedDeviceListLiveData;
    StandardPanelListController<DeviceInfo> deviceListController;
    final IdentitySyncModel model;

    public ActiveDeviceSelectionController(IdentitySyncModel identitySyncModel) {
        Objects.requireNonNull(identitySyncModel);
        this.model = identitySyncModel;
        this.loadFxml();
        this.active_device_selection_button.setOnAction(this::confirmAction);
        this.configure();
    }

    protected final StandardPanelListController<DeviceInfo> buildDeviceListController() {
        this.ownedDeviceListLiveData = LiveDataFactory.buildDbLiveDataItemField(() -> {
            Optional<OwnedIdentityInfo> ownedIdentityInfo = this.model.getOwnedIdentityInfo();
            if (ownedIdentityInfo.isEmpty()) {
                return List.of();
            }
            List<OwnedDevice> ownedDevices = DbManager.getInstance().getOwnedDeviceDao().getAllSync(ownedIdentityInfo.get().genId());
            ArrayList<DeviceInfo> deviceInfos = new ArrayList<DeviceInfo>(ownedDevices.stream().map(DeviceInfo::new).toList());
            this.addAdditionalDevice(deviceInfos);
            return deviceInfos;
        }, List.of(OwnedDevice.class));
        BuilderInterface.Sortable<DeviceInfo> builder = StandardPanelListController.builder().withLiveData(this.ownedDeviceListLiveData).withDataClass(DeviceInfo.class).withCellFactory((Callback<ListView<DeviceInfo>, AbstractListCell<DeviceInfo>>)((Callback)param -> new DeviceInfoCell(!this.model.multiDevice.get()))).withoutBottomMargin();
        if (this.model.multiDevice.get()) {
            return builder.defaultComparator().noFilter().withoutSearch().withoutSelection().withoutButton().build();
        }
        return builder.defaultComparator().noFilter().withoutSearch().withSingleSelection().withDisableUnselect(false).withoutButton().build();
    }

    protected void configure() {
        this.active_device_selection_button.setText(ViewControllerHelper.getString("button_label_proceed"));
    }

    protected void confirmAction(ActionEvent event) {
        ObservableSet<DeviceInfo> selectedItems = this.deviceListController.getSelectionModel().getSelectedItems();
        if (selectedItems.size() != 1) {
            throw new IllegalStateException();
        }
        this.model.deviceToKeepActive.set((Object)((DeviceInfo)selectedItems.iterator().next()));
        this.model.context.pushState(IdentityManagementFlow.SYNC_SOURCE, IdentityManagementFlow.SyncSourceState.CONFIRMATION);
    }

    protected void addAdditionalDevice(List<DeviceInfo> deviceInfos) {
        if (this.model.targetDeviceName.get() != null) {
            deviceInfos.add(new DeviceInfo((String)this.model.targetDeviceName.get(), Optional.empty(), false, Optional.empty()));
        }
    }

    @Override
    public Region getLayout() {
        return this.active_device_selection_vbox;
    }

    @Override
    public void onLayoutAttached() {
        super.onLayoutAttached();
        this.deviceListController = this.buildDeviceListController();
        if (this.list_place_holder.getChildren().isEmpty()) {
            this.list_place_holder.getChildren().add(0, (Object)this.deviceListController.getLayout());
        } else {
            this.list_place_holder.getChildren().set(0, (Object)this.deviceListController.getLayout());
        }
        this.active_device_selection_button.disableProperty().bind((ObservableValue)this.deviceListController.getSelectionModel().hasSelectedItemsProperty().not().and((ObservableBooleanValue)this.model.multiDevice.not()));
    }

    @Override
    public void onLayoutDetached() {
        super.onLayoutDetached();
        this.deviceListController.getSelectionModel().clearSelection();
    }
}

